/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.db2;

import java.lang.reflect.Method;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;
import org.geotools.util.factory.Hints;

public class DB2BlobConverterFactory
implements ConverterFactory {
    DB2BlobConverter converter = new DB2BlobConverter();
    static final Class<?> DB2_BLOB;
    static final Method DB2_GET_BYTES;
    static final Method DB2_LENGTH;

    public Converter createConverter(Class<?> source, Class<?> target, Hints hints) {
        if (DB2_BLOB == null) {
            return null;
        }
        if (!byte[].class.equals(target)) {
            return null;
        }
        if (!DB2_BLOB.isAssignableFrom(source)) {
            return null;
        }
        return this.converter;
    }

    static {
        Class<?> db2BlobClass = null;
        try {
            db2BlobClass = Class.forName("com.ibm.db2.jcc.DB2Blob");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (db2BlobClass == null) {
            DB2_BLOB = null;
            DB2_GET_BYTES = null;
            DB2_LENGTH = null;
        } else {
            try {
                DB2_BLOB = db2BlobClass;
                DB2_LENGTH = DB2_BLOB.getMethod("length", new Class[0]);
                DB2_GET_BYTES = DB2_BLOB.getMethod("getBytes", Long.TYPE, Integer.TYPE);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not initialize the db2 blob converter", e);
            }
        }
    }

    class DB2BlobConverter
    implements Converter {
        DB2BlobConverter() {
        }

        public <T> T convert(Object source, Class<T> target) throws Exception {
            int length = ((Long)DB2_LENGTH.invoke(source, new Object[0])).intValue();
            return target.cast(DB2_GET_BYTES.invoke(source, 1L, length));
        }
    }
}

