/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld.parse;

import org.geotools.api.style.ExternalGraphic;
import org.geotools.api.style.Graphic;
import org.geotools.api.style.Mark;
import org.geotools.ysld.YamlMap;
import org.geotools.ysld.YamlObject;
import org.geotools.ysld.YamlSeq;
import org.geotools.ysld.parse.ExternalGraphicParser;
import org.geotools.ysld.parse.Factory;
import org.geotools.ysld.parse.MarkParser;
import org.geotools.ysld.parse.Util;
import org.geotools.ysld.parse.YamlParseContext;
import org.geotools.ysld.parse.YamlParseHandler;
import org.geotools.ysld.parse.YsldParseHandler;

public class GraphicParser
extends YsldParseHandler {
    Graphic g;

    GraphicParser(Factory factory) {
        this(factory, factory.styleBuilder.createGraphic(null, null, null));
    }

    GraphicParser(Factory factory, Graphic g) {
        super(factory);
        this.g = g;
    }

    protected void graphic(Graphic g) {
    }

    @Override
    public void handle(YamlObject<?> obj, YamlParseContext context) {
        this.graphic(this.g);
        YamlMap map = obj.map();
        if (map.has("anchor")) {
            this.g.setAnchorPoint(Util.anchor(map.get("anchor"), this.factory));
        }
        if (map.has("opacity")) {
            this.g.setOpacity(Util.expression(map.str("opacity"), this.factory));
        }
        if (map.has("size")) {
            this.g.setSize(Util.expression(map.str("size"), this.factory));
        }
        if (map.has("displacement")) {
            this.g.setDisplacement(Util.displacement(map.get("displacement"), this.factory));
        }
        if (map.has("rotation")) {
            this.g.setRotation(Util.expression(map.str("rotation"), this.factory));
        }
        if (map.has("gap")) {
            this.g.setGap(Util.expression(map.str("gap"), this.factory));
        }
        if (map.has("initial-gap")) {
            this.g.setInitialGap(Util.expression(map.str("initial-gap"), this.factory));
        }
        context.push("symbols", (YamlParseHandler)new SymbolsParser());
    }

    class SymbolsParser
    extends YsldParseHandler {
        protected SymbolsParser() {
            super(GraphicParser.this.factory);
        }

        @Override
        public void handle(YamlObject<?> obj, YamlParseContext context) {
            YamlSeq seq = obj.seq();
            for (YamlObject<Object> o : seq) {
                context.push(o, "mark", new MarkParser(this.factory){

                    @Override
                    protected void mark(Mark mark) {
                        GraphicParser.this.g.graphicalSymbols().add(mark);
                    }
                });
                context.push(o, "external", new ExternalGraphicParser(this.factory){

                    @Override
                    protected void externalGraphic(ExternalGraphic externalGraphic) {
                        GraphicParser.this.g.graphicalSymbols().add(externalGraphic);
                    }
                });
            }
        }
    }
}

