/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld.encode;

import org.geotools.api.style.Graphic;
import org.geotools.ysld.encode.AnchorPointEncoder;
import org.geotools.ysld.encode.DisplacementEncoder;
import org.geotools.ysld.encode.SymbolsEncoder;
import org.geotools.ysld.encode.YsldEncodeHandler;

public class GraphicEncoder
extends YsldEncodeHandler<Graphic> {
    final boolean flatten;

    GraphicEncoder(Graphic g) {
        this(g, true);
    }

    GraphicEncoder(Graphic g, Boolean flatten) {
        super(g);
        this.flatten = flatten;
    }

    @Override
    protected void encode(Graphic g) {
        if (!this.flatten) {
            this.push("graphic");
        }
        this.inline(new AnchorPointEncoder(g.getAnchorPoint()));
        this.inline(new DisplacementEncoder(g.getDisplacement()));
        this.put("gap", this.nullIf(g.getGap(), 0.0), this.nullIf(g.getInitialGap(), 0.0));
        this.put("opacity", this.nullIf(g.getOpacity(), 1.0));
        this.put("size", g.getSize());
        this.put("rotation", this.nullIf(g.getRotation(), 0.0));
        this.put("symbols", new SymbolsEncoder(g));
    }
}

