/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld.encode;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.geotools.api.style.StyledLayerDescriptor;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.xml.styling.SLDParser;
import org.geotools.ysld.TestUtils;
import org.geotools.ysld.UomMapper;
import org.geotools.ysld.YamlMap;
import org.geotools.ysld.YamlUtil;
import org.geotools.ysld.Ysld;
import org.geotools.ysld.YsldTests;
import org.geotools.ysld.encode.YsldEncoder;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class YsldEncodeCookbookTest {
    @Test
    public void testPointSimple() throws Exception {
        YamlMap style = this.encode("point", "simple.sld");
        Assert.assertEquals((Object)"SLD Cook Book: Simple Point With Stroke", (Object)style.str("title"));
        YamlMap rule = style.seq("feature-styles").map(0).seq("rules").map(0);
        YamlMap point = rule.seq("symbolizers").map(0).map("point");
        Assert.assertEquals((long)6L, (long)point.integer("size").intValue());
        YamlMap mark = point.seq("symbols").map(0).map("mark");
        Assert.assertEquals((Object)"circle", (Object)mark.str("shape"));
        MatcherAssert.assertThat((Object)mark.get("fill-color"), TestUtils.isColor("FF0000"));
    }

    @Test
    public void testPointWithStroke() throws Exception {
        YamlMap style = this.encode("point", "stroke.sld");
        YamlMap mark = style.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("point").seq("symbols").map(0).map("mark");
        Assert.assertEquals((Object)"circle", (Object)mark.str("shape"));
        MatcherAssert.assertThat((Object)mark.get("fill-color"), TestUtils.isColor("FF0000"));
        MatcherAssert.assertThat((Object)mark.get("stroke-color"), TestUtils.isColor("000000"));
        Assert.assertEquals((long)2L, (long)mark.integer("stroke-width").intValue());
    }

    @Test
    public void testPointWithGraphic() throws Exception {
        YamlMap style = this.encode("point", "graphic.sld");
        YamlMap eg = style.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("point").seq("symbols").map(0).map("external");
        Assert.assertEquals((Object)"image/png", (Object)eg.str("format"));
        Assert.assertEquals((Object)"smileyface.png", (Object)eg.str("url"));
    }

    @Test
    public void testPointWithLegend() throws Exception {
        YamlMap style = this.encode("point", "legend.sld");
        Assert.assertEquals((Object)"Simple Point With Legend Graphic", (Object)style.str("title"));
        YamlMap rule = style.seq("feature-styles").map(0).seq("rules").map(0);
        YamlMap eg = rule.map("legend").seq("symbols").map(0).map("external");
        Assert.assertEquals((Object)"image/png", (Object)eg.str("format"));
        Assert.assertEquals((Object)"smileyface.png", (Object)eg.str("url"));
        YamlMap point = rule.seq("symbolizers").map(0).map("point");
        Assert.assertEquals((long)6L, (long)point.integer("size").intValue());
        YamlMap mark = point.seq("symbols").map(0).map("mark");
        Assert.assertEquals((Object)"circle", (Object)mark.str("shape"));
        MatcherAssert.assertThat((Object)mark.get("fill-color"), TestUtils.isColor("FF0000"));
    }

    @Test
    public void testPointWithScale() throws Exception {
        YamlMap style = this.encode("point", "zoom.sld");
        YamlMap rule = style.seq("feature-styles").map(0).seq("rules").map(0);
        MatcherAssert.assertThat((Object)rule, TestUtils.yHasEntry("name", (Matcher<? extends Object>)Matchers.equalTo((Object)"Large")));
        MatcherAssert.assertThat((Object)rule, TestUtils.yHasEntry("scale", TestUtils.yTuple(Matchers.equalTo((Object)"min"), TestUtils.numEqualTo(1.6E8, 0.1))));
        rule = style.seq("feature-styles").map(0).seq("rules").map(1);
        MatcherAssert.assertThat((Object)rule, TestUtils.yHasEntry("name", (Matcher<? extends Object>)Matchers.equalTo((Object)"Medium")));
        MatcherAssert.assertThat((Object)rule, TestUtils.yHasEntry("scale", TestUtils.yTuple(TestUtils.numEqualTo(1.6E8, 0.1), TestUtils.numEqualTo(3.2E8, 0.1))));
        rule = style.seq("feature-styles").map(0).seq("rules").map(2);
        MatcherAssert.assertThat((Object)rule, TestUtils.yHasEntry("name", (Matcher<? extends Object>)Matchers.equalTo((Object)"Small")));
        MatcherAssert.assertThat((Object)rule, TestUtils.yHasEntry("scale", TestUtils.yTuple(TestUtils.numEqualTo(3.2E8, 0.1), Matchers.equalTo((Object)"max"))));
    }

    @Test
    public void testPointWithAttribute() throws Exception {
        YamlMap style = this.encode("point", "attribute.sld");
        YamlMap rule = style.seq("feature-styles").map(0).seq("rules").map(0);
        Assert.assertEquals((Object)"SmallPop", (Object)rule.str("name"));
        Assert.assertEquals((Object)"${pop < '50000'}", (Object)rule.str("filter"));
        rule = style.seq("feature-styles").map(0).seq("rules").map(1);
        Assert.assertEquals((Object)"MediumPop", (Object)rule.str("name"));
        Assert.assertEquals((Object)"${pop >= '50000' AND pop < '100000'}", (Object)rule.str("filter"));
        rule = style.seq("feature-styles").map(0).seq("rules").map(2);
        Assert.assertEquals((Object)"LargePop", (Object)rule.str("name"));
        Assert.assertEquals((Object)"${pop >= '100000'}", (Object)rule.str("filter"));
    }

    @Test
    public void testPointWithRotation() throws Exception {
        YamlMap style = this.encode("point", "rotated-square.sld");
        YamlMap point = style.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("point");
        Assert.assertEquals((long)12L, (long)point.integer("size").intValue());
        Assert.assertEquals((long)45L, (long)point.integer("rotation").intValue());
    }

    @Test
    public void testPointWithTransparentTriangle() throws Exception {
        YamlMap style = this.encode("point", "transparent-triangle.sld");
        YamlMap mark = style.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("point").seq("symbols").map(0).map("mark");
        Assert.assertEquals((Object)"triangle", (Object)mark.str("shape"));
        MatcherAssert.assertThat((Object)mark.get("fill-color"), TestUtils.isColor("009900"));
        Assert.assertEquals((double)0.2, (double)mark.doub("fill-opacity"), (double)0.1);
        MatcherAssert.assertThat((Object)mark.get("stroke-color"), TestUtils.isColor("000000"));
        Assert.assertEquals((long)2L, (long)mark.integer("stroke-width").intValue());
    }

    @Test
    public void testPointWithLabel() throws Exception {
        YamlMap style = this.encode("point", "default-label.sld");
        YamlMap text = style.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(1).map("text");
        Assert.assertEquals((Object)"${name}", (Object)text.str("label"));
        MatcherAssert.assertThat((Object)text.get("fill-color"), TestUtils.isColor("000000"));
    }

    @Test
    public void testPointWithStyledLabel() throws Exception {
        YamlMap style = this.encode("point", "styled-label.sld");
        YamlMap text = style.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(1).map("text");
        Assert.assertEquals((Object)"${name}", (Object)text.str("label"));
        Assert.assertEquals((Object)"Arial", (Object)text.str("font-family"));
        Assert.assertEquals((long)12L, (long)text.integer("font-size").intValue());
        Assert.assertEquals((Object)"normal", (Object)text.str("font-style"));
        Assert.assertEquals((Object)"bold", (Object)text.str("font-weight"));
        Assert.assertEquals((Object)"point", (Object)text.str("placement"));
        MatcherAssert.assertThat((Object)text, TestUtils.yHasEntry("anchor", TestUtils.yTuple(TestUtils.numEqualTo(0.5, 1.0E-4), TestUtils.numEqualTo(0.0, 1.0E-4))));
        MatcherAssert.assertThat((Object)text, TestUtils.yHasEntry("displacement", TestUtils.yTuple(TestUtils.numEqualTo(0L), TestUtils.numEqualTo(5L))));
        MatcherAssert.assertThat((Object)text.get("fill-color"), TestUtils.isColor("000000"));
        Assert.assertEquals((Object)true, (Object)text.bool(Ysld.OPTION_PREFIX + "underlineText"));
    }

    @Test
    public void testPointWithRotatedLabel() throws Exception {
        YamlMap style = this.encode("point", "rotated-label.sld");
        YamlMap text = style.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(1).map("text");
        Assert.assertEquals((long)-45L, (long)text.integer("rotation").intValue());
    }

    @Test
    public void testPointWithRuleVendorOption() throws Exception {
        YamlMap style = this.encode("point", "rule-option.sld");
        YamlMap rule1 = style.seq("feature-styles").map(0).seq("rules").map(0);
        Assert.assertEquals((Object)"mapOnly", (Object)rule1.str("x-inclusion"));
        YamlMap rule2 = style.seq("feature-styles").map(0).seq("rules").map(1);
        Assert.assertEquals((Object)"legendOnly", (Object)rule2.str("x-inclusion"));
    }

    @Test
    public void testLineSimple() throws Exception {
        YamlMap style = this.encode("line", "simple.sld");
        YamlMap line = style.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("line");
        MatcherAssert.assertThat((Object)line.get("stroke-color"), TestUtils.isColor("000000"));
        Assert.assertEquals((long)3L, (long)line.integer("stroke-width").intValue());
    }

    @Test
    public void testLineWithAttribute() throws Exception {
        YamlMap style = this.encode("line", "attribute.sld");
        YamlMap rule = style.seq("feature-styles").map(0).seq("rules").map(0);
        Assert.assertEquals((Object)"local-road", (Object)rule.str("name"));
        Assert.assertEquals((Object)"${type = 'local-road'}", (Object)rule.str("filter"));
        YamlMap line = rule.seq("symbolizers").map(0).map("line");
        MatcherAssert.assertThat((Object)line.get("stroke-color"), TestUtils.isColor("009933"));
        Assert.assertEquals((long)2L, (long)line.integer("stroke-width").intValue());
        rule = style.seq("feature-styles").map(1).seq("rules").map(0);
        Assert.assertEquals((Object)"secondary", (Object)rule.str("name"));
        Assert.assertEquals((Object)"${type = 'secondary'}", (Object)rule.str("filter"));
        line = rule.seq("symbolizers").map(0).map("line");
        MatcherAssert.assertThat((Object)line.get("stroke-color"), TestUtils.isColor("0055CC"));
        Assert.assertEquals((long)3L, (long)line.integer("stroke-width").intValue());
        rule = style.seq("feature-styles").map(2).seq("rules").map(0);
        Assert.assertEquals((Object)"highway", (Object)rule.str("name"));
        Assert.assertEquals((Object)"${type = 'highway'}", (Object)rule.str("filter"));
        line = rule.seq("symbolizers").map(0).map("line");
        MatcherAssert.assertThat((Object)line.get("stroke-color"), TestUtils.isColor("FF0000"));
        Assert.assertEquals((long)6L, (long)line.integer("stroke-width").intValue());
    }

    @Test
    public void testLineWithBorder() throws Exception {
        YamlMap style = this.encode("line", "border.sld");
        YamlMap rule = style.seq("feature-styles").map(0).seq("rules").map(0);
        YamlMap line = rule.seq("symbolizers").map(0).map("line");
        MatcherAssert.assertThat((Object)line.get("stroke-color"), TestUtils.isColor("333333"));
        Assert.assertEquals((long)5L, (long)line.integer("stroke-width").intValue());
        Assert.assertEquals((Object)"round", (Object)line.str("stroke-linecap"));
        rule = style.seq("feature-styles").map(1).seq("rules").map(0);
        line = rule.seq("symbolizers").map(0).map("line");
        MatcherAssert.assertThat((Object)line.get("stroke-color"), TestUtils.isColor("6699FF"));
        Assert.assertEquals((long)3L, (long)line.integer("stroke-width").intValue());
        Assert.assertEquals((Object)"round", (Object)line.str("stroke-linecap"));
    }

    @Test
    public void testLineWithCurvedLabel() throws Exception {
        YamlMap style = this.encode("line", "curved-label.sld");
        YamlMap text = style.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(1).map("text");
        Assert.assertEquals((Object)"${name}", (Object)text.str("label"));
        MatcherAssert.assertThat((Object)text.get("fill-color"), TestUtils.isColor("000000"));
        Assert.assertEquals((Object)true, (Object)text.bool(Ysld.OPTION_PREFIX + "followLine"));
    }

    @Test
    public void testLineWithDashdot() throws Exception {
        YamlMap style = this.encode("line", "dash-dot.sld");
        YamlMap rule = style.seq("feature-styles").map(0).seq("rules").map(0);
        YamlMap line = rule.seq("symbolizers").map(0).map("line");
        MatcherAssert.assertThat((Object)line.get("stroke-color"), TestUtils.isColor("0000FF"));
        Assert.assertEquals((long)1L, (long)line.integer("stroke-width").intValue());
        Assert.assertEquals((Object)"10.0 10.0", (Object)line.str("stroke-dasharray"));
        line = rule.seq("symbolizers").map(1).map("line");
        Assert.assertEquals((Object)"5.0 15.0", (Object)line.str("stroke-dasharray"));
        Assert.assertEquals((double)7.5, (double)line.doub("stroke-dashoffset"), (double)0.1);
        YamlMap g = line.map("stroke-graphic");
        Assert.assertEquals((long)5L, (long)g.integer("size").intValue());
        Assert.assertEquals((Object)"circle", (Object)g.seq("symbols").map(0).map("mark").str("shape"));
        MatcherAssert.assertThat((Object)g.seq("symbols").map(0).map("mark").get("stroke-color"), TestUtils.isColor("000033"));
        Assert.assertEquals((long)1L, (long)g.seq("symbols").map(0).map("mark").integer("stroke-width").intValue());
    }

    @Test
    public void testLineWithDashedline() throws Exception {
        YamlMap style = this.encode("line", "dashed-line.sld");
        YamlMap line = style.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("line");
        MatcherAssert.assertThat((Object)line.get("stroke-color"), TestUtils.isColor("0000FF"));
        Assert.assertEquals((long)3L, (long)line.integer("stroke-width").intValue());
        Assert.assertEquals((Object)"5.0 2.0", (Object)line.str("stroke-dasharray"));
    }

    @Test
    public void testLineWithDashspace() throws Exception {
        YamlMap style = this.encode("line", "dash-space.sld");
        YamlMap line = style.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("line");
        Assert.assertEquals((Object)"4.0 6.0", (Object)line.str("stroke-dasharray"));
        YamlMap g = line.map("stroke-graphic");
        Assert.assertEquals((long)4L, (long)g.integer("size").intValue());
        Assert.assertEquals((Object)"circle", (Object)g.seq("symbols").map(0).map("mark").str("shape"));
        MatcherAssert.assertThat((Object)g.seq("symbols").map(0).map("mark").get("fill-color"), TestUtils.isColor("666666"));
        MatcherAssert.assertThat((Object)g.seq("symbols").map(0).map("mark").get("stroke-color"), TestUtils.isColor("333333"));
        Assert.assertEquals((long)1L, (long)g.seq("symbols").map(0).map("mark").integer("stroke-width").intValue());
    }

    @Test
    public void testLineWithDefaultLabel() throws Exception {
        YamlMap style = this.encode("line", "default-label.sld");
        YamlMap line = style.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("line");
        MatcherAssert.assertThat((Object)line.get("stroke-color"), TestUtils.isColor("FF0000"));
        YamlMap text = style.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(1).map("text");
        Assert.assertEquals((Object)"${name}", (Object)text.str("label"));
        MatcherAssert.assertThat((Object)text.get("fill-color"), TestUtils.isColor("000000"));
    }

    @Test
    public void testLineWithRailroad() throws Exception {
        YamlMap style = this.encode("line", "railroad.sld");
        YamlMap line = style.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(1).map("line");
        YamlMap mark = line.map("stroke-graphic").seq("symbols").map(0).map("mark");
        Assert.assertEquals((Object)"shape://vertline", (Object)mark.str("shape"));
        MatcherAssert.assertThat((Object)line.get("stroke-color"), TestUtils.isColor("333333"));
        Assert.assertEquals((long)1L, (long)mark.integer("stroke-width").intValue());
    }

    @Test
    public void testLineWithZoom() throws Exception {
        YamlMap style = this.encode("line", "zoom.sld");
        YamlMap rule = style.seq("feature-styles").map(0).seq("rules").map(0);
        MatcherAssert.assertThat((Object)rule, TestUtils.yHasEntry("name", (Matcher<? extends Object>)Matchers.equalTo((Object)"Large")));
        MatcherAssert.assertThat((Object)rule, TestUtils.yHasEntry("scale", TestUtils.yTuple(Matchers.equalTo((Object)"min"), TestUtils.numEqualTo(1.8E8, 0.1))));
        YamlMap line = rule.seq("symbolizers").map(0).map("line");
        MatcherAssert.assertThat((Object)line.get("stroke-color"), TestUtils.isColor("009933"));
        Assert.assertEquals((long)6L, (long)line.integer("stroke-width").intValue());
        rule = style.seq("feature-styles").map(0).seq("rules").map(1);
        MatcherAssert.assertThat((Object)rule, TestUtils.yHasEntry("name", (Matcher<? extends Object>)Matchers.equalTo((Object)"Medium")));
        MatcherAssert.assertThat((Object)rule, TestUtils.yHasEntry("scale", TestUtils.yTuple(TestUtils.numEqualTo(1.8E8, 0.1), TestUtils.numEqualTo(3.6E8, 0.1))));
        line = rule.seq("symbolizers").map(0).map("line");
        MatcherAssert.assertThat((Object)line.get("stroke-color"), TestUtils.isColor("009933"));
        Assert.assertEquals((long)4L, (long)line.integer("stroke-width").intValue());
        rule = style.seq("feature-styles").map(0).seq("rules").map(2);
        MatcherAssert.assertThat((Object)rule, TestUtils.yHasEntry("name", (Matcher<? extends Object>)Matchers.equalTo((Object)"Small")));
        MatcherAssert.assertThat((Object)rule, TestUtils.yHasEntry("scale", TestUtils.yTuple(TestUtils.numEqualTo(3.6E8, 0.1), Matchers.equalTo((Object)"max"))));
        line = rule.seq("symbolizers").map(0).map("line");
        MatcherAssert.assertThat((Object)line.get("stroke-color"), TestUtils.isColor("009933"));
        Assert.assertEquals((long)2L, (long)line.integer("stroke-width").intValue());
    }

    @Test
    public void testLineWithOptimizedLabel() throws Exception {
        YamlMap style = this.encode("line", "optimized-label.sld");
        YamlMap text = style.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(1).map("text");
        Assert.assertEquals((Object)"${name}", (Object)text.str("label"));
        MatcherAssert.assertThat((Object)text.get("fill-color"), TestUtils.isColor("000000"));
        Assert.assertEquals((Object)true, (Object)text.bool(Ysld.OPTION_PREFIX + "followLine"));
        Assert.assertEquals((Object)true, (Object)text.bool(Ysld.OPTION_PREFIX + "underlineText"));
        Assert.assertEquals((Object)true, (Object)text.bool(Ysld.OPTION_PREFIX + "strikethroughText"));
        Assert.assertEquals((long)5L, (long)text.integer(Ysld.OPTION_PREFIX + "charSpacing").intValue());
        Assert.assertEquals((long)15L, (long)text.integer(Ysld.OPTION_PREFIX + "wordSpacing").intValue());
        Assert.assertEquals((long)90L, (long)text.integer(Ysld.OPTION_PREFIX + "maxAngleDelta").intValue());
        Assert.assertEquals((long)400L, (long)text.integer(Ysld.OPTION_PREFIX + "maxDisplacement").intValue());
        Assert.assertEquals((long)150L, (long)text.integer(Ysld.OPTION_PREFIX + "repeat").intValue());
    }

    @Test
    public void testLineWithOptimizedAndStyledLabel() throws Exception {
        YamlMap style = this.encode("line", "optimized-styled-label.sld");
        YamlMap text = style.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(1).map("text");
        Assert.assertEquals((Object)"${name}", (Object)text.str("label"));
        MatcherAssert.assertThat((Object)text.get("fill-color"), TestUtils.isColor("000000"));
        Assert.assertEquals((Object)"Arial", (Object)text.str("font-family"));
        Assert.assertEquals((long)10L, (long)text.integer("font-size").intValue());
        Assert.assertEquals((Object)"normal", (Object)text.str("font-style"));
        Assert.assertEquals((Object)"bold", (Object)text.str("font-weight"));
        Assert.assertEquals((Object)true, (Object)text.bool(Ysld.OPTION_PREFIX + "followLine"));
        Assert.assertEquals((long)90L, (long)text.integer(Ysld.OPTION_PREFIX + "maxAngleDelta").intValue());
        Assert.assertEquals((long)400L, (long)text.integer(Ysld.OPTION_PREFIX + "maxDisplacement").intValue());
        Assert.assertEquals((long)150L, (long)text.integer(Ysld.OPTION_PREFIX + "repeat").intValue());
    }

    @Test
    public void testPolygonSimple() throws Exception {
        YamlMap obj = this.encode("poly", "simple.sld");
        YamlMap poly = obj.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("polygon");
        MatcherAssert.assertThat((Object)poly.get("fill-color"), TestUtils.isColor("000080"));
    }

    @Test
    public void testPolygonWithAttribute() throws Exception {
        YamlMap obj = this.encode("poly", "attribute.sld");
        YamlMap rule = obj.seq("feature-styles").map(0).seq("rules").map(0);
        Assert.assertEquals((Object)"SmallPop", (Object)rule.str("name"));
        Assert.assertEquals((Object)"${pop < '200000'}", (Object)rule.str("filter"));
        YamlMap poly = rule.seq("symbolizers").map(0).map("polygon");
        MatcherAssert.assertThat((Object)poly.get("fill-color"), TestUtils.isColor("66FF66"));
        rule = obj.seq("feature-styles").map(0).seq("rules").map(1);
        Assert.assertEquals((Object)"MediumPop", (Object)rule.str("name"));
        Assert.assertEquals((Object)"${pop >= '200000' AND pop < '500000'}", (Object)rule.str("filter"));
        poly = rule.seq("symbolizers").map(0).map("polygon");
        MatcherAssert.assertThat((Object)poly.get("fill-color"), TestUtils.isColor("33CC33"));
        rule = obj.seq("feature-styles").map(0).seq("rules").map(2);
        Assert.assertEquals((Object)"LargePop", (Object)rule.str("name"));
        Assert.assertEquals((Object)"${pop > '500000'}", (Object)rule.str("filter"));
        poly = rule.seq("symbolizers").map(0).map("polygon");
        MatcherAssert.assertThat((Object)poly.get("fill-color"), TestUtils.isColor("009900"));
    }

    @Test
    public void testPolygonWithDefaultLabel() throws Exception {
        YamlMap obj = this.encode("poly", "default-label.sld");
        YamlMap poly = obj.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("polygon");
        YamlMap text = obj.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(1).map("text");
        MatcherAssert.assertThat((Object)poly.get("fill-color"), TestUtils.isColor("40FF40"));
        MatcherAssert.assertThat((Object)poly.get("stroke-color"), TestUtils.isColor("FFFFFF"));
        Assert.assertEquals((long)2L, (long)poly.integer("stroke-width").intValue());
        Assert.assertEquals((Object)"${name}", (Object)text.str("label"));
    }

    @Test
    public void testPolygonWithGraphicFill() throws Exception {
        YamlMap obj = this.encode("poly", "graphic-fill.sld");
        YamlMap poly = obj.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("polygon");
        YamlMap g = poly.map("fill-graphic").seq("symbols").map(0).map("external");
        Assert.assertEquals((Object)"colorblocks.png", (Object)g.str("url"));
        Assert.assertEquals((Object)"image/png", (Object)g.str("format"));
        Assert.assertEquals((long)93L, (long)poly.map("fill-graphic").integer("size").intValue());
    }

    @Test
    public void testPolygonWithHaloLabel() throws Exception {
        YamlMap obj = this.encode("poly", "halo-label.sld");
        YamlMap text = obj.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(1).map("text");
        Assert.assertEquals((Object)"${name}", (Object)text.str("label"));
        Assert.assertEquals((long)3L, (long)text.map("halo").integer("radius").intValue());
        MatcherAssert.assertThat((Object)text.map("halo").get("fill-color"), TestUtils.isColor("FFFFFF"));
    }

    @Test
    public void testPolygonWithHatchFill() throws Exception {
        YamlMap obj = this.encode("poly", "hatch-fill.sld");
        YamlMap poly = obj.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("polygon");
        YamlMap mark = poly.map("fill-graphic").seq("symbols").map(0).map("mark");
        Assert.assertEquals((Object)"shape://times", (Object)mark.str("shape"));
        Assert.assertEquals((long)1L, (long)mark.integer("stroke-width").intValue());
        Assert.assertEquals((long)16L, (long)poly.map("fill-graphic").integer("size").intValue());
    }

    @Test
    public void testPolygonWithStroke() throws Exception {
        YamlMap obj = this.encode("poly", "stroke.sld");
        YamlMap poly = obj.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("polygon");
        MatcherAssert.assertThat((Object)poly.get("fill-color"), TestUtils.isColor("000080"));
        MatcherAssert.assertThat((Object)poly.get("stroke-color"), TestUtils.isColor("FFFFFF"));
        Assert.assertEquals((long)2L, (long)poly.integer("stroke-width").intValue());
    }

    @Test
    public void testPolygonWithStyledLabel() throws Exception {
        YamlMap obj = this.encode("poly", "styled-label.sld");
        YamlMap text = obj.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(1).map("text");
        Assert.assertEquals((Object)"${name}", (Object)text.str("label"));
        Assert.assertEquals((Object)"Arial", (Object)text.str("font-family"));
        Assert.assertEquals((long)11L, (long)text.integer("font-size").intValue());
        Assert.assertEquals((Object)"normal", (Object)text.str("font-style"));
        Assert.assertEquals((Object)"bold", (Object)text.str("font-weight"));
        Assert.assertEquals((Object)"point", (Object)text.str("placement"));
        MatcherAssert.assertThat((Object)text, TestUtils.yHasEntry("anchor", TestUtils.yTuple(TestUtils.numEqualTo(0.5, 1.0E-4), TestUtils.numEqualTo(0.5, 1.0E-4))));
        MatcherAssert.assertThat((Object)text.get("fill-color"), TestUtils.isColor("000000"));
        Assert.assertEquals((long)60L, (long)text.integer(Ysld.OPTION_PREFIX + "autoWrap").intValue());
        Assert.assertEquals((long)150L, (long)text.integer(Ysld.OPTION_PREFIX + "maxDisplacement").intValue());
        Assert.assertEquals((Object)true, (Object)text.bool(Ysld.OPTION_PREFIX + "underlineText"));
    }

    @Test
    public void testPolygonWithTransparent() throws Exception {
        YamlMap obj = this.encode("poly", "transparent.sld");
        YamlMap poly = obj.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("polygon");
        MatcherAssert.assertThat((Object)poly.get("fill-color"), TestUtils.isColor("000080"));
        Assert.assertEquals((double)0.5, (double)poly.doub("fill-opacity"), (double)0.1);
        MatcherAssert.assertThat((Object)poly.get("stroke-color"), TestUtils.isColor("FFFFFF"));
        Assert.assertEquals((long)2L, (long)poly.integer("stroke-width").intValue());
    }

    @Test
    public void testPolygonWithZoom() throws Exception {
        YamlMap obj = this.encode("poly", "zoom.sld");
        YamlMap rule = obj.seq("feature-styles").map(0).seq("rules").map(0);
        MatcherAssert.assertThat((Object)rule, TestUtils.yHasEntry("name", (Matcher<? extends Object>)Matchers.equalTo((Object)"Large")));
        MatcherAssert.assertThat((Object)rule, TestUtils.yHasEntry("scale", TestUtils.yTuple(Matchers.equalTo((Object)"min"), TestUtils.numEqualTo(1.0E8, 0.1))));
        YamlMap poly = rule.seq("symbolizers").map(0).map("polygon");
        MatcherAssert.assertThat((Object)poly.get("fill-color"), TestUtils.isColor("0000CC"));
        MatcherAssert.assertThat((Object)poly.get("stroke-color"), TestUtils.isColor("000000"));
        Assert.assertEquals((long)7L, (long)poly.integer("stroke-width").intValue());
        YamlMap text = rule.seq("symbolizers").map(1).map("text");
        Assert.assertEquals((Object)"${name}", (Object)text.str("label"));
        Assert.assertEquals((Object)"Arial", (Object)text.str("font-family"));
        Assert.assertEquals((long)14L, (long)text.integer("font-size").intValue());
        Assert.assertEquals((Object)"normal", (Object)text.str("font-style"));
        Assert.assertEquals((Object)"bold", (Object)text.str("font-weight"));
        Assert.assertEquals((Object)"point", (Object)text.str("placement"));
        MatcherAssert.assertThat((Object)text, TestUtils.yHasEntry("anchor", TestUtils.yTuple(TestUtils.numEqualTo(0.5, 1.0E-4), TestUtils.numEqualTo(0.5, 1.0E-4))));
        MatcherAssert.assertThat((Object)text.get("fill-color"), TestUtils.isColor("FFFFFF"));
        rule = obj.seq("feature-styles").map(0).seq("rules").map(1);
        MatcherAssert.assertThat((Object)rule, TestUtils.yHasEntry("name", (Matcher<? extends Object>)Matchers.equalTo((Object)"Medium")));
        MatcherAssert.assertThat((Object)rule, TestUtils.yHasEntry("scale", TestUtils.yTuple(TestUtils.numEqualTo(1.0E8, 0.1), TestUtils.numEqualTo(2.0E8, 0.1))));
        poly = rule.seq("symbolizers").map(0).map("polygon");
        MatcherAssert.assertThat((Object)poly.get("fill-color"), TestUtils.isColor("0000CC"));
        MatcherAssert.assertThat((Object)poly.get("stroke-color"), TestUtils.isColor("000000"));
        Assert.assertEquals((long)4L, (long)poly.integer("stroke-width").intValue());
        rule = obj.seq("feature-styles").map(0).seq("rules").map(2);
        MatcherAssert.assertThat((Object)rule, TestUtils.yHasEntry("name", (Matcher<? extends Object>)Matchers.equalTo((Object)"Small")));
        MatcherAssert.assertThat((Object)rule, TestUtils.yHasEntry("scale", TestUtils.yTuple(TestUtils.numEqualTo(2.0E8, 0.1), Matchers.equalTo((Object)"max"))));
        poly = rule.seq("symbolizers").map(0).map("polygon");
        poly = rule.seq("symbolizers").map(0).map("polygon");
        MatcherAssert.assertThat((Object)poly.get("fill-color"), TestUtils.isColor("0000CC"));
        MatcherAssert.assertThat((Object)poly.get("stroke-color"), TestUtils.isColor("000000"));
        Assert.assertEquals((long)1L, (long)poly.integer("stroke-width").intValue());
    }

    @Test
    public void testRasterWithAlphaChannel() throws Exception {
        YamlMap obj = this.encode("raster", "alpha-channel.sld");
        YamlMap raster = obj.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("raster");
        MatcherAssert.assertThat((Object)raster.map("color-map").seq("entries"), TestUtils.yHasItem(0, TestUtils.yTuple(TestUtils.fakeString((Matcher<? extends Object>)Matchers.equalTo((Object)"#008000")), TestUtils.lexEqualTo(""), TestUtils.numEqualTo(70L), TestUtils.lexEqualTo(""))));
        MatcherAssert.assertThat((Object)raster.map("color-map").seq("entries"), TestUtils.yHasItem(1, TestUtils.yTuple(TestUtils.fakeString((Matcher<? extends Object>)Matchers.equalTo((Object)"#008000")), TestUtils.numEqualTo(0L), TestUtils.numEqualTo(256L), TestUtils.lexEqualTo(""))));
    }

    @Test
    public void testRasterWithBrightnessAndContrast() throws Exception {
        YamlMap obj = this.encode("raster", "brightness-and-contrast.sld");
        YamlMap raster = obj.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("raster");
        Assert.assertEquals((Object)"normalize", (Object)raster.map("contrast-enhancement").str("mode"));
        Assert.assertEquals((double)0.5, (double)raster.map("contrast-enhancement").doub("gamma"), (double)0.1);
        MatcherAssert.assertThat((Object)raster.map("color-map").seq("entries"), TestUtils.yHasItem(0, TestUtils.yTuple(TestUtils.fakeString((Matcher<? extends Object>)Matchers.equalTo((Object)"#008000")), TestUtils.lexEqualTo(""), TestUtils.numEqualTo(70L), TestUtils.lexEqualTo(""))));
        MatcherAssert.assertThat((Object)raster.map("color-map").seq("entries"), TestUtils.yHasItem(1, TestUtils.yTuple(TestUtils.fakeString((Matcher<? extends Object>)Matchers.equalTo((Object)"#663333")), TestUtils.lexEqualTo(""), TestUtils.numEqualTo(256L), TestUtils.lexEqualTo(""))));
    }

    @Test
    public void testRasterWithDiscreteColors() throws Exception {
        YamlMap obj = this.encode("raster", "discrete-colors.sld");
        YamlMap raster = obj.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("raster");
        Assert.assertEquals((Object)"intervals", (Object)raster.map("color-map").str("type"));
        MatcherAssert.assertThat((Object)raster.map("color-map").seq("entries"), TestUtils.yHasItem(0, TestUtils.yTuple(TestUtils.fakeString((Matcher<? extends Object>)Matchers.equalTo((Object)"#008000")), TestUtils.lexEqualTo(""), TestUtils.numEqualTo(150L), TestUtils.lexEqualTo(""))));
        MatcherAssert.assertThat((Object)raster.map("color-map").seq("entries"), TestUtils.yHasItem(1, TestUtils.yTuple(TestUtils.fakeString((Matcher<? extends Object>)Matchers.equalTo((Object)"#663333")), TestUtils.lexEqualTo(""), TestUtils.numEqualTo(256L), TestUtils.lexEqualTo(""))));
    }

    @Test
    public void testRasterWithManyColorGradient() throws Exception {
        YamlMap obj = this.encode("raster", "many-color-gradient.sld");
        YamlMap raster = obj.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("raster");
        MatcherAssert.assertThat((Object)raster.map("color-map").seq("entries"), TestUtils.yHasItem(0, TestUtils.yTuple(TestUtils.fakeString((Matcher<? extends Object>)Matchers.equalTo((Object)"#000000")), TestUtils.lexEqualTo(""), TestUtils.numEqualTo(95L), TestUtils.lexEqualTo(""))));
        MatcherAssert.assertThat((Object)raster.map("color-map").seq("entries"), TestUtils.yHasItem(1, TestUtils.yTuple(TestUtils.fakeString((Matcher<? extends Object>)Matchers.equalTo((Object)"#0000FF")), TestUtils.lexEqualTo(""), TestUtils.numEqualTo(110L), TestUtils.lexEqualTo(""))));
        MatcherAssert.assertThat((Object)raster.map("color-map").seq("entries"), TestUtils.yHasItem(2, TestUtils.yTuple(TestUtils.fakeString((Matcher<? extends Object>)Matchers.equalTo((Object)"#00FF00")), TestUtils.lexEqualTo(""), TestUtils.numEqualTo(135L), TestUtils.lexEqualTo(""))));
        MatcherAssert.assertThat((Object)raster.map("color-map").seq("entries"), TestUtils.yHasItem(3, TestUtils.yTuple(TestUtils.fakeString((Matcher<? extends Object>)Matchers.equalTo((Object)"#FF0000")), TestUtils.lexEqualTo(""), TestUtils.numEqualTo(160L), TestUtils.lexEqualTo(""))));
        MatcherAssert.assertThat((Object)raster.map("color-map").seq("entries"), TestUtils.yHasItem(4, TestUtils.yTuple(TestUtils.fakeString((Matcher<? extends Object>)Matchers.equalTo((Object)"#FF00FF")), TestUtils.lexEqualTo(""), TestUtils.numEqualTo(185L), TestUtils.lexEqualTo(""))));
        MatcherAssert.assertThat((Object)raster.map("color-map").seq("entries"), TestUtils.yHasItem(5, TestUtils.yTuple(TestUtils.fakeString((Matcher<? extends Object>)Matchers.equalTo((Object)"#FFFF00")), TestUtils.lexEqualTo(""), TestUtils.numEqualTo(210L), TestUtils.lexEqualTo(""))));
        MatcherAssert.assertThat((Object)raster.map("color-map").seq("entries"), TestUtils.yHasItem(6, TestUtils.yTuple(TestUtils.fakeString((Matcher<? extends Object>)Matchers.equalTo((Object)"#00FFFF")), TestUtils.lexEqualTo(""), TestUtils.numEqualTo(235L), TestUtils.lexEqualTo(""))));
        MatcherAssert.assertThat((Object)raster.map("color-map").seq("entries"), TestUtils.yHasItem(7, TestUtils.yTuple(TestUtils.fakeString((Matcher<? extends Object>)Matchers.equalTo((Object)"#FFFFFF")), TestUtils.lexEqualTo(""), TestUtils.numEqualTo(256L), TestUtils.lexEqualTo(""))));
    }

    @Test
    public void testRasterWithThreeColorGradient() throws Exception {
        YamlMap obj = this.encode("raster", "three-color-gradient.sld");
        YamlMap raster = obj.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("raster");
        MatcherAssert.assertThat((Object)raster.map("color-map").seq("entries"), TestUtils.yHasItem(0, TestUtils.yTuple(TestUtils.fakeString((Matcher<? extends Object>)Matchers.equalTo((Object)"#0000FF")), TestUtils.lexEqualTo(""), TestUtils.numEqualTo(150L), TestUtils.lexEqualTo(""))));
        MatcherAssert.assertThat((Object)raster.map("color-map").seq("entries"), TestUtils.yHasItem(1, TestUtils.yTuple(TestUtils.fakeString((Matcher<? extends Object>)Matchers.equalTo((Object)"#FFFF00")), TestUtils.lexEqualTo(""), TestUtils.numEqualTo(200L), TestUtils.lexEqualTo(""))));
        MatcherAssert.assertThat((Object)raster.map("color-map").seq("entries"), TestUtils.yHasItem(2, TestUtils.yTuple(TestUtils.fakeString((Matcher<? extends Object>)Matchers.equalTo((Object)"#FF0000")), TestUtils.lexEqualTo(""), TestUtils.numEqualTo(250L), TestUtils.lexEqualTo(""))));
    }

    @Test
    public void testRasterWithTransparentGradient() throws Exception {
        YamlMap obj = this.encode("raster", "transparent-gradient.sld");
        YamlMap raster = obj.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("raster");
        Assert.assertEquals((double)0.3, (double)raster.doub("opacity"), (double)0.1);
        MatcherAssert.assertThat((Object)raster.map("color-map").seq("entries"), TestUtils.yHasItem(0, TestUtils.yTuple(TestUtils.fakeString((Matcher<? extends Object>)Matchers.equalTo((Object)"#008000")), TestUtils.lexEqualTo(""), TestUtils.numEqualTo(70L), TestUtils.lexEqualTo(""))));
        MatcherAssert.assertThat((Object)raster.map("color-map").seq("entries"), TestUtils.yHasItem(1, TestUtils.yTuple(TestUtils.fakeString((Matcher<? extends Object>)Matchers.equalTo((Object)"#663333")), TestUtils.lexEqualTo(""), TestUtils.numEqualTo(256L), TestUtils.lexEqualTo(""))));
    }

    @Test
    public void testRasterWithTwoColorGradient() throws Exception {
        YamlMap obj = this.encode("raster", "two-color-gradient.sld");
        YamlMap raster = obj.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("raster");
        MatcherAssert.assertThat((Object)raster.map("color-map").seq("entries"), TestUtils.yHasItem(0, TestUtils.yTuple(TestUtils.fakeString((Matcher<? extends Object>)Matchers.equalTo((Object)"#008000")), TestUtils.lexEqualTo(""), TestUtils.numEqualTo(70L), TestUtils.lexEqualTo(""))));
        MatcherAssert.assertThat((Object)raster.map("color-map").seq("entries"), TestUtils.yHasItem(1, TestUtils.yTuple(TestUtils.fakeString((Matcher<? extends Object>)Matchers.equalTo((Object)"#663333")), TestUtils.lexEqualTo(""), TestUtils.numEqualTo(256L), TestUtils.lexEqualTo(""))));
    }

    @Test
    public void testRasterWithBandSelectionExpression() throws Exception {
        YamlMap obj = this.encode("raster", "band-selection-expression.sld");
        String name = obj.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("raster").map("channels").map("gray").str("name").trim();
        Assert.assertEquals((Object)"${env('B1','1')}", (Object)name);
    }

    YamlMap encode(String dirname, String filename) throws Exception {
        SLDParser sldParser = new SLDParser(CommonFactoryFinder.getStyleFactory());
        sldParser.setInput(YsldTests.sld(dirname, filename));
        StyledLayerDescriptor sld = sldParser.parseSLD();
        StringWriter w = new StringWriter();
        YsldEncoder ysldEncoder = new YsldEncoder((Writer)w, new UomMapper());
        ysldEncoder.encode(sld);
        return new YamlMap(YamlUtil.getSafeYaml().load((Reader)new StringReader(w.toString())));
    }
}

