/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld.validate;

import org.geotools.ysld.validate.StatefulValidator;
import org.geotools.ysld.validate.TupleValidator;
import org.geotools.ysld.validate.YsldValidateContext;
import org.geotools.ysld.validate.YsldValidateHandler;
import org.yaml.snakeyaml.events.AliasEvent;
import org.yaml.snakeyaml.events.ScalarEvent;
import org.yaml.snakeyaml.events.SequenceEndEvent;
import org.yaml.snakeyaml.events.SequenceStartEvent;

public class SequenceValidator
extends StatefulValidator
implements Cloneable {
    State state = State.NEW;
    YsldValidateHandler subValidator;

    public SequenceValidator(YsldValidateHandler subValidator) {
        this.subValidator = subValidator;
    }

    @Override
    public void sequence(SequenceStartEvent evt, YsldValidateContext context) {
        if (this.state == State.NEW) {
            this.state = State.STARTED;
        } else if (this.state == State.STARTED) {
            YsldValidateHandler sub = this.getSubValidator();
            if (sub instanceof TupleValidator) {
                ((TupleValidator)sub).reset();
            } else if (sub instanceof SequenceValidator) {
                ((SequenceValidator)sub).reset();
            }
            context.push(sub);
            sub.sequence(evt, context);
        } else {
            context.error("Unexpected Start of Sequence", evt.getStartMark());
        }
    }

    @Override
    public void endSequence(SequenceEndEvent evt, YsldValidateContext context) {
        if (this.state != State.STARTED) {
            context.error("Unexpected End of Sequence", evt.getStartMark());
        }
        this.state = State.DONE;
        context.pop();
    }

    protected YsldValidateHandler getSubValidator() {
        return this.subValidator;
    }

    @Override
    public void scalar(ScalarEvent evt, YsldValidateContext context) {
        String val = evt.getValue();
        switch (this.state) {
            case STARTED: {
                YsldValidateHandler sub = this.getSubValidator();
                if (sub instanceof TupleValidator) {
                    ((TupleValidator)sub).reset();
                } else if (sub instanceof SequenceValidator) {
                    ((SequenceValidator)sub).reset();
                }
                context.push(sub);
                sub.scalar(evt, context);
                break;
            }
            default: {
                context.error(String.format("Unexpected scalar '%s'", val), evt.getStartMark());
            }
        }
    }

    public SequenceValidator clone() {
        return new SequenceValidator(this.subValidator);
    }

    @Override
    void reset() {
        if (this.state != State.NEW && this.state != State.DONE) {
            throw new IllegalStateException("SequenceValidator.reset() called in invalid state: " + this.state.toString());
        }
        this.state = State.NEW;
    }

    @Override
    public void alias(AliasEvent evt, YsldValidateContext context) {
        switch (this.state) {
            case NEW: {
                this.state = State.DONE;
                context.pop();
                break;
            }
            case STARTED: {
                break;
            }
            default: {
                context.error(String.format("Unexpected alias '%s'", evt.getAnchor()), evt.getStartMark());
            }
        }
    }

    static enum State {
        NEW,
        STARTED,
        DONE;

    }
}

