/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld.transform.sld;

import java.io.IOException;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.geotools.ysld.transform.sld.RootHandler;
import org.geotools.ysld.transform.sld.SldTransformContext;
import org.geotools.ysld.transform.sld.SldTransformHandler;

public class SldTransformer {
    XMLStreamReader xml;
    SldTransformContext context;

    public SldTransformer(XMLStreamReader xml, Writer yaml) {
        this.xml = xml;
        this.context = new SldTransformContext(yaml);
    }

    public SldTransformContext context() {
        return this.context;
    }

    public void transform() throws IOException, XMLStreamException {
        Integer next;
        this.context.stream().document().push(new RootHandler());
        boolean root = true;
        Integer n = next = this.xml.hasNext() ? Integer.valueOf(this.xml.next()) : null;
        while (next != null) {
            this.context.reset();
            SldTransformHandler h = this.context.handlers.peek();
            switch (next) {
                case 3: 
                case 5: 
                case 6: {
                    break;
                }
                case 7: {
                    break;
                }
                case 1: {
                    String ver;
                    if (root && (ver = this.xml.getAttributeValue(null, "version")) != null) {
                        this.context.version(ver);
                    }
                    root = false;
                    h.element(this.xml, this.context);
                    break;
                }
                case 10: {
                    h.attribute(this.xml, this.context);
                    break;
                }
                case 4: {
                    h.characters(this.xml, this.context);
                    break;
                }
                case 2: {
                    h.endElement(this.xml, this.context);
                    break;
                }
            }
            if (!this.context.moveToNext) continue;
            next = this.xml.hasNext() ? Integer.valueOf(this.xml.next()) : null;
        }
        this.context.endDocument().endStream();
    }
}

