/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld.parse;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.style.AnchorPoint;
import org.geotools.api.style.Displacement;
import org.geotools.filter.function.FilterFunction_strConcat;
import org.geotools.filter.function.string.ConcatenateFunction;
import org.geotools.renderer.style.ExpressionExtractor;
import org.geotools.styling.zoom.WellKnownZoomContextFinder;
import org.geotools.styling.zoom.ZoomContext;
import org.geotools.styling.zoom.ZoomContextFinder;
import org.geotools.ysld.Colors;
import org.geotools.ysld.Tuple;
import org.geotools.ysld.YamlMap;
import org.geotools.ysld.Ysld;
import org.geotools.ysld.parse.Factory;

public class Util {
    static final Pattern ATTRIBUTE_PATTERN = Pattern.compile("\\[.+\\]");
    static final Pattern WELLKNOWNNAME_PATTERN = Pattern.compile("\\w+://.+");
    static final Pattern COLOR_PATTERN = Pattern.compile("#\\p{XDigit}{6}");
    static final Pattern HEX_PATTERN = Pattern.compile("\\s*(?:(?:0x)|#)?([A-Fa-f0-9]{3}|[A-Fa-f0-9]{6})\\s*");
    static final Pattern RGB_PATTERN = Pattern.compile("\\s*rgb\\s*\\(\\s*(\\d{1,3})\\s*,\\s*(\\d{1,3})\\s*,\\s*(\\d{1,3})\\s*\\)\\s*", 2);
    static final Pattern EMBEDED_EXPRESSION_ESCAPED = Pattern.compile("\\\\([$}\\\\])");
    static final Pattern EMBEDED_FILTER = Pattern.compile("^\\s*\\$\\{(.*?)\\}\\s*$");

    public static Expression expression(String value, Factory factory) {
        return Util.expression(value, false, factory);
    }

    private static void collectExpressions(List<Expression> list, Expression expr) {
        if (expr == null) {
            return;
        }
        if (expr instanceof ConcatenateFunction || expr instanceof FilterFunction_strConcat) {
            for (Expression param : ((Function)expr).getParameters()) {
                Util.collectExpressions(list, param);
            }
        } else {
            if (expr instanceof Literal) {
                Object value = ((Literal)expr).getValue();
                if (value == null) {
                    return;
                }
                if (value instanceof String && ((String)value).isEmpty()) {
                    return;
                }
            }
            list.add(expr);
        }
    }

    public static Expression unwrapConcatenates(Expression expr, Factory factory) {
        List<Expression> list = Util.splitConcatenates(expr);
        if (list.isEmpty()) {
            return factory.filter.literal(null);
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        return factory.filter.function("Concatenate", list.toArray(new Expression[0]));
    }

    public static List<Expression> splitConcatenates(Expression expr) {
        ArrayList<Expression> list = new ArrayList<Expression>();
        Util.collectExpressions(list, expr);
        return list;
    }

    public static Expression expression(String value, boolean safe, Factory factory) {
        if (value.isEmpty()) {
            return null;
        }
        Expression expr = ExpressionExtractor.extractCqlExpressions((String)value);
        expr = Util.unwrapConcatenates(expr, factory);
        return expr;
    }

    public static AnchorPoint anchor(Object value, Factory factory) {
        Tuple t = null;
        try {
            t = Tuple.of(2).parse(value);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Bad anchor: '%s', must be of form (<x>,<y>)", value), e);
        }
        Literal x = t.at(0) != null ? Util.expression(t.strAt(0), factory) : factory.filter.literal(0);
        Literal y = t.at(1) != null ? Util.expression(t.strAt(1), factory) : factory.filter.literal(0);
        return factory.style.createAnchorPoint((Expression)x, (Expression)y);
    }

    public static Displacement displacement(Object value, Factory factory) {
        Tuple t = null;
        try {
            t = Tuple.of(2).parse(value);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Bad displacement: '%s', must be of form (<x>,<y>)", value), e);
        }
        Literal x = t.at(0) != null ? Util.expression(t.strAt(0), factory) : factory.filter.literal(0);
        Literal y = t.at(1) != null ? Util.expression(t.strAt(1), factory) : factory.filter.literal(0);
        return factory.style.createDisplacement((Expression)x, (Expression)y);
    }

    public static Expression color(Object value, Factory factory) {
        Color color = null;
        if (value instanceof String) {
            Matcher m = HEX_PATTERN.matcher((String)value);
            if (m.matches()) {
                color = Util.parseColorAsHex(m);
            }
            if (color == null && (m = RGB_PATTERN.matcher((String)value)).matches()) {
                color = Util.parseColorAsRGB(m);
            }
            if (color == null) {
                color = Colors.get((String)value);
            }
        } else if (value instanceof Integer) {
            color = new Color((Integer)value);
        }
        if (value != null) {
            value = value.toString();
        }
        return color != null ? factory.filter.literal((Object)color) : Util.expression((String)value, factory);
    }

    static Color parseColorAsHex(Matcher m) {
        String hex = m.group(1);
        if (hex.length() == 3) {
            return new Color(17 * Integer.parseInt(hex.substring(0, 1), 16), 17 * Integer.parseInt(hex.substring(1, 2), 16), 17 * Integer.parseInt(hex.substring(2, 3), 16));
        }
        return new Color(Integer.parseInt(hex.substring(0, 2), 16), Integer.parseInt(hex.substring(2, 4), 16), Integer.parseInt(hex.substring(4, 6), 16));
    }

    static Color parseColorAsRGB(Matcher m) {
        return new Color(Integer.parseInt(m.group(1)), Integer.parseInt(m.group(2)), Integer.parseInt(m.group(3)));
    }

    public static float[] floatArray(String value) {
        ArrayList<Float> list = new ArrayList<Float>();
        for (String str : value.split(" ")) {
            list.add(Float.valueOf(Float.parseFloat(str)));
        }
        float[] array = new float[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            array[i] = ((Float)list.get(i)).floatValue();
        }
        return array;
    }

    @SafeVarargs
    @Nullable
    public static <T> T defaultForNull(T ... options) {
        for (T o : options) {
            if (o == null) continue;
            return o;
        }
        return null;
    }

    @SafeVarargs
    public static <T> T forceDefaultForNull(T ... options) {
        for (T o : options) {
            if (o == null) continue;
            return o;
        }
        throw new NullPointerException();
    }

    @Nullable
    public static ZoomContext getNamedZoomContext(String name, List<ZoomContextFinder> zCtxtFinders) {
        if (name.equalsIgnoreCase("EPSG:4326")) {
            throw new IllegalArgumentException("Should not use EPSG code to refer to WGS84 zoom levels as it causes ambiguities");
        }
        if (name.equalsIgnoreCase("EPSG:3857") || name.equalsIgnoreCase("EPSG:900913")) {
            throw new IllegalArgumentException("Should not use EPSG code to refer to WebMercator zoom levels");
        }
        for (ZoomContextFinder finder : zCtxtFinders) {
            ZoomContext found = finder.get(name);
            if (found == null) continue;
            return found;
        }
        return WellKnownZoomContextFinder.getInstance().get(name);
    }

    public static String removeExpressionBrackets(String s) {
        Matcher m1 = EMBEDED_FILTER.matcher(s);
        if (m1.matches()) {
            return EMBEDED_EXPRESSION_ESCAPED.matcher(m1.group(1)).replaceAll("$1");
        }
        return s;
    }

    public static Object makeNumberIfPossible(String str) {
        if (str == null) {
            return null;
        }
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException e1) {
            try {
                return Double.parseDouble(str);
            }
            catch (NumberFormatException e2) {
                if ("true".equalsIgnoreCase(str) || "false".equalsIgnoreCase(str)) {
                    return Boolean.parseBoolean(str);
                }
                return str;
            }
        }
    }

    public static String serializeColor(Color c) {
        return String.format("#%06X", c.getRGB() & 0xFFFFFF);
    }

    public static String stripQuotes(String str) {
        if (str == null) {
            return str;
        }
        if (str.charAt(0) == '\'') {
            str = str.substring(1);
        }
        if (str.charAt(str.length() - 1) == '\'') {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    public static Map<String, String> vendorOptions(YamlMap sourceMap) {
        HashMap<String, String> optionMap = new HashMap<String, String>();
        for (String key : sourceMap) {
            if (!key.startsWith(Ysld.OPTION_PREFIX)) continue;
            String option = key.substring(Ysld.OPTION_PREFIX.length());
            optionMap.put(option, sourceMap.str(key));
        }
        return optionMap;
    }
}

