/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld.parse;

import org.geotools.api.style.Rule;
import org.geotools.api.style.Symbolizer;
import org.geotools.ysld.UomMapper;
import org.geotools.ysld.YamlMap;
import org.geotools.ysld.YamlObject;
import org.geotools.ysld.parse.Factory;
import org.geotools.ysld.parse.Util;
import org.geotools.ysld.parse.YamlParseContext;
import org.geotools.ysld.parse.YsldParseHandler;

public class SymbolizerParser<T extends Symbolizer>
extends YsldParseHandler {
    protected T sym;

    protected SymbolizerParser(Rule rule, T sym, Factory factory) {
        super(factory);
        this.sym = sym;
        rule.symbolizers().add(this.sym);
    }

    @Override
    public void handle(YamlObject<?> obj, YamlParseContext context) {
        YamlMap map = obj.map();
        this.sym.setName(map.str("name"));
        if (map.has("geometry")) {
            this.sym.setGeometry(Util.expression(map.str("geometry"), this.factory));
        }
        UomMapper uomMapper = (UomMapper)context.getDocHint("uomMapper");
        if (map.has("uom")) {
            this.sym.setUnitOfMeasure(uomMapper.getUnit(map.str("uom")));
        }
        this.sym.getOptions().putAll(Util.vendorOptions(map));
    }
}

