/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld.parse;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.api.style.NamedLayer;
import org.geotools.api.style.RemoteOWS;
import org.geotools.api.style.Rule;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyledLayerDescriptor;
import org.geotools.api.style.UserLayer;
import org.geotools.styling.zoom.ListZoomContext;
import org.geotools.styling.zoom.RatioZoomContext;
import org.geotools.styling.zoom.ZoomContext;
import org.geotools.styling.zoom.ZoomContextFinder;
import org.geotools.ysld.YamlMap;
import org.geotools.ysld.YamlObject;
import org.geotools.ysld.parse.Factory;
import org.geotools.ysld.parse.FeatureStyleParser;
import org.geotools.ysld.parse.RuleParser;
import org.geotools.ysld.parse.SymbolizersParser;
import org.geotools.ysld.parse.Util;
import org.geotools.ysld.parse.YamlParseContext;
import org.geotools.ysld.parse.YamlParseHandler;
import org.geotools.ysld.parse.YsldParseHandler;

public class RootParser
extends YsldParseHandler {
    StyledLayerDescriptor sld;
    Style style;
    final List<ZoomContextFinder> zCtxtFinders;

    public RootParser() {
        this(Collections.emptyList());
    }

    public RootParser(List<ZoomContextFinder> zCtxtFinders) {
        super(new Factory());
        this.zCtxtFinders = new ArrayList<ZoomContextFinder>(zCtxtFinders.size() + 1);
        this.zCtxtFinders.addAll(zCtxtFinders);
    }

    @Override
    public void handle(YamlObject<?> obj, YamlParseContext context) {
        this.sld = this.factory.style.createStyledLayerDescriptor();
        YamlMap root = obj.map();
        if (root.has("grid")) {
            context.setDocHint("ZoomContext", this.getZoomContext(root.map("grid")));
        }
        if (root.has("sld-name")) {
            this.sld.setName(root.str("sld-name"));
        }
        if (root.has("sld-title")) {
            this.sld.setTitle(root.str("sld-title"));
        }
        if (root.has("sld-abstract")) {
            this.sld.setAbstract(root.str("sld-abstract"));
        }
        this.style = this.factory.style.createStyle();
        if (root.has("user-name") || root.has("user-remote") || root.has("user-service")) {
            UserLayer layer = this.factory.style.createUserLayer();
            this.sld.layers().add(layer);
            layer.userStyles().add(this.style);
            if (root.has("user-name")) {
                layer.setName(root.str("user-name"));
            }
            if (root.has("user-remote")) {
                RemoteOWS remote = this.factory.style.createRemoteOWS(root.strOr("user-service", "WMS"), root.str("user-remote"));
                layer.setRemoteOWS(remote);
            }
        } else {
            NamedLayer layer = this.factory.style.createNamedLayer();
            this.sld.layers().add(layer);
            layer.styles().add(this.style);
            if (root.has("layer-name")) {
                layer.setName(root.str("layer-name"));
            }
        }
        this.style.setName(root.str("name"));
        if (root.has("title")) {
            this.style.getDescription().setTitle(root.str("title"));
        }
        if (root.has("abstract")) {
            this.style.getDescription().setAbstract(root.str("abstract"));
        }
        if (root.has("feature-styles")) {
            context.push("feature-styles", (YamlParseHandler)new FeatureStyleParser(this.style, this.factory));
        } else if (root.has("rules")) {
            context.push("rules", (YamlParseHandler)new RuleParser(this.newFeatureTypeStyle(), this.factory));
        } else if (root.has("symbolizers")) {
            context.push("symbolizers", (YamlParseHandler)new SymbolizersParser(this.newRule(), this.factory));
        } else if (root.has("point") || root.has("line") || root.has("polygon") || root.has("text") || root.has("raster")) {
            context.push(new SymbolizersParser(this.newRule(), this.factory));
        }
    }

    protected ZoomContext getZoomContext(YamlMap map) {
        ZoomContext result = null;
        if (map.has("name")) {
            result = Util.getNamedZoomContext(map.str("name"), this.zCtxtFinders);
        }
        if (result == null && map.has("scales")) {
            List raw = (List)map.seq("scales").raw();
            ArrayList<Double> scaleDenoms = new ArrayList<Double>(raw.size());
            for (Number s : raw) {
                scaleDenoms.add(s.doubleValue());
            }
            int initialLevel = map.intOr("initial-level", 0);
            result = new ListZoomContext(scaleDenoms, initialLevel);
        }
        if (result == null && map.has("initial-scale")) {
            double initialScale = map.doub("initial-scale");
            double ratio = map.doubOr("ratio", 2.0);
            int initialLevel = map.intOr("initial-level", 0);
            result = new RatioZoomContext(initialLevel, initialScale, ratio);
        }
        if (result == null) {
            throw new IllegalArgumentException();
        }
        return result;
    }

    public FeatureTypeStyle newFeatureTypeStyle() {
        FeatureTypeStyle fts = this.factory.style.createFeatureTypeStyle();
        this.style.featureTypeStyles().add(fts);
        return fts;
    }

    public Rule newRule() {
        Rule rule = this.factory.style.createRule();
        this.newFeatureTypeStyle().rules().add(rule);
        return rule;
    }

    public StyledLayerDescriptor sld() {
        return this.sld;
    }
}

