/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld.parse;

import java.util.Map;
import org.geotools.api.style.ChannelSelection;
import org.geotools.api.style.ColorMap;
import org.geotools.api.style.ContrastEnhancement;
import org.geotools.api.style.ContrastMethod;
import org.geotools.api.style.RasterSymbolizer;
import org.geotools.api.style.Rule;
import org.geotools.api.style.SelectedChannelType;
import org.geotools.ysld.Band;
import org.geotools.ysld.YamlMap;
import org.geotools.ysld.YamlObject;
import org.geotools.ysld.parse.ColorMapParser;
import org.geotools.ysld.parse.Factory;
import org.geotools.ysld.parse.SymbolizerParser;
import org.geotools.ysld.parse.Util;
import org.geotools.ysld.parse.YamlParseContext;
import org.geotools.ysld.parse.YamlParseHandler;
import org.geotools.ysld.parse.YsldParseHandler;

public class RasterParser
extends SymbolizerParser<RasterSymbolizer> {
    public RasterParser(Rule rule, Factory factory) {
        super(rule, factory.style.createRasterSymbolizer(), factory);
    }

    @Override
    public void handle(YamlObject<?> obj, YamlParseContext context) {
        super.handle(obj, context);
        YamlMap map = obj.map();
        if (map.has("opacity")) {
            ((RasterSymbolizer)this.sym).setOpacity(Util.expression(map.str("opacity"), this.factory));
        }
        context.push("color-map", (YamlParseHandler)new ColorMapParser(this.factory){

            @Override
            protected void colorMap(ColorMap colorMap) {
                ((RasterSymbolizer)RasterParser.this.sym).setColorMap(colorMap);
            }
        });
        context.push("contrast-enhancement", (YamlParseHandler)new ContrastEnhancementHandler());
        context.push("channels", (YamlParseHandler)new ChannelsHandler());
    }

    class SelectedChannelHandler
    extends YsldParseHandler {
        SelectedChannelType sel;

        public SelectedChannelHandler(SelectedChannelType sel) {
            super(RasterParser.this.factory);
            this.sel = sel;
        }

        @Override
        public void handle(YamlObject<?> obj, YamlParseContext context) {
            String name = obj.map().str("name");
            this.sel.setChannelName(Util.expression(name, this.factory));
            context.push("contrast-enhancement", (YamlParseHandler)new ContrastEnhancementHandler(){

                @Override
                protected void set() {
                    SelectedChannelHandler.this.sel.setContrastEnhancement(this.contrast);
                }
            });
        }
    }

    class ChannelsHandler
    extends YsldParseHandler {
        ChannelSelection selection;

        protected ChannelsHandler() {
            super(RasterParser.this.factory);
            this.selection = ((RasterSymbolizer)RasterParser.this.sym).getChannelSelection();
        }

        void parse(Band band, SelectedChannelType sel, YamlMap map, YamlParseContext context) {
            if (map.get(band.key) instanceof Map) {
                context.push(band.key, (YamlParseHandler)new SelectedChannelHandler(sel));
            } else {
                sel.setChannelName(Util.expression(map.str(band.key), this.factory));
            }
        }

        @Override
        public void handle(YamlObject<?> obj, YamlParseContext context) {
            YamlMap map = obj.map();
            if (map.has(Band.GRAY.key)) {
                if (map.has(Band.RED.key) || map.has(Band.GREEN.key) || map.has(Band.BLUE.key)) {
                    throw new IllegalArgumentException("grey and RGB can not be combined");
                }
                SelectedChannelType gray = this.factory.style.selectedChannelType((String)null, null);
                this.selection.setGrayChannel(gray);
                this.parse(Band.GRAY, gray, map, context);
            } else {
                if (!(map.has(Band.RED.key) && map.has(Band.GREEN.key) && map.has(Band.BLUE.key))) {
                    throw new IllegalArgumentException("all of red green and blue must be preset");
                }
                SelectedChannelType red = this.factory.style.selectedChannelType((String)null, null);
                SelectedChannelType green = this.factory.style.selectedChannelType((String)null, null);
                SelectedChannelType blue = this.factory.style.selectedChannelType((String)null, null);
                this.selection.setRGBChannels(red, green, blue);
                this.parse(Band.RED, red, map, context);
                this.parse(Band.GREEN, green, map, context);
                this.parse(Band.BLUE, blue, map, context);
            }
        }
    }

    class ContrastEnhancementHandler
    extends YsldParseHandler {
        ContrastEnhancement contrast;

        protected ContrastEnhancementHandler() {
            super(RasterParser.this.factory);
            this.contrast = this.factory.style.createContrastEnhancement();
            this.set();
        }

        protected void set() {
            ((RasterSymbolizer)RasterParser.this.sym).setContrastEnhancement(this.contrast);
        }

        @Override
        public void handle(YamlObject<?> obj, YamlParseContext context) {
            YamlMap map = obj.map();
            if (map.has("mode")) {
                String mode = map.str("mode");
                ContrastMethod method = ContrastMethod.valueOf((String)mode);
                if (method != null) {
                    this.contrast.setMethod(method);
                } else {
                    LOG.warning("Unknown contrast method: " + mode);
                }
            }
            if (map.has("gamma")) {
                this.contrast.setGammaValue(Util.expression(map.str("gamma"), this.factory));
            }
        }
    }
}

