/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld.parse;

import org.geotools.api.style.Fill;
import org.geotools.api.style.PolygonSymbolizer;
import org.geotools.api.style.Rule;
import org.geotools.api.style.Stroke;
import org.geotools.ysld.YamlMap;
import org.geotools.ysld.YamlObject;
import org.geotools.ysld.parse.Factory;
import org.geotools.ysld.parse.FillParser;
import org.geotools.ysld.parse.StrokeParser;
import org.geotools.ysld.parse.SymbolizerParser;
import org.geotools.ysld.parse.Util;
import org.geotools.ysld.parse.YamlParseContext;

public class PolygonParser
extends SymbolizerParser<PolygonSymbolizer> {
    public PolygonParser(Rule rule, Factory factory) {
        super(rule, factory.style.createPolygonSymbolizer(), factory);
    }

    @Override
    public void handle(YamlObject<?> obj, YamlParseContext context) {
        super.handle(obj, context);
        YamlMap map = obj.map();
        context.push(new StrokeParser(this.factory){

            @Override
            protected void stroke(Stroke stroke) {
                ((PolygonSymbolizer)PolygonParser.this.sym).setStroke(stroke);
            }
        });
        context.push(new FillParser(this.factory){

            @Override
            protected void fill(Fill fill) {
                ((PolygonSymbolizer)PolygonParser.this.sym).setFill(fill);
            }
        });
        if (map.has("offset")) {
            ((PolygonSymbolizer)this.sym).setPerpendicularOffset(Util.expression(map.str("offset"), this.factory));
        }
        if (map.has("displacement")) {
            ((PolygonSymbolizer)this.sym).setDisplacement(Util.displacement(map.str("displacement"), this.factory));
        }
    }
}

