/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld.encode;

import org.geotools.api.metadata.citation.OnLineResource;
import org.geotools.api.style.ExternalGraphic;
import org.geotools.api.style.Graphic;
import org.geotools.api.style.GraphicalSymbol;
import org.geotools.api.style.Mark;
import org.geotools.ysld.encode.FillEncoder;
import org.geotools.ysld.encode.StrokeEncoder;
import org.geotools.ysld.encode.YsldEncodeHandler;

public class SymbolsEncoder
extends YsldEncodeHandler<GraphicalSymbol> {
    public SymbolsEncoder(Graphic g) {
        super(g.graphicalSymbols().iterator());
    }

    @Override
    protected void encode(GraphicalSymbol symbol) {
        if (symbol instanceof Mark) {
            this.push("mark");
            this.encode((Mark)symbol);
        } else if (symbol instanceof ExternalGraphic) {
            this.push("external");
            this.encode((ExternalGraphic)symbol);
        }
    }

    SymbolsEncoder encode(Mark mark) {
        this.putName("shape", mark.getWellKnownName());
        this.inline(new StrokeEncoder(mark.getStroke()));
        this.inline(new FillEncoder(mark.getFill()));
        return this;
    }

    SymbolsEncoder encode(ExternalGraphic eg) {
        OnLineResource r = eg.getOnlineResource();
        if (r != null) {
            this.put("url", r.getLinkage().toString());
        }
        this.put("format", eg.getFormat());
        return this;
    }
}

