/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld.encode;

import java.util.Optional;
import org.geotools.api.filter.Filter;
import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.api.style.Graphic;
import org.geotools.api.style.GraphicLegend;
import org.geotools.api.style.PointSymbolizer;
import org.geotools.api.style.Rule;
import org.geotools.api.style.StyleFactory;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.ysld.Tuple;
import org.geotools.ysld.encode.GraphicEncoder;
import org.geotools.ysld.encode.SymbolizersEncoder;
import org.geotools.ysld.encode.YsldEncodeHandler;

public class RuleEncoder
extends YsldEncodeHandler<Rule> {
    private static StyleFactory sf = CommonFactoryFinder.getStyleFactory();

    public RuleEncoder(FeatureTypeStyle featureStyle) {
        super(featureStyle.rules().iterator());
    }

    @Override
    protected void encode(Rule rule) {
        Tuple t2;
        this.put("name", rule.getName());
        this.put("title", (Object)Optional.ofNullable(rule.getDescription()).map(d -> d.getTitle()).map(t -> t.toString()).orElse(null));
        this.put("abstract", (Object)Optional.ofNullable(rule.getDescription()).map(d -> d.getAbstract()).map(t -> t.toString()).orElse(null));
        if (rule.getLegend() != null) {
            GraphicLegend graphic = null;
            if (rule.getLegend() instanceof Graphic) {
                graphic = rule.getLegend();
            } else {
                PointSymbolizer point = sf.createPointSymbolizer();
                point.setGraphic((Graphic)rule.getLegend());
                graphic = point.getGraphic();
            }
            this.push("legend").inline(new GraphicEncoder((Graphic)graphic)).pop();
        }
        if (rule.getFilter() != null && rule.getFilter() != Filter.INCLUDE) {
            this.put("filter", String.format("${%s}", this.escapeForEmbededCQL(ECQL.toCQL((Filter)rule.getFilter()))));
        }
        if (rule.isElseFilter()) {
            this.put("else", true);
        }
        if (!(t2 = Tuple.of(this.toStringOrNull(rule.getMinScaleDenominator(), "min"), this.toStringOrNull(rule.getMaxScaleDenominator(), "max"))).isNull()) {
            this.put("scale", t2);
        }
        this.put("symbolizers", new SymbolizersEncoder(rule));
        this.vendorOptions(rule.getOptions());
    }

    String toStringOrNull(double d, String nullKeyword) {
        return d > 0.0 && !Double.isNaN(d) && !Double.isInfinite(d) ? String.valueOf(d) : nullKeyword;
    }
}

