/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld.encode;

import java.util.Arrays;
import java.util.Iterator;
import org.geotools.api.style.ChannelSelection;
import org.geotools.api.style.ColorMap;
import org.geotools.api.style.ColorMapEntry;
import org.geotools.api.style.ContrastEnhancement;
import org.geotools.api.style.ContrastMethod;
import org.geotools.api.style.RasterSymbolizer;
import org.geotools.api.style.SelectedChannelType;
import org.geotools.ysld.Band;
import org.geotools.ysld.Tuple;
import org.geotools.ysld.encode.SymbolizerEncoder;
import org.geotools.ysld.encode.YsldEncodeHandler;

public class RasterSymbolizerEncoder
extends SymbolizerEncoder<RasterSymbolizer> {
    public RasterSymbolizerEncoder(RasterSymbolizer sym) {
        super(sym);
    }

    private boolean emptyColourMap(ColorMap map) {
        if (map == null) {
            return true;
        }
        ColorMapEntry[] entries = map.getColorMapEntries();
        if (entries == null) {
            return true;
        }
        return map.getColorMapEntries().length == 0;
    }

    private boolean emptyContrastEnhancement(ContrastEnhancement ch) {
        if (ch == null) {
            return true;
        }
        if (ch.getMethod() != null && ch.getMethod() != ContrastMethod.NONE) {
            return false;
        }
        return ch.getGammaValue() == null;
    }

    private boolean emptyChannelSelection(ChannelSelection ch) {
        if (ch == null) {
            return true;
        }
        for (Band b : Band.values()) {
            if (b.getFrom(ch) == null) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void encode(RasterSymbolizer sym) {
        this.put("opacity", sym.getOpacity());
        if (!this.emptyColourMap(sym.getColorMap())) {
            this.inline(new ColorMapEncoder(sym.getColorMap()));
        }
        if (!this.emptyContrastEnhancement(sym.getContrastEnhancement())) {
            this.inline(new ContrastEnhancementEncoder(sym.getContrastEnhancement()));
        }
        if (!this.emptyChannelSelection(sym.getChannelSelection())) {
            this.inline(new ChannelSelectionEncoder(sym.getChannelSelection()));
        }
        super.encode(sym);
    }

    class SelectedChannelTypeEncoder
    extends YsldEncodeHandler<SelectedChannelType> {
        private Band band;

        public SelectedChannelTypeEncoder(Band band, SelectedChannelType it) {
            super(it);
            this.band = band;
        }

        @Override
        protected void encode(SelectedChannelType channel) {
            this.push(this.band.key);
            this.put("name", channel.getChannelName());
            if (!RasterSymbolizerEncoder.this.emptyContrastEnhancement(channel.getContrastEnhancement())) {
                this.inline(new ContrastEnhancementEncoder(channel.getContrastEnhancement()));
            }
        }
    }

    class ChannelSelectionEncoder
    extends YsldEncodeHandler<ChannelSelection> {
        public ChannelSelectionEncoder(ChannelSelection obj) {
            super(obj);
        }

        @Override
        protected void encode(ChannelSelection next) {
            this.push("channels");
            for (Band band : Band.values()) {
                SelectedChannelType channel = band.getFrom(next);
                if (channel == null) continue;
                this.inline(new SelectedChannelTypeEncoder(band, channel));
            }
        }
    }

    class ContrastEnhancementEncoder
    extends YsldEncodeHandler<ContrastEnhancement> {
        public ContrastEnhancementEncoder(ContrastEnhancement contrast) {
            super(contrast);
        }

        @Override
        protected void encode(ContrastEnhancement contrast) {
            this.push("contrast-enhancement");
            if (contrast.getMethod() != null) {
                this.put("mode", contrast.getMethod().name().toLowerCase());
            }
            this.put("gamma", contrast.getGammaValue());
        }
    }

    class ColorMapEntryIterator
    implements Iterator<Tuple> {
        Iterator<ColorMapEntry> entries;

        public ColorMapEntryIterator(ColorMap colorMap) {
            this.entries = Arrays.asList(colorMap.getColorMapEntries()).iterator();
        }

        @Override
        public boolean hasNext() {
            return this.entries.hasNext();
        }

        @Override
        public Tuple next() {
            ColorMapEntry entry = this.entries.next();
            return Tuple.of(RasterSymbolizerEncoder.this.toColorOrNull(entry.getColor()), RasterSymbolizerEncoder.this.toObjOrNull(entry.getOpacity()), RasterSymbolizerEncoder.this.toObjOrNull(entry.getQuantity()), entry.getLabel());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ColorMapEncoder
    extends YsldEncodeHandler<ColorMap> {
        ColorMapEncoder(ColorMap colorMap) {
            super(colorMap);
        }

        @Override
        protected void encode(ColorMap colorMap) {
            this.push("color-map");
            switch (colorMap.getType()) {
                case 2: {
                    this.put("type", "intervals");
                    break;
                }
                case 1: {
                    this.put("type", "ramp");
                    break;
                }
                case 3: {
                    this.put("type", "values");
                }
            }
            this.put("entries", new ColorMapEntryIterator(colorMap));
        }
    }
}

