/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld;

import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.geotools.util.Converters;
import org.geotools.ysld.YamlMap;
import org.geotools.ysld.YamlSeq;
import org.geotools.ysld.YamlUtil;
import org.yaml.snakeyaml.DumperOptions;

public class YamlObject<T> {
    protected T raw;

    public static <W> YamlObject<W> create(W raw) {
        if (raw == null) {
            return null;
        }
        if (raw instanceof YamlObject) {
            return (YamlObject)raw;
        }
        if (raw instanceof Map) {
            return new YamlMap(raw);
        }
        if (raw instanceof List) {
            return new YamlSeq(raw);
        }
        throw new IllegalArgumentException("Unable to create yaml object from: " + raw);
    }

    protected YamlObject(T raw) {
        this.raw = raw;
    }

    public YamlMap map() {
        if (this instanceof YamlMap) {
            return (YamlMap)this;
        }
        throw new IllegalArgumentException("Object " + this + " is not a mapping");
    }

    public YamlSeq seq() {
        if (this instanceof YamlSeq) {
            return (YamlSeq)this;
        }
        throw new IllegalArgumentException("Object " + this + " is not a sequence");
    }

    static Object yamlize(Object o) {
        if (o instanceof Map) {
            o = new YamlMap(o);
        }
        if (o instanceof List) {
            o = new YamlSeq(o);
        }
        if (o.getClass().isArray()) {
            o = new YamlSeq(o);
        }
        return o;
    }

    public Object lookup(String path) {
        Object here = this;
        for (String key : path.split("/")) {
            int index;
            here = YamlObject.yamlize(here);
            try {
                index = Integer.parseInt(key);
            }
            catch (NumberFormatException nan) {
                index = -1;
            }
            if (here instanceof YamlMap) {
                YamlMap map = (YamlMap)here;
                if (index != -1) {
                    String tempKey = map.key(index);
                    here = map.get(tempKey);
                    continue;
                }
                if (map.has(key)) {
                    here = map.get(key);
                    continue;
                }
                throw new NoSuchElementException("Key: " + key + ", Keys: " + ((Map)map.raw).keySet());
            }
            if (here instanceof YamlSeq) {
                YamlSeq list = (YamlSeq)here;
                if (index != -1) {
                    here = list.get(index);
                    continue;
                }
                throw new IndexOutOfBoundsException("Index: " + key + ", Size: " + ((List)list.raw).size());
            }
            throw new NoSuchElementException("Key: " + key + ", For:" + here.getClass().getSimpleName());
        }
        return here;
    }

    public T raw() {
        return this.raw;
    }

    public Object lookupY(String path) {
        return YamlObject.yamlize(this.lookup(path));
    }

    protected <C> C convert(Object obj, Class<C> clazz) {
        Object converted;
        if (!clazz.isInstance(obj) && (converted = Converters.convert((Object)obj, clazz)) != null) {
            obj = converted;
        }
        try {
            return clazz.cast(obj);
        }
        catch (ClassCastException e) {
            throw new IllegalStateException(String.format("Unable to retrieve %s as %s", obj, clazz.getSimpleName()), e);
        }
    }

    public String toString() {
        StringWriter w = new StringWriter();
        DumperOptions dumperOpts = new DumperOptions();
        dumperOpts.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        dumperOpts.setDefaultScalarStyle(DumperOptions.ScalarStyle.PLAIN);
        YamlUtil.getSafeYaml(dumperOpts).dump(this.raw, (Writer)w);
        return w.toString();
    }
}

