/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld;

import java.util.Iterator;
import java.util.Map;
import org.geotools.util.KVP;
import org.geotools.ysld.YamlObject;
import org.geotools.ysld.YamlSeq;

public class YamlMap
extends YamlObject<Map<String, Object>>
implements Iterable<String> {
    public static YamlMap from(Object ... pairs) {
        KVP kvp = new KVP(pairs);
        return new YamlMap(kvp);
    }

    static Map<String, Object> cast(Object obj) {
        if (!(obj instanceof Map)) {
            throw new IllegalArgumentException(obj + " is not a map");
        }
        return (Map)obj;
    }

    public YamlMap(Object obj) {
        super(YamlMap.cast(obj));
    }

    public String str(String key) {
        return this.strOr(key, null);
    }

    public String strOr(String key, String def) {
        return this.get(key, String.class, def);
    }

    public Integer integer(String key) {
        return this.intOr(key, null);
    }

    public Integer intOr(String key, Integer def) {
        return this.get(key, Integer.class, def);
    }

    public Double doub(String key) {
        return this.doubOr(key, null);
    }

    public Double doubOr(String key, Double def) {
        return this.get(key, Double.class, def);
    }

    public Boolean bool(String key) {
        return this.boolOr(key, null);
    }

    public Boolean boolOr(String key, Boolean def) {
        return this.get(key, Boolean.class, def);
    }

    public boolean has(String key) {
        return ((Map)this.raw).containsKey(key);
    }

    public Object get(String key) {
        return ((Map)this.raw).get(key);
    }

    public YamlObject<?> obj(String key) {
        return YamlObject.create(((Map)this.raw).get(key));
    }

    public YamlMap map(String key) {
        Object obj = ((Map)this.raw).get(key);
        if (obj == null) {
            return null;
        }
        if (obj instanceof YamlMap) {
            return (YamlMap)obj;
        }
        return new YamlMap(obj);
    }

    public YamlSeq seq(String key) {
        Object obj = ((Map)this.raw).get(key);
        if (obj == null) {
            return null;
        }
        if (obj instanceof YamlSeq) {
            return (YamlSeq)obj;
        }
        return new YamlSeq(obj);
    }

    public String key(int i) {
        int index = 0;
        for (String key : this) {
            if (index == i) {
                return key;
            }
            ++index;
        }
        throw new IndexOutOfBoundsException("Index: " + i + ", Size: " + ((Map)this.raw).size());
    }

    @Override
    public Iterator<String> iterator() {
        return ((Map)this.raw).keySet().iterator();
    }

    <T> T get(String key, Class<T> clazz, T def) {
        if (!((Map)this.raw).containsKey(key)) {
            return def;
        }
        Object obj = ((Map)this.raw).get(key);
        if (obj == null) {
            return def;
        }
        return this.convert(obj, clazz);
    }
}

