/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld.parse;

import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.style.ColorMapEntry;
import org.geotools.api.style.ContrastEnhancement;
import org.geotools.api.style.ContrastMethod;
import org.geotools.api.style.ExternalGraphic;
import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.api.style.Fill;
import org.geotools.api.style.Font;
import org.geotools.api.style.Graphic;
import org.geotools.api.style.GraphicLegend;
import org.geotools.api.style.LineSymbolizer;
import org.geotools.api.style.Mark;
import org.geotools.api.style.PointPlacement;
import org.geotools.api.style.PointSymbolizer;
import org.geotools.api.style.PolygonSymbolizer;
import org.geotools.api.style.RasterSymbolizer;
import org.geotools.api.style.Rule;
import org.geotools.api.style.Stroke;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyledLayerDescriptor;
import org.geotools.api.style.TextSymbolizer;
import org.geotools.filter.Filters;
import org.geotools.filter.function.EnvFunction;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.styling.SLD;
import org.geotools.ysld.TestUtils;
import org.geotools.ysld.Ysld;
import org.geotools.ysld.YsldTests;
import org.geotools.ysld.parse.YsldParser;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class YsldParseCookbookTest {
    @Test
    public void testPointSimple() throws Exception {
        Style style = this.parse("point", "simple.sld");
        Assert.assertEquals((Object)"SLD Cook Book: Simple Point With Stroke", (Object)style.getDescription().getTitle().toString());
        PointSymbolizer point = SLD.pointSymbolizer((Style)style);
        Assert.assertEquals((Object)"circle", (Object)SLD.wellKnownName((Mark)SLD.mark((PointSymbolizer)point)));
        Assert.assertEquals((long)1L, (long)point.getGraphic().graphicalSymbols().size());
        Assert.assertEquals((Object)Color.red, (Object)SLD.color((Fill)SLD.fill((PointSymbolizer)point)));
        Assert.assertEquals((long)6L, (long)SLD.pointSize((PointSymbolizer)point));
    }

    @Test
    public void testPointWithStroke() throws Exception {
        Style style = this.parse("point", "stroke.sld");
        PointSymbolizer point = SLD.pointSymbolizer((Style)style);
        Assert.assertEquals((long)6L, (long)SLD.pointSize((PointSymbolizer)point));
        Mark mark = SLD.pointMark((Style)style);
        Assert.assertEquals((Object)"circle", (Object)SLD.wellKnownName((Mark)mark));
        Assert.assertEquals((Object)Color.red, (Object)SLD.color((Fill)mark.getFill()));
        Assert.assertEquals((Object)Color.black, (Object)SLD.color((Stroke)mark.getStroke()));
        Assert.assertEquals((long)2L, (long)SLD.width((Stroke)mark.getStroke()));
    }

    @Test
    public void testPointWithGraphic() throws Exception {
        Style style = this.parse("point", "graphic.sld");
        Graphic graphic = SLD.graphic((PointSymbolizer)SLD.pointSymbolizer((Style)style));
        Assert.assertEquals((long)32L, (long)Filters.asInt((Expression)graphic.getSize()));
        ExternalGraphic external = (ExternalGraphic)graphic.graphicalSymbols().get(0);
        Assert.assertEquals((Object)"smileyface.png", (Object)external.getLocation().getPath());
        Assert.assertEquals((Object)"image/png", (Object)external.getFormat());
    }

    @Test
    public void testPointWithLegend() throws Exception {
        Style style = this.parse("point", "legend.sld");
        GraphicLegend legend = SLD.rules((Style)style)[0].getLegend();
        Assert.assertEquals((long)32L, (long)Filters.asInt((Expression)legend.getSize()));
        ExternalGraphic external = (ExternalGraphic)legend.graphicalSymbols().get(0);
        Assert.assertEquals((Object)"smileyface.png", (Object)external.getLocation().getPath());
        Assert.assertEquals((Object)"image/png", (Object)external.getFormat());
        PointSymbolizer point = SLD.pointSymbolizer((Style)style);
        Assert.assertEquals((Object)"circle", (Object)SLD.wellKnownName((Mark)SLD.mark((PointSymbolizer)point)));
        Assert.assertEquals((long)1L, (long)point.getGraphic().graphicalSymbols().size());
        Assert.assertEquals((Object)Color.red, (Object)SLD.color((Fill)SLD.fill((PointSymbolizer)point)));
        Assert.assertEquals((long)6L, (long)SLD.pointSize((PointSymbolizer)point));
    }

    @Test
    public void testPointWithScale() throws Exception {
        Style style = this.parse("point", "zoom.sld");
        Rule rule = (Rule)((FeatureTypeStyle)style.featureTypeStyles().get(0)).rules().get(0);
        Assert.assertEquals((Object)"Large", (Object)rule.getName());
        Assert.assertEquals((double)1.6E8, (double)rule.getMaxScaleDenominator(), (double)0.1);
        PointSymbolizer point = (PointSymbolizer)rule.symbolizers().get(0);
        Assert.assertEquals((Object)"circle", (Object)SLD.wellKnownName((Mark)SLD.mark((PointSymbolizer)point)));
        Assert.assertEquals((Object)this.color("CC3300"), (Object)SLD.color((Fill)SLD.fill((PointSymbolizer)point)));
        Assert.assertEquals((long)12L, (long)SLD.pointSize((PointSymbolizer)point));
        rule = (Rule)((FeatureTypeStyle)style.featureTypeStyles().get(0)).rules().get(1);
        Assert.assertEquals((Object)"Medium", (Object)rule.getName());
        Assert.assertEquals((double)1.6E8, (double)rule.getMinScaleDenominator(), (double)0.1);
        Assert.assertEquals((double)3.2E8, (double)rule.getMaxScaleDenominator(), (double)0.1);
        point = (PointSymbolizer)rule.symbolizers().get(0);
        Assert.assertEquals((Object)"circle", (Object)SLD.wellKnownName((Mark)SLD.mark((PointSymbolizer)point)));
        Assert.assertEquals((Object)this.color("CC3300"), (Object)SLD.color((Fill)SLD.fill((PointSymbolizer)point)));
        Assert.assertEquals((long)8L, (long)SLD.pointSize((PointSymbolizer)point));
        rule = (Rule)((FeatureTypeStyle)style.featureTypeStyles().get(0)).rules().get(2);
        Assert.assertEquals((Object)"Small", (Object)rule.getName());
        Assert.assertEquals((double)3.2E8, (double)rule.getMinScaleDenominator(), (double)0.1);
        point = (PointSymbolizer)rule.symbolizers().get(0);
        Assert.assertEquals((Object)"circle", (Object)SLD.wellKnownName((Mark)SLD.mark((PointSymbolizer)point)));
        Assert.assertEquals((Object)this.color("CC3300"), (Object)SLD.color((Fill)SLD.fill((PointSymbolizer)point)));
        Assert.assertEquals((long)4L, (long)SLD.pointSize((PointSymbolizer)point));
    }

    @Test
    public void testPointWithAttribute() throws Exception {
        Style style = this.parse("point", "attribute.sld");
        Rule rule = (Rule)((FeatureTypeStyle)style.featureTypeStyles().get(0)).rules().get(0);
        Assert.assertEquals((Object)"SmallPop", (Object)rule.getName());
        Assert.assertEquals((Object)"pop < '50000'", (Object)ECQL.toCQL((Filter)rule.getFilter()));
        rule = (Rule)((FeatureTypeStyle)style.featureTypeStyles().get(0)).rules().get(1);
        Assert.assertEquals((Object)"MediumPop", (Object)rule.getName());
        Assert.assertEquals((Object)"pop >= '50000' AND pop < '100000'", (Object)ECQL.toCQL((Filter)rule.getFilter()));
        rule = (Rule)((FeatureTypeStyle)style.featureTypeStyles().get(0)).rules().get(2);
        Assert.assertEquals((Object)"LargePop", (Object)rule.getName());
        Assert.assertEquals((Object)"pop >= '100000'", (Object)ECQL.toCQL((Filter)rule.getFilter()));
    }

    @Test
    public void testPointWithRotation() throws Exception {
        Style style = this.parse("point", "rotated-square.sld");
        PointSymbolizer point = SLD.pointSymbolizer((Style)style);
        Assert.assertEquals((Object)"square", (Object)SLD.wellKnownName((Mark)SLD.mark((PointSymbolizer)point)));
        Assert.assertEquals((Object)this.color("009900"), (Object)SLD.color((Fill)SLD.fill((PointSymbolizer)point)));
        Assert.assertEquals((long)12L, (long)SLD.pointSize((PointSymbolizer)point));
        Assert.assertEquals((long)45L, (long)Filters.asInt((Expression)SLD.graphic((PointSymbolizer)point).getRotation()));
    }

    @Test
    public void testPointWithTransparentTriangle() throws Exception {
        Style style = this.parse("point", "transparent-triangle.sld");
        PointSymbolizer point = SLD.pointSymbolizer((Style)style);
        Assert.assertEquals((Object)"triangle", (Object)SLD.wellKnownName((Mark)SLD.mark((PointSymbolizer)point)));
        Assert.assertEquals((Object)this.color("009900"), (Object)SLD.color((Fill)SLD.fill((PointSymbolizer)point)));
        Assert.assertEquals((double)0.2, (double)SLD.opacity((Fill)SLD.fill((PointSymbolizer)point)), (double)0.1);
        Assert.assertEquals((Object)Color.black, (Object)SLD.color((Stroke)SLD.stroke((PointSymbolizer)point)));
        Assert.assertEquals((long)2L, (long)SLD.width((Stroke)SLD.stroke((PointSymbolizer)point)));
        Assert.assertEquals((long)12L, (long)SLD.pointSize((PointSymbolizer)point));
    }

    @Test
    public void testPointWithLabel() throws Exception {
        Style style = this.parse("point", "default-label.sld");
        TextSymbolizer text = SLD.textSymbolizer((Style)style);
        Assert.assertEquals((Object)"name", (Object)SLD.textLabelString((TextSymbolizer)text));
        Assert.assertEquals((Object)Color.black, (Object)SLD.textFontFill((TextSymbolizer)text));
    }

    @Test
    public void testPointWithStyledLabel() throws Exception {
        Style style = this.parse("point", "styled-label.sld");
        TextSymbolizer text = SLD.textSymbolizer((Style)style);
        Assert.assertEquals((Object)"name", (Object)SLD.textLabelString((TextSymbolizer)text));
        Assert.assertEquals((Object)Color.black, (Object)SLD.textFontFill((TextSymbolizer)text));
        Font font = SLD.font((TextSymbolizer)text);
        Assert.assertEquals((Object)"Arial", (Object)Filters.asString((Expression)((Expression)font.getFamily().get(0))));
        Assert.assertEquals((long)12L, (long)Filters.asInt((Expression)font.getSize()));
        Assert.assertEquals((Object)"bold", (Object)Filters.asString((Expression)font.getWeight()));
        Assert.assertEquals((Object)"normal", (Object)Filters.asString((Expression)font.getStyle()));
        PointPlacement placement = (PointPlacement)text.getLabelPlacement();
        Assert.assertEquals((double)0.5, (double)Filters.asDouble((Expression)placement.getAnchorPoint().getAnchorPointX()), (double)0.1);
        Assert.assertEquals((double)0.0, (double)Filters.asDouble((Expression)placement.getAnchorPoint().getAnchorPointY()), (double)0.1);
        Assert.assertEquals((long)0L, (long)Filters.asInt((Expression)placement.getDisplacement().getDisplacementX()));
        Assert.assertEquals((long)5L, (long)Filters.asInt((Expression)placement.getDisplacement().getDisplacementY()));
    }

    @Test
    public void testPointWithRotatedLabel() throws Exception {
        Style style = this.parse("point", "rotated-label.sld");
        TextSymbolizer text = SLD.textSymbolizer((Style)style);
        Assert.assertEquals((Object)"name", (Object)SLD.textLabelString((TextSymbolizer)text));
        Assert.assertEquals((Object)this.color("990099"), (Object)SLD.textFontFill((TextSymbolizer)text));
        Font font = SLD.font((TextSymbolizer)text);
        Assert.assertEquals((Object)"Arial", (Object)Filters.asString((Expression)((Expression)font.getFamily().get(0))));
        Assert.assertEquals((long)12L, (long)Filters.asInt((Expression)font.getSize()));
        Assert.assertEquals((Object)"bold", (Object)Filters.asString((Expression)font.getWeight()));
        Assert.assertEquals((Object)"normal", (Object)Filters.asString((Expression)font.getStyle()));
        PointPlacement placement = (PointPlacement)text.getLabelPlacement();
        Assert.assertEquals((double)0.5, (double)Filters.asDouble((Expression)placement.getAnchorPoint().getAnchorPointX()), (double)0.1);
        Assert.assertEquals((double)0.0, (double)Filters.asDouble((Expression)placement.getAnchorPoint().getAnchorPointY()), (double)0.1);
        Assert.assertEquals((long)0L, (long)Filters.asInt((Expression)placement.getDisplacement().getDisplacementX()));
        Assert.assertEquals((long)25L, (long)Filters.asInt((Expression)placement.getDisplacement().getDisplacementY()));
        Assert.assertEquals((long)-45L, (long)Filters.asInt((Expression)placement.getRotation()));
    }

    @Test
    public void testPointWithRuleVendorOption() throws Exception {
        Style style = this.parse("point", "rule-option.sld");
        List rules = ((FeatureTypeStyle)style.featureTypeStyles().get(0)).rules();
        MatcherAssert.assertThat((Object)((Rule)rules.get(0)).getOptions(), (Matcher)Matchers.hasEntry((Object)"inclusion", (Object)"mapOnly"));
        MatcherAssert.assertThat((Object)((Rule)rules.get(1)).getOptions(), (Matcher)Matchers.hasEntry((Object)"inclusion", (Object)"legendOnly"));
    }

    @Test
    public void testLineSimple() throws Exception {
        Style style = this.parse("line", "simple.sld");
        LineSymbolizer line = SLD.lineSymbolizer((Style)style);
        Assert.assertEquals((Object)Color.black, (Object)SLD.lineColor((LineSymbolizer)line));
        Assert.assertEquals((long)3L, (long)SLD.lineWidth((LineSymbolizer)line));
    }

    @Test
    public void testLineWithAttribute() throws Exception {
        Style style = this.parse("line", "attribute.sld");
        FeatureTypeStyle featureStyle = (FeatureTypeStyle)style.featureTypeStyles().get(0);
        Rule rule = (Rule)featureStyle.rules().get(0);
        Assert.assertEquals((Object)"local-road", (Object)rule.getName());
        Assert.assertEquals((Object)"type = 'local-road'", (Object)ECQL.toCQL((Filter)rule.getFilter()));
        LineSymbolizer line = (LineSymbolizer)rule.symbolizers().get(0);
        Assert.assertEquals((Object)this.color("009933"), (Object)SLD.color((LineSymbolizer)line));
        Assert.assertEquals((long)2L, (long)SLD.width((LineSymbolizer)line));
        featureStyle = (FeatureTypeStyle)style.featureTypeStyles().get(1);
        rule = (Rule)featureStyle.rules().get(0);
        Assert.assertEquals((Object)"secondary", (Object)rule.getName());
        Assert.assertEquals((Object)"type = 'secondary'", (Object)ECQL.toCQL((Filter)rule.getFilter()));
        line = (LineSymbolizer)rule.symbolizers().get(0);
        Assert.assertEquals((Object)this.color("0055CC"), (Object)SLD.color((LineSymbolizer)line));
        Assert.assertEquals((long)3L, (long)SLD.width((LineSymbolizer)line));
        featureStyle = (FeatureTypeStyle)style.featureTypeStyles().get(2);
        rule = (Rule)featureStyle.rules().get(0);
        Assert.assertEquals((Object)"highway", (Object)rule.getName());
        Assert.assertEquals((Object)"type = 'highway'", (Object)ECQL.toCQL((Filter)rule.getFilter()));
        line = (LineSymbolizer)rule.symbolizers().get(0);
        Assert.assertEquals((Object)this.color("FF0000"), (Object)SLD.color((LineSymbolizer)line));
        Assert.assertEquals((long)6L, (long)SLD.width((LineSymbolizer)line));
    }

    @Test
    public void testLineWithBorder() throws Exception {
        Style style = this.parse("line", "border.sld");
        FeatureTypeStyle featureStyle = (FeatureTypeStyle)style.featureTypeStyles().get(0);
        LineSymbolizer line = SLD.lineSymbolizer((FeatureTypeStyle)featureStyle);
        Assert.assertEquals((Object)this.color("333333"), (Object)SLD.color((LineSymbolizer)line));
        Assert.assertEquals((long)5L, (long)SLD.width((LineSymbolizer)line));
        Assert.assertEquals((Object)"round", (Object)SLD.lineLinecap((LineSymbolizer)line));
        featureStyle = (FeatureTypeStyle)style.featureTypeStyles().get(1);
        line = SLD.lineSymbolizer((FeatureTypeStyle)featureStyle);
        Assert.assertEquals((Object)this.color("6699FF"), (Object)SLD.color((LineSymbolizer)line));
        Assert.assertEquals((long)3L, (long)SLD.width((LineSymbolizer)line));
        Assert.assertEquals((Object)"round", (Object)SLD.lineLinecap((LineSymbolizer)line));
    }

    @Test
    public void testLineWithCurvedLabel() throws Exception {
        Style style = this.parse("line", "curved-label.sld");
        TextSymbolizer text = SLD.textSymbolizer((Style)style);
        Assert.assertEquals((Object)"name", (Object)SLD.textLabelString((TextSymbolizer)text));
        Map options = text.getOptions();
        Assert.assertEquals((Object)"true", options.get("followLine"));
    }

    @Test
    public void testLineWithDashdot() throws Exception {
        Style style = this.parse("line", "dash-dot.sld");
        LineSymbolizer line = (LineSymbolizer)SLD.rules((Style)style)[0].symbolizers().get(0);
        Assert.assertEquals((Object)Color.blue, (Object)SLD.color((LineSymbolizer)line));
        Assert.assertEquals((long)1L, (long)SLD.width((LineSymbolizer)line));
        Assert.assertEquals((double)10.0, (double)SLD.lineDash((LineSymbolizer)line)[0], (double)0.1);
        Assert.assertEquals((double)10.0, (double)SLD.lineDash((LineSymbolizer)line)[0], (double)0.1);
        line = (LineSymbolizer)SLD.rules((Style)style)[0].symbolizers().get(1);
        Stroke stroke = line.getStroke();
        Assert.assertEquals((double)5.0, (double)SLD.lineDash((LineSymbolizer)line)[0], (double)0.1);
        Assert.assertEquals((double)15.0, (double)SLD.lineDash((LineSymbolizer)line)[1], (double)0.1);
        Assert.assertEquals((double)7.5, (double)Filters.asDouble((Expression)stroke.getDashOffset()), (double)0.1);
        Graphic g = stroke.getGraphicStroke();
        Assert.assertEquals((long)5L, (long)Filters.asInt((Expression)g.getSize()));
        Mark mark = SLD.mark((Graphic)g);
        Assert.assertEquals((Object)"circle", (Object)SLD.wellKnownName((Mark)mark));
        Assert.assertEquals((Object)this.color("000033"), (Object)SLD.color((Stroke)mark.getStroke()));
        Assert.assertEquals((long)1L, (long)SLD.width((Stroke)mark.getStroke()));
    }

    @Test
    public void testLineWithDashedline() throws Exception {
        Style style = this.parse("line", "dashed-line.sld");
        LineSymbolizer line = SLD.lineSymbolizer((Style)style);
        Assert.assertEquals((Object)Color.blue, (Object)SLD.color((LineSymbolizer)line));
        Assert.assertEquals((long)3L, (long)SLD.width((LineSymbolizer)line));
        Assert.assertEquals((double)5.0, (double)SLD.lineDash((LineSymbolizer)line)[0], (double)0.1);
        Assert.assertEquals((double)2.0, (double)SLD.lineDash((LineSymbolizer)line)[1], (double)0.1);
    }

    @Test
    public void testLineWithDashspace() throws Exception {
        Style style = this.parse("line", "dash-space.sld");
        LineSymbolizer line = SLD.lineSymbolizer((Style)style);
        Assert.assertEquals((double)4.0, (double)SLD.lineDash((LineSymbolizer)line)[0], (double)0.1);
        Assert.assertEquals((double)6.0, (double)SLD.lineDash((LineSymbolizer)line)[1], (double)0.1);
        Mark mark = SLD.mark((Graphic)line.getStroke().getGraphicStroke());
        Assert.assertEquals((Object)"circle", (Object)SLD.wellKnownName((Mark)mark));
        Assert.assertEquals((Object)this.color("666666"), (Object)SLD.color((Fill)mark.getFill()));
        Assert.assertEquals((Object)this.color("333333"), (Object)SLD.color((Stroke)mark.getStroke()));
        Assert.assertEquals((long)1L, (long)SLD.width((Stroke)mark.getStroke()));
    }

    @Test
    public void testLineWithDefaultLabel() throws Exception {
        Style style = this.parse("line", "default-label.sld");
        LineSymbolizer line = SLD.lineSymbolizer((Style)style);
        Assert.assertEquals((Object)Color.red, (Object)SLD.color((LineSymbolizer)line));
        TextSymbolizer text = SLD.textSymbolizer((Style)style);
        Assert.assertEquals((Object)"name", (Object)SLD.textLabelString((TextSymbolizer)text));
        Assert.assertEquals((Object)Color.black, (Object)SLD.color((Fill)text.getFill()));
    }

    @Test
    public void testLineWithRailroad() throws Exception {
        Style style = this.parse("line", "railroad.sld");
        LineSymbolizer line = (LineSymbolizer)SLD.rules((Style)style)[0].symbolizers().get(0);
        Assert.assertEquals((Object)this.color("333333"), (Object)SLD.color((LineSymbolizer)line));
        Assert.assertEquals((long)3L, (long)SLD.width((LineSymbolizer)line));
        line = (LineSymbolizer)SLD.rules((Style)style)[0].symbolizers().get(1);
        Graphic g = line.getStroke().getGraphicStroke();
        Mark mark = SLD.mark((Graphic)g);
        Assert.assertEquals((Object)"shape://vertline", (Object)SLD.wellKnownName((Mark)mark));
        Assert.assertEquals((Object)this.color("333333"), (Object)SLD.color((Stroke)mark.getStroke()));
        Assert.assertEquals((long)1L, (long)SLD.width((Stroke)mark.getStroke()));
        Assert.assertEquals((long)12L, (long)Filters.asInt((Expression)g.getSize()));
    }

    @Test
    public void testLineWithZoom() throws Exception {
        Style style = this.parse("line", "zoom.sld");
        Rule rule = (Rule)((FeatureTypeStyle)style.featureTypeStyles().get(0)).rules().get(0);
        Assert.assertEquals((Object)"Large", (Object)rule.getName());
        Assert.assertEquals((double)1.8E8, (double)rule.getMaxScaleDenominator(), (double)0.1);
        LineSymbolizer line = (LineSymbolizer)rule.symbolizers().get(0);
        Assert.assertEquals((Object)this.color("009933"), (Object)SLD.color((LineSymbolizer)line));
        Assert.assertEquals((long)6L, (long)SLD.width((LineSymbolizer)line));
        rule = (Rule)((FeatureTypeStyle)style.featureTypeStyles().get(0)).rules().get(1);
        Assert.assertEquals((Object)"Medium", (Object)rule.getName());
        Assert.assertEquals((double)3.6E8, (double)rule.getMaxScaleDenominator(), (double)0.1);
        Assert.assertEquals((double)1.8E8, (double)rule.getMinScaleDenominator(), (double)0.1);
        line = (LineSymbolizer)rule.symbolizers().get(0);
        Assert.assertEquals((Object)this.color("009933"), (Object)SLD.color((LineSymbolizer)line));
        Assert.assertEquals((long)4L, (long)SLD.width((LineSymbolizer)line));
        rule = (Rule)((FeatureTypeStyle)style.featureTypeStyles().get(0)).rules().get(2);
        Assert.assertEquals((Object)"Small", (Object)rule.getName());
        Assert.assertEquals((double)3.6E8, (double)rule.getMinScaleDenominator(), (double)0.1);
        line = (LineSymbolizer)rule.symbolizers().get(0);
        Assert.assertEquals((Object)this.color("009933"), (Object)SLD.color((LineSymbolizer)line));
        Assert.assertEquals((long)2L, (long)SLD.width((LineSymbolizer)line));
    }

    @Test
    public void testLineWithOptimizedLabel() throws Exception {
        Style style = this.parse("line", "optimized-label.sld");
        LineSymbolizer line = SLD.lineSymbolizer((Style)style);
        Assert.assertEquals((Object)Color.red, (Object)SLD.color((LineSymbolizer)line));
        TextSymbolizer text = SLD.textSymbolizer((Style)style);
        Assert.assertEquals((Object)"name", (Object)SLD.textLabelString((TextSymbolizer)text));
        Assert.assertEquals((Object)Color.black, (Object)SLD.color((Fill)text.getFill()));
        Map options = text.getOptions();
        Assert.assertEquals((Object)"true", options.get("followLine"));
        Assert.assertEquals((Object)"90", options.get("maxAngleDelta"));
        Assert.assertEquals((Object)"400", options.get("maxDisplacement"));
        Assert.assertEquals((Object)"150", options.get("repeat"));
    }

    @Test
    public void testLineWithOptimizedAndStyledLabel() throws Exception {
        Style style = this.parse("line", "optimized-styled-label.sld");
        LineSymbolizer line = SLD.lineSymbolizer((Style)style);
        Assert.assertEquals((Object)Color.red, (Object)SLD.color((LineSymbolizer)line));
        TextSymbolizer text = SLD.textSymbolizer((Style)style);
        Assert.assertEquals((Object)"name", (Object)SLD.textLabelString((TextSymbolizer)text));
        Assert.assertEquals((Object)Color.black, (Object)SLD.color((Fill)text.getFill()));
        Font font = SLD.font((TextSymbolizer)text);
        Assert.assertEquals((Object)"Arial", (Object)Filters.asString((Expression)((Expression)font.getFamily().get(0))));
        Assert.assertEquals((long)10L, (long)Filters.asInt((Expression)font.getSize()));
        Assert.assertEquals((Object)"normal", (Object)Filters.asString((Expression)font.getStyle()));
        Assert.assertEquals((Object)"bold", (Object)Filters.asString((Expression)font.getWeight()));
        Map options = text.getOptions();
        Assert.assertEquals((Object)"true", options.get("followLine"));
        Assert.assertEquals((Object)"90", options.get("maxAngleDelta"));
        Assert.assertEquals((Object)"400", options.get("maxDisplacement"));
        Assert.assertEquals((Object)"150", options.get("repeat"));
    }

    @Test
    public void testPolygonSimple() throws Exception {
        Style style = this.parse("poly", "simple.sld");
        PolygonSymbolizer poly = SLD.polySymbolizer((Style)style);
        Assert.assertEquals((Object)this.color("000080"), (Object)SLD.color((Fill)poly.getFill()));
    }

    @Test
    public void testPolygonWithAttribute() throws Exception {
        Style style = this.parse("poly", "attribute.sld");
        Rule rule = (Rule)((FeatureTypeStyle)style.featureTypeStyles().get(0)).rules().get(0);
        Assert.assertEquals((Object)"SmallPop", (Object)rule.getName());
        Assert.assertEquals((Object)"pop < '200000'", (Object)ECQL.toCQL((Filter)rule.getFilter()));
        PolygonSymbolizer poly = (PolygonSymbolizer)rule.symbolizers().get(0);
        Assert.assertEquals((Object)this.color("66FF66"), (Object)SLD.color((Fill)poly.getFill()));
        rule = (Rule)((FeatureTypeStyle)style.featureTypeStyles().get(0)).rules().get(1);
        Assert.assertEquals((Object)"MediumPop", (Object)rule.getName());
        Assert.assertEquals((Object)"pop >= '200000' AND pop < '500000'", (Object)ECQL.toCQL((Filter)rule.getFilter()));
        poly = (PolygonSymbolizer)rule.symbolizers().get(0);
        Assert.assertEquals((Object)this.color("33CC33"), (Object)SLD.color((Fill)poly.getFill()));
        rule = (Rule)((FeatureTypeStyle)style.featureTypeStyles().get(0)).rules().get(2);
        Assert.assertEquals((Object)"LargePop", (Object)rule.getName());
        Assert.assertEquals((Object)"pop > '500000'", (Object)ECQL.toCQL((Filter)rule.getFilter()));
        poly = (PolygonSymbolizer)rule.symbolizers().get(0);
        Assert.assertEquals((Object)this.color("009900"), (Object)SLD.color((Fill)poly.getFill()));
    }

    @Test
    public void testPolygonWithDefaultLabel() throws Exception {
        Style style = this.parse("poly", "default-label.sld");
        PolygonSymbolizer poly = SLD.polySymbolizer((Style)style);
        Assert.assertEquals((Object)this.color("40FF40"), (Object)SLD.color((Fill)poly.getFill()));
        Assert.assertEquals((Object)this.color("FFFFFF"), (Object)SLD.color((Stroke)poly.getStroke()));
        Assert.assertEquals((long)2L, (long)SLD.width((Stroke)poly.getStroke()));
        TextSymbolizer text = SLD.textSymbolizer((Style)style);
        Assert.assertEquals((Object)"name", (Object)SLD.textLabelString((TextSymbolizer)text));
    }

    @Test
    public void testPolygonWithGraphicFill() throws Exception {
        Style style = this.parse("poly", "graphic-fill.sld");
        PolygonSymbolizer poly = SLD.polySymbolizer((Style)style);
        Graphic g = poly.getFill().getGraphicFill();
        ExternalGraphic external = (ExternalGraphic)g.graphicalSymbols().get(0);
        Assert.assertEquals((Object)"file:colorblocks.png", (Object)external.getLocation().toString());
        Assert.assertEquals((Object)"image/png", (Object)external.getFormat());
        Assert.assertEquals((long)93L, (long)Filters.asInt((Expression)g.getSize()));
    }

    @Test
    public void testPolygonWithHaloLabel() throws Exception {
        Style style = this.parse("poly", "halo-label.sld");
        PolygonSymbolizer poly = SLD.polySymbolizer((Style)style);
        Assert.assertEquals((Object)this.color("40FF40"), (Object)SLD.color((Fill)poly.getFill()));
        Assert.assertEquals((Object)this.color("FFFFFF"), (Object)SLD.color((Stroke)poly.getStroke()));
        Assert.assertEquals((long)2L, (long)SLD.width((Stroke)poly.getStroke()));
        TextSymbolizer text = SLD.textSymbolizer((Style)style);
        Assert.assertEquals((Object)"name", (Object)SLD.textLabelString((TextSymbolizer)text));
        Assert.assertEquals((Object)this.color("FFFFFF"), (Object)SLD.textHaloFill((TextSymbolizer)text));
        Assert.assertEquals((long)3L, (long)SLD.textHaloWidth((TextSymbolizer)text));
    }

    @Test
    public void testPolygonWithHatchFill() throws Exception {
        Style style = this.parse("poly", "hatch-fill.sld");
        PolygonSymbolizer poly = SLD.polySymbolizer((Style)style);
        Mark mark = SLD.mark((Graphic)poly.getFill().getGraphicFill());
        Assert.assertEquals((Object)"shape://times", (Object)Filters.asString((Expression)mark.getWellKnownName()));
        Assert.assertEquals((Object)this.color("990099"), (Object)SLD.color((Stroke)mark.getStroke()));
        Assert.assertEquals((long)1L, (long)SLD.width((Stroke)mark.getStroke()));
        Assert.assertEquals((long)16L, (long)Filters.asInt((Expression)poly.getFill().getGraphicFill().getSize()));
    }

    @Test
    public void testPolygonWithStroke() throws Exception {
        Style style = this.parse("poly", "stroke.sld");
        PolygonSymbolizer poly = SLD.polySymbolizer((Style)style);
        Assert.assertEquals((Object)this.color("000080"), (Object)SLD.color((Fill)poly.getFill()));
        Assert.assertEquals((Object)this.color("FFFFFF"), (Object)SLD.color((Stroke)poly.getStroke()));
        Assert.assertEquals((long)2L, (long)SLD.width((Stroke)poly.getStroke()));
    }

    @Test
    public void testPolygonWithStyledLabel() throws Exception {
        Style style = this.parse("poly", "styled-label.sld");
        PolygonSymbolizer poly = SLD.polySymbolizer((Style)style);
        Assert.assertEquals((Object)this.color("40FF40"), (Object)SLD.color((Fill)poly.getFill()));
        Assert.assertEquals((Object)this.color("FFFFFF"), (Object)SLD.color((Stroke)poly.getStroke()));
        Assert.assertEquals((long)2L, (long)SLD.width((Stroke)poly.getStroke()));
        TextSymbolizer text = SLD.textSymbolizer((Style)style);
        MatcherAssert.assertThat((Object)SLD.textLabel((TextSymbolizer)text), TestUtils.attribute("name"));
        Assert.assertEquals((Object)Color.black, (Object)SLD.color((Fill)text.getFill()));
        PointPlacement place = (PointPlacement)text.getLabelPlacement();
        Assert.assertEquals((double)0.5, (double)Filters.asDouble((Expression)place.getAnchorPoint().getAnchorPointX()), (double)0.1);
        Assert.assertEquals((double)0.5, (double)Filters.asDouble((Expression)place.getAnchorPoint().getAnchorPointY()), (double)0.1);
        Font font = SLD.font((TextSymbolizer)text);
        Assert.assertEquals((Object)"Arial", (Object)Filters.asString((Expression)((Expression)font.getFamily().get(0))));
        Assert.assertEquals((long)11L, (long)Filters.asInt((Expression)font.getSize()));
        Assert.assertEquals((Object)"normal", (Object)Filters.asString((Expression)font.getStyle()));
        Assert.assertEquals((Object)"bold", (Object)Filters.asString((Expression)font.getWeight()));
        Map options = text.getOptions();
        Assert.assertEquals((Object)"60", options.get("autoWrap"));
        Assert.assertEquals((Object)"150", options.get("maxDisplacement"));
    }

    @Test
    public void testPolygonWithTransparent() throws Exception {
        Style style = this.parse("poly", "transparent.sld");
        PolygonSymbolizer poly = SLD.polySymbolizer((Style)style);
        Assert.assertEquals((Object)this.color("000080"), (Object)SLD.color((Fill)poly.getFill()));
        Assert.assertEquals((double)0.5, (double)SLD.opacity((Fill)poly.getFill()), (double)0.1);
        Assert.assertEquals((Object)this.color("FFFFFF"), (Object)SLD.color((Stroke)poly.getStroke()));
        Assert.assertEquals((long)2L, (long)SLD.width((Stroke)poly.getStroke()));
    }

    @Test
    public void testPolygonWithZoom() throws Exception {
        Style style = this.parse("poly", "zoom.sld");
        Rule rule = (Rule)((FeatureTypeStyle)style.featureTypeStyles().get(0)).rules().get(0);
        Assert.assertEquals((Object)"Large", (Object)rule.getName());
        Assert.assertEquals((double)1.0E8, (double)rule.getMaxScaleDenominator(), (double)0.1);
        PolygonSymbolizer poly = (PolygonSymbolizer)rule.symbolizers().get(0);
        Assert.assertEquals((Object)this.color("0000CC"), (Object)SLD.color((Fill)poly.getFill()));
        Assert.assertEquals((Object)this.color("000000"), (Object)SLD.color((Stroke)poly.getStroke()));
        Assert.assertEquals((long)7L, (long)SLD.width((Stroke)poly.getStroke()));
        rule = (Rule)((FeatureTypeStyle)style.featureTypeStyles().get(0)).rules().get(1);
        Assert.assertEquals((Object)"Medium", (Object)rule.getName());
        Assert.assertEquals((double)2.0E8, (double)rule.getMaxScaleDenominator(), (double)0.1);
        Assert.assertEquals((double)1.0E8, (double)rule.getMinScaleDenominator(), (double)0.1);
        poly = (PolygonSymbolizer)rule.symbolizers().get(0);
        Assert.assertEquals((Object)this.color("0000CC"), (Object)SLD.color((Fill)poly.getFill()));
        Assert.assertEquals((Object)this.color("000000"), (Object)SLD.color((Stroke)poly.getStroke()));
        Assert.assertEquals((long)4L, (long)SLD.width((Stroke)poly.getStroke()));
        rule = (Rule)((FeatureTypeStyle)style.featureTypeStyles().get(0)).rules().get(2);
        Assert.assertEquals((Object)"Small", (Object)rule.getName());
        Assert.assertEquals((double)2.0E8, (double)rule.getMinScaleDenominator(), (double)0.1);
        poly = (PolygonSymbolizer)rule.symbolizers().get(0);
        Assert.assertEquals((Object)this.color("0000CC"), (Object)SLD.color((Fill)poly.getFill()));
        Assert.assertEquals((Object)this.color("000000"), (Object)SLD.color((Stroke)poly.getStroke()));
        Assert.assertEquals((long)1L, (long)SLD.width((Stroke)poly.getStroke()));
    }

    @Test
    public void testRasterWithAlphaChannel() throws Exception {
        Style style = this.parse("raster", "alpha-channel.sld");
        RasterSymbolizer raster = SLD.rasterSymbolizer((Style)style);
        ColorMapEntry e = raster.getColorMap().getColorMapEntry(0);
        Assert.assertEquals((Object)"#008000", (Object)Filters.asString((Expression)e.getColor()));
        Assert.assertEquals((long)70L, (long)Filters.asInt((Expression)e.getQuantity()));
        e = raster.getColorMap().getColorMapEntry(1);
        Assert.assertEquals((Object)"#008000", (Object)Filters.asString((Expression)e.getColor()));
        Assert.assertEquals((long)256L, (long)Filters.asInt((Expression)e.getQuantity()));
        Assert.assertEquals((long)0L, (long)Filters.asInt((Expression)e.getOpacity()));
    }

    @Test
    public void testRasterWithBrightnessAndContrast() throws Exception {
        Style style = this.parse("raster", "brightness-and-contrast.sld");
        RasterSymbolizer raster = SLD.rasterSymbolizer((Style)style);
        ContrastEnhancement contrast = raster.getContrastEnhancement();
        Assert.assertEquals((double)0.5, (double)Filters.asDouble((Expression)contrast.getGammaValue()), (double)0.1);
        Assert.assertEquals((Object)ContrastMethod.NORMALIZE, (Object)contrast.getMethod());
        ColorMapEntry e = raster.getColorMap().getColorMapEntry(0);
        Assert.assertEquals((Object)"#008000", (Object)Filters.asString((Expression)e.getColor()));
        Assert.assertEquals((long)70L, (long)Filters.asInt((Expression)e.getQuantity()));
        e = raster.getColorMap().getColorMapEntry(1);
        Assert.assertEquals((Object)"#663333", (Object)Filters.asString((Expression)e.getColor()));
        Assert.assertEquals((long)256L, (long)Filters.asInt((Expression)e.getQuantity()));
    }

    @Test
    public void testRasterWithDiscreteColors() throws Exception {
        Style style = this.parse("raster", "discrete-colors.sld");
        RasterSymbolizer raster = SLD.rasterSymbolizer((Style)style);
        ColorMapEntry e = raster.getColorMap().getColorMapEntry(0);
        Assert.assertEquals((Object)"#008000", (Object)Filters.asString((Expression)e.getColor()));
        Assert.assertEquals((long)150L, (long)Filters.asInt((Expression)e.getQuantity()));
        e = raster.getColorMap().getColorMapEntry(1);
        Assert.assertEquals((Object)"#663333", (Object)Filters.asString((Expression)e.getColor()));
        Assert.assertEquals((long)256L, (long)Filters.asInt((Expression)e.getQuantity()));
    }

    @Test
    public void testRasterWithManyColorGradient() throws Exception {
        Style style = this.parse("raster", "many-color-gradient.sld");
        RasterSymbolizer raster = SLD.rasterSymbolizer((Style)style);
        ColorMapEntry e = raster.getColorMap().getColorMapEntry(0);
        Assert.assertEquals((Object)"#000000", (Object)Filters.asString((Expression)e.getColor()));
        Assert.assertEquals((long)95L, (long)Filters.asInt((Expression)e.getQuantity()));
        e = raster.getColorMap().getColorMapEntry(1);
        Assert.assertEquals((Object)"#0000FF", (Object)Filters.asString((Expression)e.getColor()));
        Assert.assertEquals((long)110L, (long)Filters.asInt((Expression)e.getQuantity()));
        e = raster.getColorMap().getColorMapEntry(2);
        Assert.assertEquals((Object)"#00FF00", (Object)Filters.asString((Expression)e.getColor()));
        Assert.assertEquals((long)135L, (long)Filters.asInt((Expression)e.getQuantity()));
        e = raster.getColorMap().getColorMapEntry(3);
        Assert.assertEquals((Object)"#FF0000", (Object)Filters.asString((Expression)e.getColor()));
        Assert.assertEquals((long)160L, (long)Filters.asInt((Expression)e.getQuantity()));
        e = raster.getColorMap().getColorMapEntry(4);
        Assert.assertEquals((Object)"#FF00FF", (Object)Filters.asString((Expression)e.getColor()));
        Assert.assertEquals((long)185L, (long)Filters.asInt((Expression)e.getQuantity()));
        e = raster.getColorMap().getColorMapEntry(5);
        Assert.assertEquals((Object)"#FFFF00", (Object)Filters.asString((Expression)e.getColor()));
        Assert.assertEquals((long)210L, (long)Filters.asInt((Expression)e.getQuantity()));
        e = raster.getColorMap().getColorMapEntry(6);
        Assert.assertEquals((Object)"#00FFFF", (Object)Filters.asString((Expression)e.getColor()));
        Assert.assertEquals((long)235L, (long)Filters.asInt((Expression)e.getQuantity()));
        e = raster.getColorMap().getColorMapEntry(7);
        Assert.assertEquals((Object)"#FFFFFF", (Object)Filters.asString((Expression)e.getColor()));
        Assert.assertEquals((long)256L, (long)Filters.asInt((Expression)e.getQuantity()));
    }

    @Test
    public void testRasterWithThreeColorGradient() throws Exception {
        Style style = this.parse("raster", "three-color-gradient.sld");
        RasterSymbolizer raster = SLD.rasterSymbolizer((Style)style);
        ColorMapEntry e = raster.getColorMap().getColorMapEntry(0);
        Assert.assertEquals((Object)"#0000FF", (Object)Filters.asString((Expression)e.getColor()));
        Assert.assertEquals((long)150L, (long)Filters.asInt((Expression)e.getQuantity()));
        e = raster.getColorMap().getColorMapEntry(1);
        Assert.assertEquals((Object)"#FFFF00", (Object)Filters.asString((Expression)e.getColor()));
        Assert.assertEquals((long)200L, (long)Filters.asInt((Expression)e.getQuantity()));
        e = raster.getColorMap().getColorMapEntry(2);
        Assert.assertEquals((Object)"#FF0000", (Object)Filters.asString((Expression)e.getColor()));
        Assert.assertEquals((long)250L, (long)Filters.asInt((Expression)e.getQuantity()));
    }

    @Test
    public void testRasterWithTransparentGradient() throws Exception {
        Style style = this.parse("raster", "transparent-gradient.sld");
        RasterSymbolizer raster = SLD.rasterSymbolizer((Style)style);
        Assert.assertEquals((double)0.3, (double)Filters.asDouble((Expression)raster.getOpacity()), (double)0.1);
        ColorMapEntry e = raster.getColorMap().getColorMapEntry(0);
        Assert.assertEquals((Object)"#008000", (Object)Filters.asString((Expression)e.getColor()));
        Assert.assertEquals((long)70L, (long)Filters.asInt((Expression)e.getQuantity()));
        e = raster.getColorMap().getColorMapEntry(1);
        Assert.assertEquals((Object)"#663333", (Object)Filters.asString((Expression)e.getColor()));
        Assert.assertEquals((long)256L, (long)Filters.asInt((Expression)e.getQuantity()));
    }

    @Test
    public void testRasterWithTwoColorGradient() throws Exception {
        Style style = this.parse("raster", "two-color-gradient.sld");
        RasterSymbolizer raster = SLD.rasterSymbolizer((Style)style);
        ColorMapEntry e = raster.getColorMap().getColorMapEntry(0);
        Assert.assertEquals((Object)"#008000", (Object)Filters.asString((Expression)e.getColor()));
        Assert.assertEquals((long)70L, (long)Filters.asInt((Expression)e.getQuantity()));
        e = raster.getColorMap().getColorMapEntry(1);
        Assert.assertEquals((Object)"#663333", (Object)Filters.asString((Expression)e.getColor()));
        Assert.assertEquals((long)256L, (long)Filters.asInt((Expression)e.getQuantity()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRasterWithBandSelectionExpression() throws Exception {
        Style style = this.parse("raster", "band-selection-expression.sld");
        RasterSymbolizer raster = SLD.rasterSymbolizer((Style)style);
        Expression name = raster.getChannelSelection().getGrayChannel().getChannelName();
        Assert.assertEquals((Object)"1", (Object)((String)name.evaluate(null, String.class)).trim());
        try {
            EnvFunction.setLocalValue((String)"B1", (Object)"2");
            Assert.assertEquals((Object)"2", (Object)((String)name.evaluate(null, String.class)).trim());
        }
        finally {
            EnvFunction.clearLocalValues();
        }
    }

    Style parse(String dir, String file) throws IOException {
        StringWriter writer = new StringWriter();
        Ysld.transform((InputStream)YsldTests.sld(dir, file), (Writer)writer);
        YsldParser p = new YsldParser((Reader)new StringReader(writer.toString()));
        return SLD.defaultStyle((StyledLayerDescriptor)p.parse());
    }

    Color color(String hex) {
        return new Color(Integer.valueOf(hex.substring(0, 2), 16), Integer.valueOf(hex.substring(2, 4), 16), Integer.valueOf(hex.substring(4, 6), 16));
    }
}

