/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld.parse;

import java.util.List;
import org.geotools.api.style.ColorMap;
import org.geotools.api.style.ColorMapEntry;
import org.geotools.ysld.Tuple;
import org.geotools.ysld.YamlMap;
import org.geotools.ysld.YamlObject;
import org.geotools.ysld.YamlSeq;
import org.geotools.ysld.parse.Factory;
import org.geotools.ysld.parse.Util;
import org.geotools.ysld.parse.YamlParseContext;
import org.geotools.ysld.parse.YamlParseHandler;
import org.geotools.ysld.parse.YsldParseHandler;

public abstract class ColorMapParser
extends YsldParseHandler {
    ColorMap colorMap;

    public ColorMapParser(Factory factory) {
        super(factory);
        this.colorMap = factory.style.createColorMap();
    }

    @Override
    public void handle(YamlObject<?> obj, YamlParseContext context) {
        this.colorMap(this.colorMap);
        YamlMap map = obj.map();
        if (map.has("type")) {
            String value = map.str("type");
            if ("ramp".equals(value)) {
                this.colorMap.setType(1);
            } else if ("intervals".equals(value)) {
                this.colorMap.setType(2);
            } else if ("values".equals(value)) {
                this.colorMap.setType(3);
            } else {
                LOG.warning("Unknown color map type: " + value);
            }
        }
        context.push("entries", (YamlParseHandler)new EntriesParser());
    }

    protected abstract void colorMap(ColorMap var1);

    class EntriesParser
    extends YsldParseHandler {
        protected EntriesParser() {
            super(ColorMapParser.this.factory);
        }

        @Override
        public void handle(YamlObject<?> obj, YamlParseContext context) {
            YamlSeq seq = obj.seq();
            for (Object o : (List)seq.raw()) {
                Tuple q = null;
                try {
                    q = Tuple.of(4).parse(o);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException(String.format("Bad entry: '%s', must be of form [<color>,[<opacity>],[<value>],[<label>]]", o.toString()), e);
                }
                ColorMapEntry e = this.factory.style.createColorMapEntry();
                if (q.at(0) != null) {
                    e.setColor(Util.color(Util.stripQuotes(q.strAt(0)), this.factory));
                }
                if (q.at(1) != null) {
                    e.setOpacity(Util.expression(q.strAt(1), this.factory));
                }
                if (q.at(2) != null) {
                    e.setQuantity(Util.expression(q.strAt(2), this.factory));
                }
                if (q.at(3) != null) {
                    e.setLabel(q.strAt(3));
                }
                ColorMapParser.this.colorMap.addColorMapEntry(e);
            }
        }
    }
}

