/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld.transform.sld;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.geotools.ysld.transform.sld.ExpressionHandler;
import org.geotools.ysld.transform.sld.SldTransformContext;
import org.geotools.ysld.transform.sld.SldTransformHandler;

public class ParameterHandler
extends SldTransformHandler {
    Map<String, String> rename;
    List<String> strip;

    public ParameterHandler rename(String from, String to) {
        if (this.rename == null) {
            this.rename = new LinkedHashMap<String, String>();
        }
        this.rename.put(from, to);
        return this;
    }

    public ParameterHandler strip(String prefix) {
        if (this.strip == null) {
            this.strip = new ArrayList<String>();
        }
        this.strip.add(prefix);
        return this;
    }

    @Override
    public void element(XMLStreamReader xml, SldTransformContext context) throws XMLStreamException, IOException {
        String name = xml.getLocalName();
        if ("CssParameter".equals(name) || "SvgParameter".equals(name)) {
            String parameter = xml.getAttributeValue(null, "name");
            if (this.rename != null) {
                for (Map.Entry entry : this.rename.entrySet()) {
                    if (!((String)entry.getKey()).equals(parameter)) continue;
                    parameter = (String)entry.getValue();
                    break;
                }
            }
            if (this.strip != null) {
                for (String string : this.strip) {
                    if (!parameter.startsWith(string + "-")) continue;
                    parameter = parameter.substring(string.length() + 1);
                    break;
                }
            }
            context.scalar(parameter).push(new ExpressionHandler());
        }
    }

    @Override
    public void endElement(XMLStreamReader xml, SldTransformContext context) throws XMLStreamException, IOException {
        String name = xml.getLocalName();
        if ("CssParameter".equals(name) || "SvgParameter".equals(name)) {
            context.pop();
        }
    }
}

