/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld.transform.sld;

import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.geotools.ysld.transform.sld.ExpressionHandler;
import org.geotools.ysld.transform.sld.FillHandler;
import org.geotools.ysld.transform.sld.SldTransformContext;
import org.geotools.ysld.transform.sld.SldTransformHandler;
import org.geotools.ysld.transform.sld.StrokeHandler;

public class GraphicHandler
extends SldTransformHandler {
    boolean inSymbols = false;

    @Override
    public void element(XMLStreamReader xml, SldTransformContext context) throws XMLStreamException, IOException {
        String name = xml.getLocalName();
        if ("Graphic".equals(name)) {
            context.mapping();
        } else if ("Mark".equals(name) || "ExternalGraphic".equals(name)) {
            context.scalar("symbols").sequence().push(new SymbolsHandler());
        } else if ("Size".equals(name) || "Opacity".equals(name) || "Rotation".equals(name)) {
            context.scalar(name.toLowerCase()).push(new ExpressionHandler());
        }
    }

    @Override
    public void endElement(XMLStreamReader xml, SldTransformContext context) throws XMLStreamException, IOException {
        String name = xml.getLocalName();
        if ("Graphic".equals(name)) {
            context.endMapping().pop();
        }
    }

    static class ExternalHandler
    extends SldTransformHandler {
        ExternalHandler() {
        }

        @Override
        public void element(XMLStreamReader xml, SldTransformContext context) throws XMLStreamException, IOException {
            String name = xml.getLocalName();
            if ("ExternalGraphic".equals(name)) {
                context.mapping().scalar("external").mapping();
            } else if ("OnlineResource".equals(name)) {
                context.scalar("url").scalar(xml.getAttributeValue(null, "href"));
            } else if ("Format".equals(name)) {
                context.scalar("format").scalar(xml.getElementText());
            }
        }

        @Override
        public void endElement(XMLStreamReader xml, SldTransformContext context) throws XMLStreamException, IOException {
            if ("ExternalGraphic".equals(xml.getLocalName())) {
                context.endMapping().endMapping().pop();
            }
        }
    }

    static class MarkHandler
    extends SldTransformHandler {
        MarkHandler() {
        }

        @Override
        public void element(XMLStreamReader xml, SldTransformContext context) throws XMLStreamException, IOException {
            String name = xml.getLocalName();
            if ("Mark".equals(name)) {
                context.mapping().scalar("mark").mapping();
            } else if ("WellKnownName".equals(name)) {
                context.scalar("shape").push(new ExpressionHandler());
            } else if ("Stroke".equals(name)) {
                context.push(new StrokeHandler());
            } else if ("Fill".equals(name)) {
                context.push(new FillHandler());
            }
        }

        @Override
        public void endElement(XMLStreamReader xml, SldTransformContext context) throws XMLStreamException, IOException {
            if ("Mark".equals(xml.getLocalName())) {
                context.endMapping().endMapping().pop();
            }
        }
    }

    static class SymbolsHandler
    extends SldTransformHandler {
        SymbolsHandler() {
        }

        @Override
        public void element(XMLStreamReader xml, SldTransformContext context) throws XMLStreamException, IOException {
            String name = xml.getLocalName();
            if ("Mark".equals(name)) {
                context.push(new MarkHandler());
            } else if ("ExternalGraphic".equals(name)) {
                context.push(new ExternalHandler());
            } else {
                context.endSequence().pop();
            }
        }
    }
}

