/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld.parse;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.NamedLayer;
import org.geotools.styling.Rule;
import org.geotools.styling.Style;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.ysld.YamlMap;
import org.geotools.ysld.YamlObject;
import org.geotools.ysld.parse.Factory;
import org.geotools.ysld.parse.FeatureStyleParser;
import org.geotools.ysld.parse.ListZoomContext;
import org.geotools.ysld.parse.RatioZoomContext;
import org.geotools.ysld.parse.RuleParser;
import org.geotools.ysld.parse.SymbolizersParser;
import org.geotools.ysld.parse.Util;
import org.geotools.ysld.parse.YamlParseContext;
import org.geotools.ysld.parse.YamlParseHandler;
import org.geotools.ysld.parse.YsldParseHandler;
import org.geotools.ysld.parse.ZoomContext;
import org.geotools.ysld.parse.ZoomContextFinder;

public class RootParser
extends YsldParseHandler {
    StyledLayerDescriptor sld;
    Style style;
    final List<ZoomContextFinder> zCtxtFinders;

    public RootParser() {
        this(Collections.emptyList());
    }

    public RootParser(List<ZoomContextFinder> zCtxtFinders) {
        super(new Factory());
        this.zCtxtFinders = new ArrayList<ZoomContextFinder>(zCtxtFinders.size() + 1);
        this.zCtxtFinders.addAll(zCtxtFinders);
    }

    @Override
    public void handle(YamlObject<?> obj, YamlParseContext context) {
        this.sld = this.factory.style.createStyledLayerDescriptor();
        NamedLayer layer = this.factory.style.createNamedLayer();
        this.sld.layers().add(layer);
        this.style = this.factory.style.createStyle();
        layer.styles().add(this.style);
        YamlMap root = obj.map();
        if (root.has("grid")) {
            context.setDocHint("ZoomContext", this.getZoomContext(root.map("grid")));
        }
        this.style.setName(root.str("name"));
        if (root.has("title")) {
            this.style.getDescription().setTitle(root.str("title"));
        }
        if (root.has("abstract")) {
            this.style.getDescription().setAbstract(root.str("abstract"));
        }
        this.style.setName(root.str("name"));
        if (root.has("feature-styles")) {
            context.push("feature-styles", (YamlParseHandler)new FeatureStyleParser(this.style, this.factory));
        } else if (root.has("rules")) {
            context.push("rules", (YamlParseHandler)new RuleParser(this.newFeatureTypeStyle(), this.factory));
        } else if (root.has("symbolizers")) {
            context.push("symbolizers", (YamlParseHandler)new SymbolizersParser(this.newRule(), this.factory));
        } else if (root.has("point") || root.has("line") || root.has("polygon") || root.has("text") || root.has("raster")) {
            context.push(new SymbolizersParser(this.newRule(), this.factory));
        }
    }

    protected ZoomContext getZoomContext(YamlMap map) {
        ZoomContext result = null;
        if (map.has("name")) {
            result = Util.getNamedZoomContext(map.str("name"), this.zCtxtFinders);
        }
        if (result == null && map.has("scales")) {
            List raw = (List)map.seq("scales").raw();
            ArrayList<Double> scaleDenoms = new ArrayList<Double>(raw.size());
            for (Number s : raw) {
                scaleDenoms.add(s.doubleValue());
            }
            int initialLevel = map.intOr("initial-level", 0);
            result = new ListZoomContext(scaleDenoms, initialLevel);
        }
        if (result == null && map.has("initial-scale")) {
            double initialScale = map.doub("initial-scale");
            double ratio = map.doubOr("ratio", 2.0);
            int initialLevel = map.intOr("initial-level", 0);
            result = new RatioZoomContext(initialLevel, initialScale, ratio);
        }
        if (result == null) {
            throw new IllegalArgumentException();
        }
        return result;
    }

    public FeatureTypeStyle newFeatureTypeStyle() {
        FeatureTypeStyle fts = this.factory.style.createFeatureTypeStyle();
        this.style.featureTypeStyles().add(fts);
        return fts;
    }

    public Rule newRule() {
        Rule rule = this.factory.style.createRule();
        this.newFeatureTypeStyle().rules().add(rule);
        return rule;
    }

    public StyledLayerDescriptor sld() {
        return this.sld;
    }
}

