/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld.encode;

import java.util.Collections;
import java.util.Optional;
import org.geotools.styling.SLD;
import org.geotools.styling.Style;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.ysld.encode.FeatureStyleEncoder;
import org.geotools.ysld.encode.YsldEncodeHandler;

public class RootEncoder
extends YsldEncodeHandler<StyledLayerDescriptor> {
    RootEncoder(StyledLayerDescriptor sld) {
        super(Collections.singleton(sld).iterator());
    }

    @Override
    protected void encode(StyledLayerDescriptor sld) {
        Style style = SLD.defaultStyle((StyledLayerDescriptor)sld);
        if (style != null) {
            this.put("name", style.getName());
            this.put("title", (Object)Optional.ofNullable(style.getDescription().getTitle()).map(Object::toString).orElse(null));
            this.put("abstract", (Object)Optional.ofNullable(style.getDescription().getAbstract()).map(Object::toString).orElse(null));
            this.put("feature-styles", new FeatureStyleEncoder(style));
        }
    }
}

