/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.geotools.styling.UomOgcMapping;

public class UomMapper {
    private final Map<Unit<Length>, String> toId = new HashMap<Unit<Length>, String>();
    private final Map<String, Unit<Length>> toUnit = new HashMap<String, Unit<Length>>();
    public static final String KEY = "uomMapper";

    public UomMapper() {
        this.toId.put((Unit<Length>)UomOgcMapping.METRE.getUnit(), "metre");
        this.toUnit.put("metre", (Unit<Length>)UomOgcMapping.METRE.getUnit());
        this.toId.put((Unit<Length>)UomOgcMapping.FOOT.getUnit(), "foot");
        this.toUnit.put("foot", (Unit<Length>)UomOgcMapping.FOOT.getUnit());
        this.toId.put((Unit<Length>)UomOgcMapping.PIXEL.getUnit(), "pixel");
        this.toUnit.put("pixel", (Unit<Length>)UomOgcMapping.PIXEL.getUnit());
        this.toUnit.put("meter", (Unit<Length>)UomOgcMapping.METRE.getUnit());
        this.toUnit.put("m", (Unit<Length>)UomOgcMapping.METRE.getUnit());
        this.toUnit.put(UomOgcMapping.METRE.getSEString(), (Unit<Length>)UomOgcMapping.METRE.getUnit());
        this.toUnit.put("ft", (Unit<Length>)UomOgcMapping.FOOT.getUnit());
        this.toUnit.put(UomOgcMapping.FOOT.getSEString(), (Unit<Length>)UomOgcMapping.FOOT.getUnit());
        this.toUnit.put("px", (Unit<Length>)UomOgcMapping.PIXEL.getUnit());
        this.toUnit.put(UomOgcMapping.PIXEL.getSEString(), (Unit<Length>)UomOgcMapping.PIXEL.getUnit());
    }

    public Unit<Length> getUnit(String identifier) {
        Unit<Length> unit = this.toUnit.get(identifier.toLowerCase(Locale.ENGLISH));
        if (unit == null) {
            throw new IllegalArgumentException("Unknown unit identifier: " + identifier);
        }
        return unit;
    }

    public String getIdentifier(Unit<Length> unit) {
        String identifier = this.toId.get(unit);
        if (identifier == null) {
            throw new IllegalArgumentException("Unit not supported by YSLD: " + unit.toString());
        }
        return identifier;
    }
}

