/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld;

import java.awt.Color;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.geotools.util.logging.Logging;
import org.geotools.ysld.YamlObject;
import org.geotools.ysld.parse.Util;

public class Tuple {
    static Logger LOG = Logging.getLogger(Tuple.class);
    static final Map<Integer, Pattern> PATTERNS = new HashMap<Integer, Pattern>();
    Object[] values;
    Pattern pattern;

    public static Tuple of(Object ... values) {
        Tuple t = Tuple.of(values.length);
        t.values = values;
        return t;
    }

    public static Tuple of(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("n must be greater than zero");
        }
        Pattern p = PATTERNS.get(n);
        if (p == null) {
            StringBuilder sb = new StringBuilder("\\s*\\(");
            for (int i = 0; i < n; ++i) {
                sb.append("\\s*(.*)\\s*,");
            }
            sb.setLength(sb.length() - 1);
            p = Pattern.compile(sb.append("\\)\\s*").toString());
            PATTERNS.put(n, p);
        }
        return new Tuple(n, p);
    }

    Tuple(int n, Pattern pattern) {
        this.values = new String[n];
        this.pattern = pattern;
    }

    private Tuple parse(String str) throws IllegalArgumentException {
        LOG.warning("The tuple syntax " + str + " is deprecated. Please update your style to use '[' and ']' instead of '(' and ')' for tuples");
        Matcher m = this.pattern.matcher(str);
        if (!m.matches()) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < this.values.length; ++i) {
            String val = m.group(i + 1);
            if (val == null || "".equals(val)) continue;
            this.values[i] = val;
        }
        return this;
    }

    public Tuple parse(List<?> seq) throws IllegalArgumentException {
        if (seq.size() != this.values.length) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < this.values.length; ++i) {
            Object val = seq.get(i);
            if (val == null || "".equals(val)) continue;
            this.values[i] = val.toString();
        }
        return this;
    }

    public Tuple parse(Object obj) throws IllegalArgumentException {
        if (obj instanceof List) {
            return this.parse((List)obj);
        }
        if (obj instanceof String) {
            return this.parse((String)obj);
        }
        if (obj instanceof YamlObject) {
            return this.parse(((YamlObject)obj).raw());
        }
        throw new IllegalArgumentException();
    }

    public Object at(int i) {
        return this.values[i];
    }

    public String strAt(int i) {
        Object obj = this.at(i);
        return obj != null ? obj.toString() : null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("(");
        for (int i = 0; i < this.values.length; ++i) {
            Object v = this.values[i];
            if (v != null) {
                if (v instanceof Color) {
                    sb.append('\'');
                    sb.append(Util.serializeColor((Color)v));
                    sb.append('\'');
                } else {
                    sb.append(v);
                }
            }
            sb.append(",");
        }
        sb.setLength(sb.length() - 1);
        return sb.append(")").toString();
    }

    public List<?> toList() {
        return Arrays.asList(this.values);
    }

    public boolean isNull() {
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] == null) continue;
            return false;
        }
        return true;
    }
}

