/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld.parse;

import org.geotools.ysld.TestUtils;
import org.geotools.ysld.parse.RatioZoomContext;
import org.geotools.ysld.parse.ScaleRange;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class RatioZoomContextTest {
    static final double EPSILON = 1.0E-7;

    @Test
    public void testLevels() {
        RatioZoomContext ctxt = new RatioZoomContext(5000000.0, 2.0);
        Assert.assertThat((Object)ctxt.getScaleDenominator(0), (Matcher)Matchers.closeTo((double)5000000.0, (double)1.0E-7));
        Assert.assertThat((Object)ctxt.getScaleDenominator(1), (Matcher)Matchers.closeTo((double)2500000.0, (double)1.0E-7));
        Assert.assertThat((Object)ctxt.getScaleDenominator(2), (Matcher)Matchers.closeTo((double)1250000.0, (double)1.0E-7));
    }

    @Test
    public void testNonIntegerRatio() {
        RatioZoomContext ctxt = new RatioZoomContext(5000000.0, 1.5);
        Assert.assertThat((Object)ctxt.getScaleDenominator(0), (Matcher)Matchers.closeTo((double)5000000.0, (double)1.0E-7));
        Assert.assertThat((Object)ctxt.getScaleDenominator(1), (Matcher)Matchers.closeTo((double)3333333.3333333335, (double)1.0E-7));
        Assert.assertThat((Object)ctxt.getScaleDenominator(2), (Matcher)Matchers.closeTo((double)2222222.222222222, (double)1.0E-7));
    }

    @Test
    public void testNonZeroInitial() {
        RatioZoomContext ctxt = new RatioZoomContext(2, 5000000.0, 2.0);
        Assert.assertThat((Object)ctxt.getScaleDenominator(0), (Matcher)Matchers.closeTo((double)2.0E7, (double)1.0E-7));
        Assert.assertThat((Object)ctxt.getScaleDenominator(1), (Matcher)Matchers.closeTo((double)1.0E7, (double)1.0E-7));
        Assert.assertThat((Object)ctxt.getScaleDenominator(2), (Matcher)Matchers.closeTo((double)5000000.0, (double)1.0E-7));
        Assert.assertThat((Object)ctxt.getScaleDenominator(3), (Matcher)Matchers.closeTo((double)2500000.0, (double)1.0E-7));
        Assert.assertThat((Object)ctxt.getScaleDenominator(4), (Matcher)Matchers.closeTo((double)1250000.0, (double)1.0E-7));
    }

    @Test
    public void testSingletonRangeInitial() {
        RatioZoomContext ctxt = new RatioZoomContext(5000000.0, 2.0);
        ScaleRange result = ctxt.getRange(Integer.valueOf(0), Integer.valueOf(0));
        Assert.assertThat((Object)result, TestUtils.rangeContains(5000000.0));
        Assert.assertThat((Object)result, (Matcher)Matchers.not(TestUtils.rangeContains(1.0E7)));
        Assert.assertThat((Object)result, (Matcher)Matchers.not(TestUtils.rangeContains(2500000.0)));
    }

    @Test
    public void testSingletonRange() {
        RatioZoomContext ctxt = new RatioZoomContext(5000000.0, 2.0);
        ScaleRange result = ctxt.getRange(Integer.valueOf(2), Integer.valueOf(2));
        Assert.assertThat((Object)result, TestUtils.rangeContains(1250000.0));
        Assert.assertThat((Object)result, (Matcher)Matchers.not(TestUtils.rangeContains(2500000.0)));
        Assert.assertThat((Object)result, (Matcher)Matchers.not(TestUtils.rangeContains(625000.0)));
    }

    @Test
    public void testRange() {
        RatioZoomContext ctxt = new RatioZoomContext(5000000.0, 2.0);
        ScaleRange result = ctxt.getRange(Integer.valueOf(0), Integer.valueOf(2));
        Assert.assertThat((Object)result, TestUtils.rangeContains(5000000.0));
        Assert.assertThat((Object)result, TestUtils.rangeContains(2500000.0));
        Assert.assertThat((Object)result, TestUtils.rangeContains(1250000.0));
        Assert.assertThat((Object)result, (Matcher)Matchers.not(TestUtils.rangeContains(1.0E7)));
        Assert.assertThat((Object)result, (Matcher)Matchers.not(TestUtils.rangeContains(625000.0)));
    }
}

