/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld.encode;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.ColorMap;
import org.geotools.styling.ColorMapEntry;
import org.geotools.styling.ContrastEnhancement;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Graphic;
import org.geotools.styling.LinePlacement;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.NamedLayer;
import org.geotools.styling.PointPlacement;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.TextSymbolizer2;
import org.geotools.styling.UomOgcMapping;
import org.geotools.styling.UserLayer;
import org.geotools.util.logging.Logging;
import org.geotools.ysld.TestUtils;
import org.geotools.ysld.Tuple;
import org.geotools.ysld.YamlMap;
import org.geotools.ysld.YamlSeq;
import org.geotools.ysld.YamlUtil;
import org.geotools.ysld.Ysld;
import org.geotools.ysld.encode.RasterSymbolizerEncoder;
import org.geotools.ysld.parse.YsldParser;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.style.ChannelSelection;
import org.opengis.style.ContrastMethod;
import org.opengis.style.Fill;
import org.opengis.style.GraphicLegend;
import org.opengis.style.LabelPlacement;
import org.opengis.style.SelectedChannelType;
import systems.uom.common.USCustomary;

public class YsldEncodeTest {
    private static final double EPSILON = 1.0E-10;
    @Rule
    public ExpectedException exception = ExpectedException.none();
    Logger LOG = Logging.getLogger((String)"org.geotools.ysld.Ysld");

    @Test
    public void testFunction() throws Exception {
        StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory();
        FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory();
        StyledLayerDescriptor sld = styleFactory.createStyledLayerDescriptor();
        UserLayer layer = styleFactory.createUserLayer();
        sld.layers().add(layer);
        Style style = styleFactory.createStyle();
        layer.userStyles().add(style);
        org.geotools.styling.Rule rule = styleFactory.createRule();
        style.featureTypeStyles().add(styleFactory.createFeatureTypeStyle());
        ((FeatureTypeStyle)style.featureTypeStyles().get(0)).rules().add(rule);
        Function func = filterFactory.function("strEndsWith", new Expression[]{filterFactory.property("foo"), filterFactory.literal((Object)"bar")});
        rule.setFilter((Filter)filterFactory.equal((Expression)func, (Expression)filterFactory.literal(true), false));
        StringWriter out = new StringWriter();
        Ysld.encode((StyledLayerDescriptor)sld, (Object)out);
        YamlMap obj = new YamlMap(YamlUtil.getSafeYaml().load(out.toString()));
        String filter = obj.seq("feature-styles").map(0).seq("rules").map(0).str("filter");
        Assert.assertEquals((Object)"${strEndsWith(foo,'bar') = true}", (Object)filter);
    }

    @Test
    public void testRenderingTransformation() throws IOException {
        StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory();
        FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory();
        StyledLayerDescriptor sld = styleFactory.createStyledLayerDescriptor();
        UserLayer layer = styleFactory.createUserLayer();
        sld.layers().add(layer);
        Style style = styleFactory.createStyle();
        layer.userStyles().add(style);
        FeatureTypeStyle featureStyle = styleFactory.createFeatureTypeStyle();
        style.featureTypeStyles().add(featureStyle);
        Function p1 = filterFactory.function("parameter", new Expression[]{filterFactory.literal((Object)"data")});
        Function p2 = filterFactory.function("parameter", new Expression[]{filterFactory.literal((Object)"levels"), filterFactory.literal(1000), filterFactory.literal(1100), filterFactory.literal(1200)});
        Function rt = filterFactory.function("ras:Contour", new Expression[]{p1, p2});
        featureStyle.setTransformation((Expression)rt);
        StringWriter out = new StringWriter();
        Ysld.encode((StyledLayerDescriptor)sld, (Object)out);
        YamlMap obj = new YamlMap(YamlUtil.getSafeYaml().load(out.toString()));
        YamlMap tx = obj.seq("feature-styles").map(0).map("transform");
        Assert.assertThat((Object)tx, TestUtils.yHasEntry("name", TestUtils.lexEqualTo("ras:Contour")));
        Assert.assertThat((Object)tx, (org.hamcrest.Matcher)Matchers.not(TestUtils.yHasEntry("input")));
        Assert.assertThat((Object)tx, TestUtils.yHasEntry("params", (org.hamcrest.Matcher<? extends Object>)Matchers.allOf((org.hamcrest.Matcher)Matchers.not(TestUtils.yHasEntry("data")), TestUtils.yHasEntry("levels", (org.hamcrest.Matcher<? extends Object>)Matchers.allOf(TestUtils.yHasItem(0, TestUtils.lexEqualTo(1000)), TestUtils.yHasItem(1, TestUtils.lexEqualTo(1100)), TestUtils.yHasItem(2, TestUtils.lexEqualTo(1200)))))));
    }

    @Test
    public void testRenderingTransformationInput() throws IOException {
        StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory();
        FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory();
        StyledLayerDescriptor sld = styleFactory.createStyledLayerDescriptor();
        UserLayer layer = styleFactory.createUserLayer();
        sld.layers().add(layer);
        Style style = styleFactory.createStyle();
        layer.userStyles().add(style);
        FeatureTypeStyle featureStyle = styleFactory.createFeatureTypeStyle();
        style.featureTypeStyles().add(featureStyle);
        Function p1 = filterFactory.function("parameter", new Expression[]{filterFactory.literal((Object)"alternateInput")});
        Function p2 = filterFactory.function("parameter", new Expression[]{filterFactory.literal((Object)"levels"), filterFactory.literal(1000), filterFactory.literal(1100), filterFactory.literal(1200)});
        Function rt = filterFactory.function("ras:Contour", new Expression[]{p1, p2});
        featureStyle.setTransformation((Expression)rt);
        StringWriter out = new StringWriter();
        Ysld.encode((StyledLayerDescriptor)sld, (Object)out);
        YamlMap obj = new YamlMap(YamlUtil.getSafeYaml().load(out.toString()));
        YamlMap tx = obj.seq("feature-styles").map(0).map("transform");
        Assert.assertThat((Object)tx, TestUtils.yHasEntry("name", TestUtils.lexEqualTo("ras:Contour")));
        Assert.assertThat((Object)tx, TestUtils.yHasEntry("input", TestUtils.lexEqualTo("alternateInput")));
        Assert.assertThat((Object)tx, TestUtils.yHasEntry("params", (org.hamcrest.Matcher<? extends Object>)Matchers.allOf((org.hamcrest.Matcher)Matchers.not(TestUtils.yHasEntry("data")), (org.hamcrest.Matcher)Matchers.not(TestUtils.yHasEntry("alternateInput")), TestUtils.yHasEntry("levels", (org.hamcrest.Matcher<? extends Object>)Matchers.allOf(TestUtils.yHasItem(0, TestUtils.lexEqualTo(1000)), TestUtils.yHasItem(1, TestUtils.lexEqualTo(1100)), TestUtils.yHasItem(2, TestUtils.lexEqualTo(1200)))))));
    }

    @Test
    public void testRenderingTransformationHeatmap() throws IOException {
        StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory();
        FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory();
        StyledLayerDescriptor sld = styleFactory.createStyledLayerDescriptor();
        UserLayer layer = styleFactory.createUserLayer();
        sld.layers().add(layer);
        Style style = styleFactory.createStyle();
        layer.userStyles().add(style);
        FeatureTypeStyle featureStyle = styleFactory.createFeatureTypeStyle();
        style.featureTypeStyles().add(featureStyle);
        Function p1 = filterFactory.function("parameter", new Expression[]{filterFactory.literal((Object)"data")});
        Function p2 = filterFactory.function("parameter", new Expression[]{filterFactory.literal((Object)"weightAttr"), filterFactory.literal((Object)"pop2000")});
        Function p3 = filterFactory.function("parameter", new Expression[]{filterFactory.literal((Object)"radius"), filterFactory.literal((Object)"100")});
        Function p4 = filterFactory.function("parameter", new Expression[]{filterFactory.literal((Object)"pixelsPerCell"), filterFactory.literal(10)});
        Function p5 = filterFactory.function("parameter", new Expression[]{filterFactory.literal((Object)"outputBBOX"), filterFactory.function("env", new Expression[]{filterFactory.literal((Object)"wms_bbox")})});
        Function p6 = filterFactory.function("parameter", new Expression[]{filterFactory.literal((Object)"outputWidth"), filterFactory.function("env", new Expression[]{filterFactory.literal((Object)"wms_width")})});
        Function p7 = filterFactory.function("parameter", new Expression[]{filterFactory.literal((Object)"outputHeight"), filterFactory.function("env", new Expression[]{filterFactory.literal((Object)"wms_height")})});
        Function rt = filterFactory.function("vec:Heatmap", new Expression[]{p1, p2, p3, p4, p5, p6, p7});
        featureStyle.setTransformation((Expression)rt);
        org.geotools.styling.Rule rule = styleFactory.createRule();
        rule.setName("Za'Ha'Dum");
        featureStyle.rules().add(rule);
        StringWriter out = new StringWriter();
        Ysld.encode((StyledLayerDescriptor)sld, (Object)out);
        YamlMap obj = new YamlMap(YamlUtil.getSafeYaml().load(out.toString()));
        YamlMap tx = obj.seq("feature-styles").map(0).map("transform");
        Assert.assertEquals((Object)"vec:Heatmap", (Object)tx.get("name"));
        YamlMap params = tx.map("params");
        Assert.assertThat((Object)params, TestUtils.yHasEntry("weightAttr", TestUtils.lexEqualTo("pop2000")));
        Assert.assertThat((Object)params, TestUtils.yHasEntry("radius", TestUtils.lexEqualTo(100)));
        Assert.assertThat((Object)params, TestUtils.yHasEntry("pixelsPerCell", TestUtils.lexEqualTo(10)));
        Assert.assertThat((Object)params, (org.hamcrest.Matcher)Matchers.not(TestUtils.yHasEntry("outputBBOX")));
        Assert.assertThat((Object)params, (org.hamcrest.Matcher)Matchers.not(TestUtils.yHasEntry("outputWidth")));
        Assert.assertThat((Object)params, (org.hamcrest.Matcher)Matchers.not(TestUtils.yHasEntry("outputHeight")));
        YamlMap ruleMap = obj.seq("feature-styles").map(0).seq("rules").map(0);
        Assert.assertThat((Object)ruleMap.str("name"), (org.hamcrest.Matcher)Matchers.equalTo((Object)"Za'Ha'Dum"));
    }

    @Test
    public void testRenderingTransformationHeatmapAltBBOX() throws IOException {
        StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory();
        FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory();
        StyledLayerDescriptor sld = styleFactory.createStyledLayerDescriptor();
        UserLayer layer = styleFactory.createUserLayer();
        sld.layers().add(layer);
        Style style = styleFactory.createStyle();
        layer.userStyles().add(style);
        FeatureTypeStyle featureStyle = styleFactory.createFeatureTypeStyle();
        style.featureTypeStyles().add(featureStyle);
        Function p1 = filterFactory.function("parameter", new Expression[]{filterFactory.literal((Object)"data")});
        Function p2 = filterFactory.function("parameter", new Expression[]{filterFactory.literal((Object)"weightAttr"), filterFactory.literal((Object)"pop2000")});
        Function p3 = filterFactory.function("parameter", new Expression[]{filterFactory.literal((Object)"radius"), filterFactory.literal((Object)"100")});
        Function p4 = filterFactory.function("parameter", new Expression[]{filterFactory.literal((Object)"pixelsPerCell"), filterFactory.literal(10)});
        Function p5 = filterFactory.function("parameter", new Expression[]{filterFactory.literal((Object)"outputBBOX"), filterFactory.function("env", new Expression[]{filterFactory.literal((Object)"something_else")})});
        Function p6 = filterFactory.function("parameter", new Expression[]{filterFactory.literal((Object)"outputWidth"), filterFactory.function("env", new Expression[]{filterFactory.literal((Object)"wms_width")})});
        Function p7 = filterFactory.function("parameter", new Expression[]{filterFactory.literal((Object)"outputHeight"), filterFactory.function("env", new Expression[]{filterFactory.literal((Object)"wms_height")})});
        Function rt = filterFactory.function("vec:Heatmap", new Expression[]{p1, p2, p3, p4, p5, p6, p7});
        featureStyle.setTransformation((Expression)rt);
        org.geotools.styling.Rule rule = styleFactory.createRule();
        rule.setName("Za'Ha'Dum");
        featureStyle.rules().add(rule);
        StringWriter out = new StringWriter();
        Ysld.encode((StyledLayerDescriptor)sld, (Object)out);
        YamlMap obj = new YamlMap(YamlUtil.getSafeYaml().load(out.toString()));
        YamlMap tx = obj.seq("feature-styles").map(0).map("transform");
        Assert.assertEquals((Object)"vec:Heatmap", (Object)tx.get("name"));
        YamlMap params = tx.map("params");
        Assert.assertThat((Object)params, TestUtils.yHasEntry("weightAttr", TestUtils.lexEqualTo("pop2000")));
        Assert.assertThat((Object)params, TestUtils.yHasEntry("radius", TestUtils.lexEqualTo(100)));
        Assert.assertThat((Object)params, TestUtils.yHasEntry("pixelsPerCell", TestUtils.lexEqualTo(10)));
        Assert.assertThat((Object)params, TestUtils.yHasEntry("outputBBOX", (org.hamcrest.Matcher<? extends Object>)Matchers.equalTo((Object)"${env('something_else')}")));
        Assert.assertThat((Object)params, (org.hamcrest.Matcher)Matchers.not(TestUtils.yHasEntry("outputWidth")));
        Assert.assertThat((Object)params, (org.hamcrest.Matcher)Matchers.not(TestUtils.yHasEntry("outputHeight")));
        YamlMap ruleMap = obj.seq("feature-styles").map(0).seq("rules").map(0);
        Assert.assertThat((Object)ruleMap.str("name"), (org.hamcrest.Matcher)Matchers.equalTo((Object)"Za'Ha'Dum"));
    }

    @Test
    public void testRenderingTransformationSimplifyWithWMSParams() throws IOException {
        StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory();
        FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory();
        StyledLayerDescriptor sld = styleFactory.createStyledLayerDescriptor();
        UserLayer layer = styleFactory.createUserLayer();
        sld.layers().add(layer);
        Style style = styleFactory.createStyle();
        layer.userStyles().add(style);
        FeatureTypeStyle featureStyle = styleFactory.createFeatureTypeStyle();
        style.featureTypeStyles().add(featureStyle);
        Function p1 = filterFactory.function("parameter", new Expression[]{filterFactory.literal((Object)"features")});
        Function p2 = filterFactory.function("parameter", new Expression[]{filterFactory.literal((Object)"distance"), filterFactory.literal(10.0)});
        Function p3 = filterFactory.function("parameter", new Expression[]{filterFactory.literal((Object)"preserveTopology"), filterFactory.literal(true)});
        Function p5 = filterFactory.function("parameter", new Expression[]{filterFactory.literal((Object)"outputBBOX"), filterFactory.function("env", new Expression[]{filterFactory.literal((Object)"wms_bbox")})});
        Function p6 = filterFactory.function("parameter", new Expression[]{filterFactory.literal((Object)"outputWidth"), filterFactory.function("env", new Expression[]{filterFactory.literal((Object)"wms_width")})});
        Function p7 = filterFactory.function("parameter", new Expression[]{filterFactory.literal((Object)"outputHeight"), filterFactory.function("env", new Expression[]{filterFactory.literal((Object)"wms_height")})});
        Function rt = filterFactory.function("vec:Simplify", new Expression[]{p1, p2, p3, p5, p6, p7});
        featureStyle.setTransformation((Expression)rt);
        org.geotools.styling.Rule rule = styleFactory.createRule();
        rule.setName("Za'Ha'Dum");
        featureStyle.rules().add(rule);
        StringWriter out = new StringWriter();
        Ysld.encode((StyledLayerDescriptor)sld, (Object)out);
        YamlMap obj = new YamlMap(YamlUtil.getSafeYaml().load(out.toString()));
        YamlMap tx = obj.seq("feature-styles").map(0).map("transform");
        Assert.assertThat((Object)tx, TestUtils.yHasEntry("name", (org.hamcrest.Matcher<? extends Object>)Matchers.equalTo((Object)"vec:Simplify")));
        Assert.assertThat((Object)tx, TestUtils.yHasEntry("input", (org.hamcrest.Matcher<? extends Object>)Matchers.equalTo((Object)"features")));
        YamlMap params = tx.map("params");
        Assert.assertThat((Object)params, TestUtils.yHasEntry("distance", TestUtils.lexEqualTo(10.0)));
        Assert.assertThat((Object)params, TestUtils.yHasEntry("preserveTopology", TestUtils.lexEqualTo(true)));
        Assert.assertThat((Object)params, TestUtils.yHasEntry("outputBBOX", (org.hamcrest.Matcher<? extends Object>)Matchers.equalTo((Object)"${env('wms_bbox')}")));
        Assert.assertThat((Object)params, TestUtils.yHasEntry("outputWidth", (org.hamcrest.Matcher<? extends Object>)Matchers.equalTo((Object)"${env('wms_width')}")));
        Assert.assertThat((Object)params, TestUtils.yHasEntry("outputHeight", (org.hamcrest.Matcher<? extends Object>)Matchers.equalTo((Object)"${env('wms_height')}")));
        YamlMap ruleMap = obj.seq("feature-styles").map(0).seq("rules").map(0);
        Assert.assertThat((Object)ruleMap.str("name"), (org.hamcrest.Matcher)Matchers.equalTo((Object)"Za'Ha'Dum"));
    }

    @Test
    public void testRenderingTransformationNested() throws IOException {
        StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory();
        FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory();
        StyledLayerDescriptor sld = styleFactory.createStyledLayerDescriptor();
        UserLayer layer = styleFactory.createUserLayer();
        sld.layers().add(layer);
        Style style = styleFactory.createStyle();
        layer.userStyles().add(style);
        FeatureTypeStyle featureStyle = styleFactory.createFeatureTypeStyle();
        style.featureTypeStyles().add(featureStyle);
        Function p1_1 = filterFactory.function("parameter", new Expression[]{filterFactory.literal((Object)"data")});
        Function p1_2 = filterFactory.function("parameter", new Expression[]{filterFactory.literal((Object)"valueAttr"), filterFactory.literal((Object)"foo")});
        Function rt1 = filterFactory.function("vec:BarnesSurface", new Expression[]{p1_1, p1_2});
        Function p2_1 = filterFactory.function("parameter", new Expression[]{filterFactory.literal((Object)"data"), rt1});
        Function p2_2 = filterFactory.function("parameter", new Expression[]{filterFactory.literal((Object)"levels"), filterFactory.literal(1000), filterFactory.literal(1100), filterFactory.literal(1200)});
        Function rt2 = filterFactory.function("ras:Contour", new Expression[]{p2_1, p2_2});
        featureStyle.setTransformation((Expression)rt2);
        StringWriter out = new StringWriter();
        Ysld.encode((StyledLayerDescriptor)sld, (Object)out);
        YamlMap obj = new YamlMap(YamlUtil.getSafeYaml().load(out.toString()));
        YamlMap tx = obj.seq("feature-styles").map(0).map("transform");
        Assert.assertThat((Object)tx, TestUtils.yHasEntry("name", TestUtils.lexEqualTo("ras:Contour")));
        Assert.assertThat((Object)tx, (org.hamcrest.Matcher)Matchers.not(TestUtils.yHasEntry("input")));
        Assert.assertThat((Object)tx, TestUtils.yHasEntry("params", (org.hamcrest.Matcher<? extends Object>)Matchers.allOf(TestUtils.yHasEntry("data", (org.hamcrest.Matcher<? extends Object>)Matchers.allOf(TestUtils.yHasEntry("name", (org.hamcrest.Matcher<? extends Object>)Matchers.equalTo((Object)"vec:BarnesSurface")), TestUtils.yHasEntry("input", (org.hamcrest.Matcher<? extends Object>)Matchers.equalTo((Object)"data")), TestUtils.yHasEntry("params", (org.hamcrest.Matcher<? extends Object>)Matchers.allOf(TestUtils.yHasEntry("valueAttr", (org.hamcrest.Matcher<? extends Object>)Matchers.equalTo((Object)"foo")), (org.hamcrest.Matcher)Matchers.not(TestUtils.yHasEntry("data")))))), TestUtils.yHasEntry("levels", (org.hamcrest.Matcher<? extends Object>)Matchers.allOf(TestUtils.yHasItem(0, TestUtils.lexEqualTo(1000)), TestUtils.yHasItem(1, TestUtils.lexEqualTo(1100)), TestUtils.yHasItem(2, TestUtils.lexEqualTo(1200)))))));
    }

    @Test
    public void testLabelShield() throws IOException {
        StyleFactory sf = CommonFactoryFinder.getStyleFactory();
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        StyledLayerDescriptor sld = sf.createStyledLayerDescriptor();
        UserLayer layer = sf.createUserLayer();
        sld.layers().add(layer);
        Style style = sf.createStyle();
        layer.userStyles().add(style);
        FeatureTypeStyle featureStyle = sf.createFeatureTypeStyle();
        style.featureTypeStyles().add(featureStyle);
        org.geotools.styling.Rule rule = sf.createRule();
        featureStyle.rules().add(rule);
        Stroke stroke = sf.stroke((Expression)ff.literal((Object)"#555555"), null, null, null, null, null, null);
        rule.symbolizers().add(sf.lineSymbolizer("line", null, null, null, (org.opengis.style.Stroke)stroke, null));
        Mark mark = sf.mark((Expression)ff.literal((Object)"circle"), (Fill)sf.fill(null, (Expression)ff.literal((Object)"#995555"), null), null);
        ArrayList<Mark> symbols = new ArrayList<Mark>();
        symbols.add(mark);
        TextSymbolizer2 text = (TextSymbolizer2)sf.textSymbolizer(null, (Expression)ff.property("geom"), null, null, (Expression)ff.property("name"), null, null, null, null);
        text.setGraphic(sf.graphic(symbols, null, null, null, null, null));
        rule.symbolizers().add(text);
        StringWriter out = new StringWriter();
        Ysld.encode((StyledLayerDescriptor)sld, (Object)out);
        YamlMap yaml = new YamlMap(YamlUtil.getSafeYaml().load(out.toString()));
        Assert.assertThat((Object)yaml.lookupY("feature-styles/0/rules/0/symbolizers/1/text"), TestUtils.yHasEntry("label", (org.hamcrest.Matcher<? extends Object>)Matchers.equalTo((Object)"${name}")));
        Assert.assertThat((Object)yaml.lookupY("feature-styles/0/rules/0/symbolizers/1/text"), TestUtils.yHasEntry("graphic"));
        Assert.assertThat((Object)yaml.lookupY("feature-styles/0/rules/0/symbolizers/1/text/graphic/symbols/0/mark"), TestUtils.yHasEntry("shape", (org.hamcrest.Matcher<? extends Object>)Matchers.equalTo((Object)"circle")));
    }

    @Test
    public void testLabelDisplacement() throws IOException {
        StyleFactory sf = CommonFactoryFinder.getStyleFactory();
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        StyledLayerDescriptor sld = sf.createStyledLayerDescriptor();
        UserLayer layer = sf.createUserLayer();
        sld.layers().add(layer);
        Style style = sf.createStyle();
        layer.userStyles().add(style);
        FeatureTypeStyle featureStyle = sf.createFeatureTypeStyle();
        style.featureTypeStyles().add(featureStyle);
        org.geotools.styling.Rule rule = sf.createRule();
        featureStyle.rules().add(rule);
        PointPlacement place = sf.createPointPlacement(sf.createAnchorPoint((Expression)ff.literal(0.75), (Expression)ff.literal(0.25)), sf.createDisplacement((Expression)ff.literal(10), (Expression)ff.literal(15)), (Expression)ff.literal(90));
        TextSymbolizer2 text = (TextSymbolizer2)sf.textSymbolizer(null, (Expression)ff.property("geom"), null, null, (Expression)ff.property("name"), null, (LabelPlacement)place, null, null);
        rule.symbolizers().add(text);
        StringWriter out = new StringWriter();
        Ysld.encode((StyledLayerDescriptor)sld, (Object)out);
        this.LOG.fine(out.toString());
        YamlMap yaml = new YamlMap(YamlUtil.getSafeYaml().load(out.toString()));
        Assert.assertThat((Object)yaml.lookupY("feature-styles/0/rules/0/symbolizers/0/text"), TestUtils.yHasEntry("placement", (org.hamcrest.Matcher<? extends Object>)Matchers.equalTo((Object)"point")));
        Assert.assertThat((Object)yaml.lookupY("feature-styles/0/rules/0/symbolizers/0/text"), TestUtils.yHasEntry("displacement", TestUtils.yTuple(TestUtils.numEqualTo(10L), TestUtils.numEqualTo(15L))));
        Assert.assertThat((Object)yaml.lookupY("feature-styles/0/rules/0/symbolizers/0/text"), TestUtils.yHasEntry("anchor", TestUtils.yTuple(TestUtils.numEqualTo(0.75, 1.0E-10), TestUtils.numEqualTo(0.25, 1.0E-10))));
        Assert.assertThat((Object)yaml.lookupY("feature-styles/0/rules/0/symbolizers/0/text"), TestUtils.yHasEntry("rotation", (org.hamcrest.Matcher<? extends Object>)Matchers.equalTo((Object)90)));
        Assert.assertThat((Object)YsldEncodeTest.kvpLine(out.toString(), "displacement"), (org.hamcrest.Matcher)Matchers.equalTo((Object)"[10, 15]"));
    }

    @Test
    public void testLabelLinePlacement() throws IOException {
        StyleFactory sf = CommonFactoryFinder.getStyleFactory();
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        StyledLayerDescriptor sld = sf.createStyledLayerDescriptor();
        UserLayer layer = sf.createUserLayer();
        sld.layers().add(layer);
        Style style = sf.createStyle();
        layer.userStyles().add(style);
        FeatureTypeStyle featureStyle = sf.createFeatureTypeStyle();
        style.featureTypeStyles().add(featureStyle);
        org.geotools.styling.Rule rule = sf.createRule();
        featureStyle.rules().add(rule);
        LinePlacement place = sf.createLinePlacement((Expression)ff.literal(10));
        TextSymbolizer2 text = (TextSymbolizer2)sf.textSymbolizer(null, (Expression)ff.property("geom"), null, null, (Expression)ff.property("name"), null, (LabelPlacement)place, null, null);
        rule.symbolizers().add(text);
        StringWriter out = new StringWriter();
        Ysld.encode((StyledLayerDescriptor)sld, (Object)out);
        YamlMap yaml = new YamlMap(YamlUtil.getSafeYaml().load(out.toString()));
        Assert.assertThat((Object)yaml.lookupY("feature-styles/0/rules/0/symbolizers/0/text"), TestUtils.yHasEntry("placement", (org.hamcrest.Matcher<? extends Object>)Matchers.equalTo((Object)"line")));
        Assert.assertThat((Object)yaml.lookupY("feature-styles/0/rules/0/symbolizers/0/text"), TestUtils.yHasEntry("offset", (org.hamcrest.Matcher<? extends Object>)Matchers.equalTo((Object)10)));
    }

    @Test
    public void testEmptyColorMap() throws Exception {
        StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory();
        StyledLayerDescriptor sld = this.sld((Symbolizer)styleFactory.createRasterSymbolizer());
        StringWriter out = new StringWriter();
        Ysld.encode((StyledLayerDescriptor)sld, (Object)out);
        YamlMap obj = new YamlMap(YamlUtil.getSafeYaml().load(out.toString()));
        YamlMap symbMap = obj.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("raster");
        Assert.assertThat((Object)symbMap, (org.hamcrest.Matcher)Matchers.not(TestUtils.yHasEntry("color-map")));
    }

    @Test
    public void testEmptyContrastEnhancement() throws Exception {
        StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory();
        StyledLayerDescriptor sld = this.sld((Symbolizer)styleFactory.createRasterSymbolizer());
        StringWriter out = new StringWriter();
        Ysld.encode((StyledLayerDescriptor)sld, (Object)out);
        YamlMap obj = new YamlMap(YamlUtil.getSafeYaml().load(out.toString()));
        YamlMap symbMap = obj.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("raster");
        Assert.assertFalse((boolean)symbMap.has("contrast-enhancement"));
    }

    @Test
    public void testColorMap() throws Exception {
        StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory();
        FilterFactory2 filterFactory = CommonFactoryFinder.getFilterFactory2();
        RasterSymbolizer symb = styleFactory.createRasterSymbolizer();
        ColorMapEntry e1 = styleFactory.createColorMapEntry();
        e1.setColor((Expression)filterFactory.literal((Object)"#000011"));
        e1.setQuantity((Expression)filterFactory.literal(0.0));
        ColorMapEntry e2 = styleFactory.createColorMapEntry();
        e2.setColor((Expression)filterFactory.literal((Object)"#0000EE"));
        e2.setQuantity((Expression)filterFactory.literal(1.0));
        symb.getColorMap().addColorMapEntry(e1);
        symb.getColorMap().addColorMapEntry(e2);
        StyledLayerDescriptor sld = this.sld((Symbolizer)symb);
        StringWriter out = new StringWriter();
        Ysld.encode((StyledLayerDescriptor)sld, (Object)out);
        YamlMap obj = new YamlMap(YamlUtil.getSafeYaml().load(out.toString()));
        YamlMap symbMap = obj.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("raster");
        Assert.assertThat((Object)symbMap, TestUtils.yHasEntry("color-map", TestUtils.yHasEntry("entries", (org.hamcrest.Matcher<? extends Object>)Matchers.allOf(TestUtils.yHasItem(0, TestUtils.yTuple(TestUtils.fakeString("#000011"), TestUtils.lexEqualTo(""), TestUtils.numEqualTo(0.0, 1.0E-10), TestUtils.lexEqualTo(""))), TestUtils.yHasItem(1, TestUtils.yTuple(TestUtils.fakeString("#0000EE"), TestUtils.lexEqualTo(""), TestUtils.numEqualTo(1.0, 1.0E-10), TestUtils.lexEqualTo("")))))));
    }

    @Test
    public void testColorMapWithExpression() throws Exception {
        StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory();
        FilterFactory2 filterFactory = CommonFactoryFinder.getFilterFactory2();
        RasterSymbolizer symb = styleFactory.createRasterSymbolizer();
        ColorMapEntry e1 = styleFactory.createColorMapEntry();
        e1.setColor((Expression)filterFactory.literal((Object)"#000011"));
        e1.setQuantity((Expression)filterFactory.literal(0.0));
        ColorMapEntry e2 = styleFactory.createColorMapEntry();
        e2.setColor((Expression)filterFactory.literal((Object)"#0000EE"));
        e2.setQuantity((Expression)filterFactory.function("pow", new Expression[]{filterFactory.literal(1.2), filterFactory.literal(2.0)}));
        symb.getColorMap().addColorMapEntry(e1);
        symb.getColorMap().addColorMapEntry(e2);
        StyledLayerDescriptor sld = this.sld((Symbolizer)symb);
        StringWriter out = new StringWriter();
        Ysld.encode((StyledLayerDescriptor)sld, (Object)out);
        YamlMap obj = new YamlMap(YamlUtil.getSafeYaml().load(out.toString()));
        YamlMap symbMap = obj.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("raster");
        Assert.assertThat((Object)symbMap, TestUtils.yHasEntry("color-map", TestUtils.yHasEntry("entries", (org.hamcrest.Matcher<? extends Object>)Matchers.allOf(TestUtils.yHasItem(0, TestUtils.yTuple(TestUtils.fakeString("#000011"), TestUtils.lexEqualTo(""), TestUtils.numEqualTo(0.0, 1.0E-10), TestUtils.lexEqualTo(""))), TestUtils.yHasItem(1, TestUtils.yTuple(TestUtils.fakeString("#0000EE"), TestUtils.lexEqualTo(""), Matchers.equalTo((Object)"${pow(1.2,2.0)}"), TestUtils.lexEqualTo("")))))));
    }

    @Test
    public void testExpressionNil() throws Exception {
        PointSymbolizer p = CommonFactoryFinder.getStyleFactory().createPointSymbolizer();
        p.getGraphic().setSize(Expression.NIL);
        StringWriter out = new StringWriter();
        Ysld.encode((StyledLayerDescriptor)this.sld((Symbolizer)p), (Object)out);
        this.LOG.fine(out.toString());
    }

    @Test
    public void testNameExpressionLiteral() throws Exception {
        PointSymbolizer p = CommonFactoryFinder.getStyleFactory().createPointSymbolizer();
        Literal nameExpression = CommonFactoryFinder.getFilterFactory2().literal((Object)"test");
        Mark mark = CommonFactoryFinder.getStyleFactory().createMark();
        mark.setWellKnownName((Expression)nameExpression);
        p.getGraphic().graphicalSymbols().add(mark);
        StringWriter out = new StringWriter();
        Ysld.encode((StyledLayerDescriptor)this.sld((Symbolizer)p), (Object)out);
        YamlMap obj = new YamlMap(YamlUtil.getSafeYaml().load(out.toString()));
        String result = obj.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("point").seq("symbols").map(0).map("mark").str("shape");
        Assert.assertThat((Object)result, (org.hamcrest.Matcher)Matchers.equalTo((Object)"test"));
    }

    @Test
    public void testNameExpressionAttribute() throws Exception {
        PointSymbolizer p = CommonFactoryFinder.getStyleFactory().createPointSymbolizer();
        PropertyName nameExpression = CommonFactoryFinder.getFilterFactory2().property("test");
        Mark mark = CommonFactoryFinder.getStyleFactory().createMark();
        mark.setWellKnownName((Expression)nameExpression);
        p.getGraphic().graphicalSymbols().add(mark);
        StringWriter out = new StringWriter();
        Ysld.encode((StyledLayerDescriptor)this.sld((Symbolizer)p), (Object)out);
        YamlMap obj = new YamlMap(YamlUtil.getSafeYaml().load(out.toString()));
        String result = obj.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("point").seq("symbols").map(0).map("mark").str("shape");
        Assert.assertThat((Object)result, (org.hamcrest.Matcher)Matchers.equalTo((Object)"${test}"));
    }

    @Test
    public void testNonNameExpressionLiteral() throws Exception {
        PointSymbolizer p = CommonFactoryFinder.getStyleFactory().createPointSymbolizer();
        Literal expression = CommonFactoryFinder.getFilterFactory2().literal((Object)"test");
        p.setGeometry((Expression)expression);
        StringWriter out = new StringWriter();
        Ysld.encode((StyledLayerDescriptor)this.sld((Symbolizer)p), (Object)out);
        YamlMap obj = new YamlMap(YamlUtil.getSafeYaml().load(out.toString()));
        String result = obj.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("point").str("geometry");
        Assert.assertThat((Object)result, (org.hamcrest.Matcher)Matchers.equalTo((Object)"test"));
    }

    @Test
    public void testNonNameExpressionAttribute() throws Exception {
        PointSymbolizer p = CommonFactoryFinder.getStyleFactory().createPointSymbolizer();
        PropertyName expression = CommonFactoryFinder.getFilterFactory2().property("test");
        p.setGeometry((Expression)expression);
        StringWriter out = new StringWriter();
        Ysld.encode((StyledLayerDescriptor)this.sld((Symbolizer)p), (Object)out);
        YamlMap obj = new YamlMap(YamlUtil.getSafeYaml().load(out.toString()));
        String result = obj.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("point").str("geometry");
        Assert.assertThat((Object)result, (org.hamcrest.Matcher)Matchers.equalTo((Object)"${test}"));
    }

    @Test
    public void testEmbededExpression() throws Exception {
        PointSymbolizer p = CommonFactoryFinder.getStyleFactory().createPointSymbolizer();
        Function expression = CommonFactoryFinder.getFilterFactory2().function("Concatenate", new Expression[]{CommonFactoryFinder.getFilterFactory2().literal((Object)"literal0"), CommonFactoryFinder.getFilterFactory2().property("attribute1"), CommonFactoryFinder.getFilterFactory2().literal((Object)"literal2")});
        p.setGeometry((Expression)expression);
        StringWriter out = new StringWriter();
        Ysld.encode((StyledLayerDescriptor)this.sld((Symbolizer)p), (Object)out);
        YamlMap obj = new YamlMap(YamlUtil.getSafeYaml().load(out.toString()));
        String result = obj.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("point").str("geometry");
        Assert.assertThat((Object)result, (org.hamcrest.Matcher)Matchers.equalTo((Object)"literal0${attribute1}literal2"));
    }

    @Test
    public void testEmbededExpressionEscapeLiteral() throws Exception {
        PointSymbolizer p = CommonFactoryFinder.getStyleFactory().createPointSymbolizer();
        Literal expression = CommonFactoryFinder.getFilterFactory2().literal((Object)"$}\\");
        p.setGeometry((Expression)expression);
        StringWriter out = new StringWriter();
        Ysld.encode((StyledLayerDescriptor)this.sld((Symbolizer)p), (Object)out);
        YamlMap obj = new YamlMap(YamlUtil.getSafeYaml().load(out.toString()));
        String result = obj.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("point").str("geometry");
        Assert.assertThat((Object)result, (org.hamcrest.Matcher)Matchers.equalTo((Object)"\\$\\}\\\\"));
    }

    @Test
    public void testEmbededExpressionEscapeExpression() throws Exception {
        PointSymbolizer p = CommonFactoryFinder.getStyleFactory().createPointSymbolizer();
        Function expression = CommonFactoryFinder.getFilterFactory2().function("strEndsWith", new Expression[]{CommonFactoryFinder.getFilterFactory2().property("attribute1"), CommonFactoryFinder.getFilterFactory2().literal((Object)"}")});
        p.setGeometry((Expression)expression);
        StringWriter out = new StringWriter();
        Ysld.encode((StyledLayerDescriptor)this.sld((Symbolizer)p), (Object)out);
        YamlMap obj = new YamlMap(YamlUtil.getSafeYaml().load(out.toString()));
        String result = obj.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("point").str("geometry");
        Assert.assertThat((Object)result, (org.hamcrest.Matcher)Matchers.equalTo((Object)"${strEndsWith(attribute1,'\\}')}"));
    }

    @Test
    public void testFilter() throws Exception {
        FilterFactory2 filterFactory = CommonFactoryFinder.getFilterFactory2();
        StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory();
        StyledLayerDescriptor sld = styleFactory.createStyledLayerDescriptor();
        UserLayer layer = styleFactory.createUserLayer();
        sld.layers().add(layer);
        Style style = styleFactory.createStyle();
        layer.userStyles().add(style);
        org.geotools.styling.Rule rule = styleFactory.createRule();
        rule.setFilter((Filter)filterFactory.less((Expression)filterFactory.property("foo"), (Expression)filterFactory.literal(2)));
        style.featureTypeStyles().add(styleFactory.createFeatureTypeStyle());
        ((FeatureTypeStyle)style.featureTypeStyles().get(0)).rules().add(rule);
        PointSymbolizer p = styleFactory.createPointSymbolizer();
        rule.symbolizers().add(p);
        StringWriter out = new StringWriter();
        Ysld.encode((StyledLayerDescriptor)sld, (Object)out);
        YamlMap obj = new YamlMap(YamlUtil.getSafeYaml().load(out.toString()));
        YamlMap result = obj.seq("feature-styles").map(0).seq("rules").map(0);
        Assert.assertThat((Object)result, TestUtils.yHasEntry("filter", (org.hamcrest.Matcher<? extends Object>)Matchers.equalTo((Object)"${foo < 2}")));
    }

    @Test
    public void testFilterEscape() throws Exception {
        FilterFactory2 filterFactory = CommonFactoryFinder.getFilterFactory2();
        StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory();
        StyledLayerDescriptor sld = styleFactory.createStyledLayerDescriptor();
        UserLayer layer = styleFactory.createUserLayer();
        sld.layers().add(layer);
        Style style = styleFactory.createStyle();
        layer.userStyles().add(style);
        org.geotools.styling.Rule rule = styleFactory.createRule();
        rule.setFilter((Filter)filterFactory.less((Expression)filterFactory.property("foo"), (Expression)filterFactory.literal((Object)"}$")));
        style.featureTypeStyles().add(styleFactory.createFeatureTypeStyle());
        ((FeatureTypeStyle)style.featureTypeStyles().get(0)).rules().add(rule);
        PointSymbolizer p = styleFactory.createPointSymbolizer();
        rule.symbolizers().add(p);
        StringWriter out = new StringWriter();
        Ysld.encode((StyledLayerDescriptor)sld, (Object)out);
        YamlMap obj = new YamlMap(YamlUtil.getSafeYaml().load(out.toString()));
        YamlMap result = obj.seq("feature-styles").map(0).seq("rules").map(0);
        Assert.assertThat((Object)result, TestUtils.yHasEntry("filter", (org.hamcrest.Matcher<? extends Object>)Matchers.equalTo((Object)"${foo < '\\}\\$'}")));
    }

    @Test
    public void testScale() throws Exception {
        FilterFactory2 filterFactory = CommonFactoryFinder.getFilterFactory2();
        StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory();
        StyledLayerDescriptor sld = styleFactory.createStyledLayerDescriptor();
        UserLayer layer = styleFactory.createUserLayer();
        sld.layers().add(layer);
        Style style = styleFactory.createStyle();
        layer.userStyles().add(style);
        style.featureTypeStyles().add(styleFactory.createFeatureTypeStyle());
        org.geotools.styling.Rule rule = styleFactory.createRule();
        rule.setMinScaleDenominator(5000000.0);
        rule.setMaxScaleDenominator(1.0E7);
        ((FeatureTypeStyle)style.featureTypeStyles().get(0)).rules().add(rule);
        rule = styleFactory.createRule();
        rule.setMinScaleDenominator(2000000.0);
        rule.setMaxScaleDenominator(5000000.0);
        ((FeatureTypeStyle)style.featureTypeStyles().get(0)).rules().add(rule);
        StringWriter out = new StringWriter();
        Ysld.encode((StyledLayerDescriptor)sld, (Object)out);
        YamlMap obj = new YamlMap(YamlUtil.getSafeYaml().load(out.toString()));
        YamlSeq result = obj.seq("feature-styles").map(0).seq("rules");
        Assert.assertThat((Object)result, TestUtils.yHasItem(0, TestUtils.yHasEntry("scale", TestUtils.yTuple(TestUtils.numEqualTo(5000000.0, 0.1), TestUtils.numEqualTo(1.0E7, 0.1)))));
        Assert.assertThat((Object)result, TestUtils.yHasItem(1, TestUtils.yHasEntry("scale", TestUtils.yTuple(TestUtils.numEqualTo(2000000.0, 0.1), TestUtils.numEqualTo(5000000.0, 0.1)))));
    }

    @Test
    public void testScaleMinMaxKeywords() throws Exception {
        FilterFactory2 filterFactory = CommonFactoryFinder.getFilterFactory2();
        StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory();
        StyledLayerDescriptor sld = styleFactory.createStyledLayerDescriptor();
        UserLayer layer = styleFactory.createUserLayer();
        sld.layers().add(layer);
        Style style = styleFactory.createStyle();
        layer.userStyles().add(style);
        style.featureTypeStyles().add(styleFactory.createFeatureTypeStyle());
        org.geotools.styling.Rule rule = styleFactory.createRule();
        rule.setMinScaleDenominator(5000000.0);
        ((FeatureTypeStyle)style.featureTypeStyles().get(0)).rules().add(rule);
        rule = styleFactory.createRule();
        rule.setMaxScaleDenominator(5000000.0);
        ((FeatureTypeStyle)style.featureTypeStyles().get(0)).rules().add(rule);
        StringWriter out = new StringWriter();
        Ysld.encode((StyledLayerDescriptor)sld, (Object)out);
        YamlMap obj = new YamlMap(YamlUtil.getSafeYaml().load(out.toString()));
        YamlSeq result = obj.seq("feature-styles").map(0).seq("rules");
        Assert.assertThat((Object)result, TestUtils.yHasItem(0, TestUtils.yHasEntry("scale", TestUtils.yTuple(TestUtils.numEqualTo(5000000.0, 0.1), Matchers.equalTo((Object)"max")))));
        Assert.assertThat((Object)result, TestUtils.yHasItem(1, TestUtils.yHasEntry("scale", TestUtils.yTuple(Matchers.equalTo((Object)"min"), TestUtils.numEqualTo(5000000.0, 0.1)))));
    }

    @Test
    public void testGrayBandSelection() throws Exception {
        StyleFactory factory = CommonFactoryFinder.getStyleFactory();
        RasterSymbolizer r = factory.createRasterSymbolizer();
        org.geotools.styling.ChannelSelection sel = factory.channelSelection((SelectedChannelType)factory.createSelectedChannelType("foo", factory.createContrastEnhancement()));
        r.setChannelSelection((ChannelSelection)sel);
        StringWriter out = new StringWriter();
        Ysld.encode((StyledLayerDescriptor)this.sld((Symbolizer)r), (Object)out);
        YamlMap obj = new YamlMap(YamlUtil.getSafeYaml().load(out.toString()));
        YamlMap channelMap = obj.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("raster").map("channels");
        Assert.assertThat((Object)channelMap, TestUtils.yHasEntry("gray"));
        Assert.assertThat((Object)channelMap, (org.hamcrest.Matcher)Matchers.not(TestUtils.yHasEntry("red")));
        Assert.assertThat((Object)channelMap, (org.hamcrest.Matcher)Matchers.not(TestUtils.yHasEntry("green")));
        Assert.assertThat((Object)channelMap, (org.hamcrest.Matcher)Matchers.not(TestUtils.yHasEntry("blue")));
        Assert.assertThat((Object)channelMap.map("gray"), TestUtils.yHasEntry("name", (org.hamcrest.Matcher<? extends Object>)Matchers.equalTo((Object)"foo")));
        Assert.assertThat((Object)channelMap.map("gray"), (org.hamcrest.Matcher)Matchers.not(TestUtils.yHasEntry("contrast-enhancement")));
    }

    @Test
    public void testRGBBandSelection() throws Exception {
        StyleFactory factory = CommonFactoryFinder.getStyleFactory();
        RasterSymbolizer r = factory.createRasterSymbolizer();
        org.geotools.styling.ChannelSelection sel = factory.channelSelection((SelectedChannelType)factory.createSelectedChannelType("foo", factory.createContrastEnhancement()), (SelectedChannelType)factory.createSelectedChannelType("bar", factory.createContrastEnhancement()), (SelectedChannelType)factory.createSelectedChannelType("baz", factory.createContrastEnhancement()));
        r.setChannelSelection((ChannelSelection)sel);
        StringWriter out = new StringWriter();
        Ysld.encode((StyledLayerDescriptor)this.sld((Symbolizer)r), (Object)out);
        YamlMap obj = new YamlMap(YamlUtil.getSafeYaml().load(out.toString()));
        YamlMap channelMap = obj.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("raster").map("channels");
        Assert.assertThat((Object)channelMap, (org.hamcrest.Matcher)Matchers.not(TestUtils.yHasEntry("gray")));
        Assert.assertThat((Object)channelMap, TestUtils.yHasEntry("red"));
        Assert.assertThat((Object)channelMap, TestUtils.yHasEntry("green"));
        Assert.assertThat((Object)channelMap, TestUtils.yHasEntry("blue"));
        Assert.assertThat((Object)channelMap.map("red"), TestUtils.yHasEntry("name", (org.hamcrest.Matcher<? extends Object>)Matchers.equalTo((Object)"foo")));
        Assert.assertThat((Object)channelMap.map("red"), (org.hamcrest.Matcher)Matchers.not(TestUtils.yHasEntry("contrast-enhancement")));
        Assert.assertThat((Object)channelMap.map("green"), TestUtils.yHasEntry("name", (org.hamcrest.Matcher<? extends Object>)Matchers.equalTo((Object)"bar")));
        Assert.assertThat((Object)channelMap.map("green"), (org.hamcrest.Matcher)Matchers.not(TestUtils.yHasEntry("contrast-enhancement")));
        Assert.assertThat((Object)channelMap.map("blue"), TestUtils.yHasEntry("name", (org.hamcrest.Matcher<? extends Object>)Matchers.equalTo((Object)"baz")));
        Assert.assertThat((Object)channelMap.map("blue"), (org.hamcrest.Matcher)Matchers.not(TestUtils.yHasEntry("contrast-enhancement")));
        Assert.assertFalse((boolean)channelMap.has("gray"));
        Assert.assertTrue((boolean)channelMap.has("red"));
        Assert.assertTrue((boolean)channelMap.has("green"));
        Assert.assertTrue((boolean)channelMap.has("blue"));
        Assert.assertThat((Object)channelMap.map("red").str("name"), (org.hamcrest.Matcher)Matchers.equalTo((Object)"foo"));
        Assert.assertFalse((boolean)channelMap.map("red").has("contrast-enhancement"));
        Assert.assertThat((Object)channelMap.map("green").str("name"), (org.hamcrest.Matcher)Matchers.equalTo((Object)"bar"));
        Assert.assertFalse((boolean)channelMap.map("green").has("contrast-enhancement"));
        Assert.assertThat((Object)channelMap.map("blue").str("name"), (org.hamcrest.Matcher)Matchers.equalTo((Object)"baz"));
        Assert.assertFalse((boolean)channelMap.map("blue").has("contrast-enhancement"));
    }

    @Test
    public void testStrokeGraphic() throws Exception {
        StyleFactory sf = CommonFactoryFinder.getStyleFactory();
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        LineSymbolizer l = sf.createLineSymbolizer();
        Mark mark = sf.mark((Expression)ff.literal((Object)"circle"), (Fill)sf.fill(null, (Expression)ff.literal((Object)"#995555"), null), null);
        Graphic g = sf.createGraphic(null, new Mark[]{mark}, null, null, null, null);
        Stroke s = sf.createStroke(null, null);
        s.setGraphicStroke((org.opengis.style.Graphic)g);
        l.setStroke((org.opengis.style.Stroke)s);
        StringWriter out = new StringWriter();
        Ysld.encode((StyledLayerDescriptor)this.sld((Symbolizer)l), (Object)out);
        YamlMap obj = new YamlMap(YamlUtil.getSafeYaml().load(out.toString()));
        YamlMap lineMap = obj.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("line");
        Assert.assertThat((Object)lineMap, TestUtils.yHasEntry("stroke-graphic", TestUtils.yHasEntry("symbols", TestUtils.yHasItem(0, TestUtils.yHasEntry("mark", (org.hamcrest.Matcher<? extends Object>)Matchers.allOf(TestUtils.yHasEntry("shape", (org.hamcrest.Matcher<? extends Object>)Matchers.equalTo((Object)"circle")), TestUtils.yHasEntry("fill-color", (org.hamcrest.Matcher<? extends Object>)Matchers.equalTo((Object)"#995555"))))))));
    }

    @Test
    public void testStrokeGraphicFill() throws Exception {
        StyleFactory sf = CommonFactoryFinder.getStyleFactory();
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        LineSymbolizer l = sf.createLineSymbolizer();
        Mark mark = sf.mark((Expression)ff.literal((Object)"circle"), (Fill)sf.fill(null, (Expression)ff.literal((Object)"#995555"), null), null);
        Graphic g = sf.createGraphic(null, new Mark[]{mark}, null, null, null, null);
        Stroke s = sf.createStroke(null, (Expression)ff.literal(10));
        s.setGraphicFill((org.opengis.style.Graphic)g);
        l.setStroke((org.opengis.style.Stroke)s);
        StringWriter out = new StringWriter();
        Ysld.encode((StyledLayerDescriptor)this.sld((Symbolizer)l), (Object)out);
        YamlMap obj = new YamlMap(YamlUtil.getSafeYaml().load(out.toString()));
        YamlMap lineMap = obj.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("line");
        Assert.assertThat((Object)lineMap, TestUtils.yHasEntry("stroke-graphic-fill", TestUtils.yHasEntry("symbols", TestUtils.yHasItem(0, TestUtils.yHasEntry("mark", (org.hamcrest.Matcher<? extends Object>)Matchers.allOf(TestUtils.yHasEntry("shape", (org.hamcrest.Matcher<? extends Object>)Matchers.equalTo((Object)"circle")), TestUtils.yHasEntry("fill-color", (org.hamcrest.Matcher<? extends Object>)Matchers.equalTo((Object)"#995555"))))))));
    }

    @Test
    public void testGrayBandSelectionWithContrast() throws Exception {
        StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory();
        FilterFactory2 filterFactory = CommonFactoryFinder.getFilterFactory2();
        RasterSymbolizer r = styleFactory.createRasterSymbolizer();
        org.geotools.styling.ChannelSelection sel = styleFactory.channelSelection((SelectedChannelType)styleFactory.createSelectedChannelType("foo", styleFactory.createContrastEnhancement((Expression)filterFactory.literal(1.2))));
        r.setChannelSelection((ChannelSelection)sel);
        StringWriter out = new StringWriter();
        Ysld.encode((StyledLayerDescriptor)this.sld((Symbolizer)r), (Object)out);
        YamlMap obj = new YamlMap(YamlUtil.getSafeYaml().load(out.toString()));
        YamlMap channelMap = obj.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("raster").map("channels");
        Assert.assertThat((Object)channelMap, TestUtils.yHasEntry("gray"));
        Assert.assertThat((Object)channelMap, (org.hamcrest.Matcher)Matchers.not(TestUtils.yHasEntry("red")));
        Assert.assertThat((Object)channelMap, (org.hamcrest.Matcher)Matchers.not(TestUtils.yHasEntry("green")));
        Assert.assertThat((Object)channelMap, (org.hamcrest.Matcher)Matchers.not(TestUtils.yHasEntry("blue")));
        Assert.assertThat((Object)channelMap.map("gray"), TestUtils.yHasEntry("name", (org.hamcrest.Matcher<? extends Object>)Matchers.equalTo((Object)"foo")));
        Assert.assertThat((Object)channelMap.map("gray"), TestUtils.yHasEntry("contrast-enhancement", TestUtils.yHasEntry("gamma", (org.hamcrest.Matcher<? extends Object>)Matchers.equalTo((Object)1.2))));
    }

    @Test
    public void testRGBBandSelectionWithContrast() throws Exception {
        StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory();
        FilterFactory2 filterFactory = CommonFactoryFinder.getFilterFactory2();
        RasterSymbolizer r = styleFactory.createRasterSymbolizer();
        org.geotools.styling.ChannelSelection sel = styleFactory.channelSelection((SelectedChannelType)styleFactory.createSelectedChannelType("foo", styleFactory.createContrastEnhancement()), (SelectedChannelType)styleFactory.createSelectedChannelType("bar", styleFactory.createContrastEnhancement((Expression)filterFactory.literal(1.2))), (SelectedChannelType)styleFactory.createSelectedChannelType("baz", styleFactory.createContrastEnhancement()));
        ((ContrastEnhancement)sel.getRGBChannels()[2].getContrastEnhancement()).setMethod(ContrastMethod.HISTOGRAM);
        r.setChannelSelection((ChannelSelection)sel);
        StringWriter out = new StringWriter();
        Ysld.encode((StyledLayerDescriptor)this.sld((Symbolizer)r), (Object)out);
        YamlMap obj = new YamlMap(YamlUtil.getSafeYaml().load(out.toString()));
        YamlMap channelMap = obj.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("raster").map("channels");
        Assert.assertThat((Object)channelMap, (org.hamcrest.Matcher)Matchers.not(TestUtils.yHasEntry("gray")));
        Assert.assertThat((Object)channelMap, TestUtils.yHasEntry("red"));
        Assert.assertThat((Object)channelMap, TestUtils.yHasEntry("green"));
        Assert.assertThat((Object)channelMap, TestUtils.yHasEntry("blue"));
        Assert.assertThat((Object)channelMap.map("red"), TestUtils.yHasEntry("name", (org.hamcrest.Matcher<? extends Object>)Matchers.equalTo((Object)"foo")));
        Assert.assertThat((Object)channelMap.map("red"), (org.hamcrest.Matcher)Matchers.not(TestUtils.yHasEntry("contrast-enhancement")));
        Assert.assertThat((Object)channelMap.map("green"), TestUtils.yHasEntry("name", (org.hamcrest.Matcher<? extends Object>)Matchers.equalTo((Object)"bar")));
        Assert.assertThat((Object)channelMap.map("green"), TestUtils.yHasEntry("contrast-enhancement", TestUtils.yHasEntry("gamma", (org.hamcrest.Matcher<? extends Object>)Matchers.equalTo((Object)1.2))));
        Assert.assertThat((Object)channelMap.map("blue"), TestUtils.yHasEntry("name", (org.hamcrest.Matcher<? extends Object>)Matchers.equalTo((Object)"baz")));
        Assert.assertThat((Object)channelMap.map("blue"), TestUtils.yHasEntry("contrast-enhancement", TestUtils.yHasEntry("mode", (org.hamcrest.Matcher<? extends Object>)Matchers.equalTo((Object)"histogram"))));
    }

    StyledLayerDescriptor sld(Symbolizer sym) {
        return this.sld(this.fts(sym));
    }

    private FeatureTypeStyle fts(Symbolizer sym) {
        StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory();
        org.geotools.styling.Rule rule = styleFactory.createRule();
        FeatureTypeStyle fts = styleFactory.createFeatureTypeStyle();
        fts.rules().add(rule);
        rule.symbolizers().add(sym);
        return fts;
    }

    private StyledLayerDescriptor sld(FeatureTypeStyle fts) {
        StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory();
        StyledLayerDescriptor sld = styleFactory.createStyledLayerDescriptor();
        UserLayer layer = styleFactory.createUserLayer();
        sld.layers().add(layer);
        Style style = styleFactory.createStyle();
        layer.userStyles().add(style);
        style.featureTypeStyles().add(fts);
        return sld;
    }

    @Test
    public void testTextSymbolizerPriority() throws Exception {
        StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory();
        FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory();
        TextSymbolizer symb = styleFactory.createTextSymbolizer();
        symb.setPriority((Expression)filterFactory.property("foo"));
        StringWriter out = new StringWriter();
        Ysld.encode((StyledLayerDescriptor)this.sld((Symbolizer)symb), (Object)out);
        YamlMap obj = new YamlMap(YamlUtil.getSafeYaml().load(out.toString()));
        YamlMap text = obj.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("text");
        Assert.assertEquals((Object)"${foo}", (Object)text.str("priority"));
    }

    public static String kvpLine(String text, String key) {
        Pattern p = Pattern.compile("^\\s*" + key + ":\\s*(.*?)\\s*$");
        for (String line : text.split("\\r?\\n")) {
            Matcher m = p.matcher(line);
            if (!m.matches()) continue;
            return m.group(1);
        }
        return null;
    }

    @Test
    public void testColourNoQuotes() throws Exception {
        PointSymbolizer p = CommonFactoryFinder.getStyleFactory().createPointSymbolizer();
        Mark m1 = CommonFactoryFinder.getStyleFactory().getCircleMark();
        m1.setFill((Fill)CommonFactoryFinder.getStyleFactory().createFill((Expression)CommonFactoryFinder.getFilterFactory2().literal((Object)"#112233")));
        m1.setStroke((org.opengis.style.Stroke)CommonFactoryFinder.getStyleFactory().createStroke((Expression)CommonFactoryFinder.getFilterFactory2().literal((Object)"#005566"), (Expression)CommonFactoryFinder.getFilterFactory2().literal(3)));
        p.getGraphic().graphicalSymbols().add(m1);
        StringWriter out = new StringWriter();
        Ysld.encode((StyledLayerDescriptor)this.sld((Symbolizer)p), (Object)out);
        this.LOG.fine(out.toString());
        YamlMap obj = new YamlMap(YamlUtil.getSafeYaml().load(out.toString()));
        YamlMap result = obj.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("point").seq("symbols").map(0).map("mark");
        Assert.assertThat((Object)result, TestUtils.yHasEntry("fill-color", TestUtils.isColor("112233")));
        Assert.assertThat((Object)result, TestUtils.yHasEntry("stroke-color", TestUtils.isColor("005566")));
        Assert.assertThat((Object)YsldEncodeTest.kvpLine(out.toString(), "fill-color"), (org.hamcrest.Matcher)Matchers.equalTo((Object)"'#112233'"));
        Assert.assertThat((Object)YsldEncodeTest.kvpLine(out.toString(), "stroke-color"), (org.hamcrest.Matcher)Matchers.equalTo((Object)"'#005566'"));
    }

    @Test
    public void testScientificNotationCase() throws Exception {
        PointSymbolizer p = CommonFactoryFinder.getStyleFactory().createPointSymbolizer();
        Mark m1 = CommonFactoryFinder.getStyleFactory().getCircleMark();
        m1.setFill((Fill)CommonFactoryFinder.getStyleFactory().createFill((Expression)CommonFactoryFinder.getFilterFactory2().literal((Object)"#112233"), (Expression)CommonFactoryFinder.getFilterFactory2().literal(Double.MIN_NORMAL)));
        p.getGraphic().graphicalSymbols().add(m1);
        StringWriter out = new StringWriter();
        Ysld.encode((StyledLayerDescriptor)this.sld((Symbolizer)p), (Object)out);
        this.LOG.fine(out.toString());
        YamlMap obj = new YamlMap(YamlUtil.getSafeYaml().load(out.toString()));
        YamlMap result = obj.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("point").seq("symbols").map(0).map("mark");
        Assert.assertThat((Object)YsldEncodeTest.kvpLine(out.toString(), "fill-opacity"), (org.hamcrest.Matcher)Matchers.equalTo((Object)Double.toString(Double.MIN_NORMAL).toUpperCase()));
    }

    @Test
    public void testColourCase() throws Exception {
        PointSymbolizer p = CommonFactoryFinder.getStyleFactory().createPointSymbolizer();
        Mark m1 = CommonFactoryFinder.getStyleFactory().getCircleMark();
        m1.setFill((Fill)CommonFactoryFinder.getStyleFactory().createFill((Expression)CommonFactoryFinder.getFilterFactory2().literal((Object)"#abcdef"), (Expression)CommonFactoryFinder.getFilterFactory2().literal(Double.MIN_NORMAL)));
        p.getGraphic().graphicalSymbols().add(m1);
        StringWriter out = new StringWriter();
        Ysld.encode((StyledLayerDescriptor)this.sld((Symbolizer)p), (Object)out);
        this.LOG.fine(out.toString());
        YamlMap obj = new YamlMap(YamlUtil.getSafeYaml().load(out.toString()));
        YamlMap result = obj.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("point").seq("symbols").map(0).map("mark");
        Assert.assertThat((Object)YsldEncodeTest.kvpLine(out.toString(), "fill-color"), (org.hamcrest.Matcher)Matchers.equalTo((Object)"'#ABCDEF'"));
    }

    @Test
    public void testColourLiteral() throws Exception {
        PointSymbolizer p = CommonFactoryFinder.getStyleFactory().createPointSymbolizer();
        Mark m1 = CommonFactoryFinder.getStyleFactory().getCircleMark();
        m1.setFill((Fill)CommonFactoryFinder.getStyleFactory().createFill((Expression)CommonFactoryFinder.getFilterFactory2().literal((Object)Color.RED), (Expression)CommonFactoryFinder.getFilterFactory2().literal(Double.MIN_NORMAL)));
        p.getGraphic().graphicalSymbols().add(m1);
        StringWriter out = new StringWriter();
        Ysld.encode((StyledLayerDescriptor)this.sld((Symbolizer)p), (Object)out);
        this.LOG.fine(out.toString());
        YamlMap obj = new YamlMap(YamlUtil.getSafeYaml().load(out.toString()));
        YamlMap result = obj.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("point").seq("symbols").map(0).map("mark");
        Assert.assertThat((Object)YsldEncodeTest.kvpLine(out.toString(), "fill-color"), (org.hamcrest.Matcher)Matchers.equalTo((Object)"'#FF0000'"));
    }

    @Test
    public void testFTSVendorOption() throws Exception {
        PointSymbolizer p = CommonFactoryFinder.getStyleFactory().createPointSymbolizer();
        FeatureTypeStyle fts = this.fts((Symbolizer)p);
        fts.getOptions().put("foo", "bar");
        StringWriter out = new StringWriter();
        Ysld.encode((StyledLayerDescriptor)this.sld(fts), (Object)out);
        this.LOG.fine(out.toString());
        YamlMap obj = new YamlMap(YamlUtil.getSafeYaml().load(out.toString()));
        YamlMap result = obj.seq("feature-styles").map(0);
        Assert.assertThat((Object)result.str("x-foo"), (org.hamcrest.Matcher)Matchers.equalTo((Object)"bar"));
    }

    @Test
    public void testSymbolizerVendorOption() throws Exception {
        PointSymbolizer p = CommonFactoryFinder.getStyleFactory().createPointSymbolizer();
        FeatureTypeStyle fts = this.fts((Symbolizer)p);
        p.getOptions().put("foo", "bar");
        StringWriter out = new StringWriter();
        Ysld.encode((StyledLayerDescriptor)this.sld(fts), (Object)out);
        this.LOG.fine(out.toString());
        YamlMap obj = new YamlMap(YamlUtil.getSafeYaml().load(out.toString()));
        YamlMap result = obj.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("point");
        Assert.assertThat((Object)result.str("x-foo"), (org.hamcrest.Matcher)Matchers.equalTo((Object)"bar"));
    }

    @Test
    public void testSymbolizerUoMMetre() throws Exception {
        PointSymbolizer p = CommonFactoryFinder.getStyleFactory().createPointSymbolizer();
        FeatureTypeStyle fts = this.fts((Symbolizer)p);
        p.setUnitOfMeasure(UomOgcMapping.METRE.getUnit());
        StringWriter out = new StringWriter();
        Ysld.encode((StyledLayerDescriptor)this.sld(fts), (Object)out);
        this.LOG.fine(out.toString());
        YamlMap obj = new YamlMap(YamlUtil.getSafeYaml().load(out.toString()));
        YamlMap result = obj.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("point");
        Assert.assertThat((Object)result.str("uom"), (org.hamcrest.Matcher)Matchers.equalTo((Object)"metre"));
    }

    @Test
    public void testSymbolizerUoMFoot() throws Exception {
        PointSymbolizer p = CommonFactoryFinder.getStyleFactory().createPointSymbolizer();
        FeatureTypeStyle fts = this.fts((Symbolizer)p);
        p.setUnitOfMeasure(UomOgcMapping.FOOT.getUnit());
        StringWriter out = new StringWriter();
        Ysld.encode((StyledLayerDescriptor)this.sld(fts), (Object)out);
        this.LOG.fine(out.toString());
        YamlMap obj = new YamlMap(YamlUtil.getSafeYaml().load(out.toString()));
        YamlMap result = obj.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("point");
        Assert.assertThat((Object)result.str("uom"), (org.hamcrest.Matcher)Matchers.equalTo((Object)"foot"));
    }

    @Test
    public void testSymbolizerUoMPixel() throws Exception {
        PointSymbolizer p = CommonFactoryFinder.getStyleFactory().createPointSymbolizer();
        FeatureTypeStyle fts = this.fts((Symbolizer)p);
        p.setUnitOfMeasure(UomOgcMapping.PIXEL.getUnit());
        StringWriter out = new StringWriter();
        Ysld.encode((StyledLayerDescriptor)this.sld(fts), (Object)out);
        this.LOG.fine(out.toString());
        YamlMap obj = new YamlMap(YamlUtil.getSafeYaml().load(out.toString()));
        YamlMap result = obj.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("point");
        Assert.assertThat((Object)result.str("uom"), (org.hamcrest.Matcher)Matchers.equalTo((Object)"pixel"));
    }

    @Test
    public void testSymbolizerUoMOther() throws Exception {
        PointSymbolizer p = CommonFactoryFinder.getStyleFactory().createPointSymbolizer();
        FeatureTypeStyle fts = this.fts((Symbolizer)p);
        p.setUnitOfMeasure(USCustomary.LIGHT_YEAR);
        StringWriter out = new StringWriter();
        this.exception.expect(IllegalArgumentException.class);
        Ysld.encode((StyledLayerDescriptor)this.sld(fts), (Object)out);
    }

    @Test
    public void testLegend() throws Exception {
        StyleFactory sf = CommonFactoryFinder.getStyleFactory();
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        PointSymbolizer p = sf.createPointSymbolizer();
        Mark mark = sf.mark((Expression)ff.literal((Object)"circle"), (Fill)sf.fill(null, (Expression)ff.literal((Object)"#FF0000"), null), null);
        p.setGraphic((org.opengis.style.Graphic)sf.createGraphic(null, new Mark[]{mark}, null, null, null, null));
        org.geotools.styling.Rule rule = sf.createRule();
        rule.symbolizers().add(p);
        ExternalGraphic eg = sf.createExternalGraphic("smileyface.png", "image/png");
        rule.setLegend((GraphicLegend)sf.createGraphic(new ExternalGraphic[]{eg}, null, null, null, null, null));
        StringWriter out = new StringWriter();
        Ysld.encode((StyledLayerDescriptor)this.sld(sf.createFeatureTypeStyle(new org.geotools.styling.Rule[]{rule})), (Object)out);
        YamlMap obj = new YamlMap(YamlUtil.getSafeYaml().load(out.toString()));
        YamlMap result = obj.seq("feature-styles").map(0).seq("rules").map(0).map("legend").seq("symbols").map(0).map("external");
        Assert.assertEquals((Object)"smileyface.png", (Object)result.str("url"));
        Assert.assertEquals((Object)"image/png", (Object)result.str("format"));
    }

    @Test
    public void testEncodeColorMapEntry() throws IOException {
        StyledLayerDescriptor style = new YsldParser((InputStream)new ByteArrayInputStream("name:  Test\ntitle: Test Style title\nabstract: Styling of Test layer\nfeature-styles:\n- rules:\n  - title: raster\n    symbolizers:\n      - raster:\n          opacity: 1.0\n          color-map:\n            type: values\n            entries:\n            - ['#e20374', 1.0, 1, Lorem Ipsum (magenta = covered)]".getBytes())).parse();
        RasterSymbolizer symbolizer = (RasterSymbolizer)((org.geotools.styling.Rule)((FeatureTypeStyle)((Style)((NamedLayer)style.getStyledLayers()[0]).styles().get(0)).featureTypeStyles().get(0)).rules().get(0)).symbolizers().get(0);
        ColorMap colorMap = symbolizer.getColorMap();
        RasterSymbolizerEncoder.ColorMapEntryIterator iterator = new RasterSymbolizerEncoder.ColorMapEntryIterator(new RasterSymbolizerEncoder(symbolizer), colorMap);
        Tuple map = iterator.next();
        Assert.assertEquals((Object)"('#E20374',1.0,1,Lorem Ipsum (magenta = covered))", (Object)map.toString());
    }
}

