/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld.validate;

import java.awt.Color;
import org.geotools.ysld.parse.Util;
import org.geotools.ysld.validate.ScalarValidator;
import org.geotools.ysld.validate.YsldValidateContext;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.yaml.snakeyaml.events.ScalarEvent;

public class ColorValidator
extends ScalarValidator {
    @Override
    protected String validate(String value, ScalarEvent evt, YsldValidateContext context) {
        try {
            Color col;
            Expression expr = Util.color(value, context.factory);
            if (expr instanceof Literal && (col = (Color)expr.evaluate(null, Color.class)) == null) {
                return "Invalid color, must be one of: '#RRGGBB', rgb(r,g,b), or expression";
            }
            return null;
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }
}

