/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld.transform.sld;

import java.io.IOException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.filter.v1_1.OGCConfiguration;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.impl.ParserHandler;
import org.geotools.ysld.transform.sld.SldTransformContext;
import org.geotools.ysld.transform.sld.SldTransformHandler;
import org.opengis.filter.Filter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class FilterHandler
extends SldTransformHandler {
    ParserHandler delegate;

    @Override
    public void element(XMLStreamReader xml, SldTransformContext context) throws XMLStreamException, IOException {
        try {
            if (this.delegate == null && "Filter".equals(xml.getLocalName())) {
                this.delegate = new ParserHandler(this.config(context));
                this.delegate.startDocument();
            }
            if (this.delegate != null) {
                this.delegate.startElement(xml.getNamespaceURI(), xml.getLocalName(), this.qname(xml.getName()), this.attributes(xml));
            }
        }
        catch (SAXException e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public void characters(XMLStreamReader xml, SldTransformContext context) throws XMLStreamException, IOException {
        if (this.delegate != null) {
            try {
                this.delegate.characters(xml.getTextCharacters(), xml.getTextStart(), xml.getTextLength());
            }
            catch (SAXException e) {
                throw new XMLStreamException(e);
            }
        }
    }

    @Override
    public void endElement(XMLStreamReader xml, SldTransformContext context) throws XMLStreamException, IOException {
        if (this.delegate != null) {
            try {
                this.delegate.endElement(xml.getNamespaceURI(), xml.getLocalName(), this.qname(xml.getName()));
            }
            catch (SAXException e) {
                throw new XMLStreamException(e);
            }
        }
        if ("Filter".equals(xml.getLocalName())) {
            Filter filter = (Filter)this.delegate.getValue();
            context.scalar(ECQL.toCQL((Filter)filter)).pop();
            this.delegate = null;
        }
    }

    String qname(QName name) {
        return name.getPrefix() != null && !"".equals(name.getPrefix()) ? name.getPrefix() + ":" + name.getLocalPart() : name.getLocalPart();
    }

    Attributes attributes(XMLStreamReader xml) {
        AttributesImpl atts = new AttributesImpl();
        for (int i = 0; i < xml.getAttributeCount(); ++i) {
            atts.addAttribute(xml.getAttributeNamespace(i), xml.getAttributeLocalName(i), this.qname(xml.getAttributeName(i)), xml.getAttributeType(i), xml.getAttributeValue(i));
        }
        return atts;
    }

    Configuration config(SldTransformContext context) {
        if (context.version().equals((Object)SldTransformContext.V_110)) {
            return new OGCConfiguration();
        }
        return new org.geotools.filter.v1_0.OGCConfiguration();
    }
}

