/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld.parse;

import org.geotools.styling.Rule;
import org.geotools.ysld.YamlMap;
import org.geotools.ysld.YamlObject;
import org.geotools.ysld.YamlSeq;
import org.geotools.ysld.parse.Factory;
import org.geotools.ysld.parse.LineParser;
import org.geotools.ysld.parse.PointParser;
import org.geotools.ysld.parse.PolygonParser;
import org.geotools.ysld.parse.RasterParser;
import org.geotools.ysld.parse.TextParser;
import org.geotools.ysld.parse.YamlParseContext;
import org.geotools.ysld.parse.YsldParseHandler;

public class SymbolizersParser
extends YsldParseHandler {
    Rule rule;

    public SymbolizersParser(Rule rule, Factory factory) {
        super(factory);
        this.rule = rule;
    }

    @Override
    public void handle(YamlObject<?> obj, YamlParseContext context) {
        YamlSeq seq = obj instanceof YamlMap ? YamlSeq.from(obj) : obj.seq();
        for (YamlObject<Object> o : seq) {
            YamlMap sym = o.map();
            if (sym.has("point")) {
                context.push(sym, "point", new PointParser(this.rule, this.factory));
                continue;
            }
            if (sym.has("line")) {
                context.push(sym, "line", new LineParser(this.rule, this.factory));
                continue;
            }
            if (sym.has("polygon")) {
                context.push(sym, "polygon", new PolygonParser(this.rule, this.factory));
                continue;
            }
            if (sym.has("text")) {
                context.push(sym, "text", new TextParser(this.rule, this.factory));
                continue;
            }
            if (!sym.has("raster")) continue;
            context.push(sym, "raster", new RasterParser(this.rule, this.factory));
        }
    }
}

