/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld.parse;

import org.geotools.styling.Fill;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.ysld.YamlMap;
import org.geotools.ysld.YamlObject;
import org.geotools.ysld.parse.Factory;
import org.geotools.ysld.parse.FillParser;
import org.geotools.ysld.parse.StrokeParser;
import org.geotools.ysld.parse.SymbolizerParser;
import org.geotools.ysld.parse.Util;
import org.geotools.ysld.parse.YamlParseContext;
import org.opengis.style.Displacement;
import org.opengis.style.Stroke;

public class PolygonParser
extends SymbolizerParser<PolygonSymbolizer> {
    public PolygonParser(Rule rule, Factory factory) {
        super(rule, factory.style.createPolygonSymbolizer(), factory);
    }

    @Override
    public void handle(YamlObject<?> obj, YamlParseContext context) {
        super.handle(obj, context);
        YamlMap map = obj.map();
        context.push(new StrokeParser(this.factory){

            @Override
            protected void stroke(org.geotools.styling.Stroke stroke) {
                ((PolygonSymbolizer)PolygonParser.this.sym).setStroke((Stroke)stroke);
            }
        });
        context.push(new FillParser(this.factory){

            @Override
            protected void fill(Fill fill) {
                ((PolygonSymbolizer)PolygonParser.this.sym).setFill((org.opengis.style.Fill)fill);
            }
        });
        if (map.has("offset")) {
            ((PolygonSymbolizer)this.sym).setPerpendicularOffset(Util.expression(map.str("offset"), this.factory));
        }
        if (map.has("displacement")) {
            ((PolygonSymbolizer)this.sym).setDisplacement((Displacement)Util.displacement(map.str("displacement"), this.factory));
        }
    }
}

