/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld.parse;

import org.geotools.styling.Fill;
import org.geotools.styling.Mark;
import org.geotools.ysld.YamlMap;
import org.geotools.ysld.YamlObject;
import org.geotools.ysld.parse.Factory;
import org.geotools.ysld.parse.FillParser;
import org.geotools.ysld.parse.StrokeParser;
import org.geotools.ysld.parse.Util;
import org.geotools.ysld.parse.YamlParseContext;
import org.geotools.ysld.parse.YsldParseHandler;
import org.opengis.style.Stroke;

public abstract class MarkParser
extends YsldParseHandler {
    Mark mark;

    protected MarkParser(Factory factory) {
        super(factory);
        this.mark = factory.style.createMark();
        this.mark.setStroke(null);
        this.mark.setFill(null);
    }

    @Override
    public void handle(YamlObject<?> obj, YamlParseContext context) {
        this.mark(this.mark);
        YamlMap map = obj.map();
        if (map.has("shape")) {
            this.mark.setWellKnownName(Util.expression(map.str("shape"), this.factory));
        }
        context.push(new StrokeParser(this.factory){

            @Override
            protected void stroke(org.geotools.styling.Stroke stroke) {
                MarkParser.this.mark.setStroke((Stroke)stroke);
            }
        });
        context.push(new FillParser(this.factory){

            @Override
            protected void fill(Fill fill) {
                MarkParser.this.mark.setFill((org.opengis.style.Fill)fill);
            }
        });
    }

    protected abstract void mark(Mark var1);
}

