/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld.encode;

import java.awt.Color;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.ysld.Tuple;
import org.geotools.ysld.Ysld;
import org.geotools.ysld.parse.Util;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;

public abstract class YsldEncodeHandler<T>
implements Iterator<Object> {
    Deque<Map<String, Object>> stack = new ArrayDeque<Map<String, Object>>();
    Iterator<T> it;
    static final Pattern COLOR_PATTERN = Pattern.compile("^#?([a-fA-F0-9]{6})$");
    static final Pattern EMBEDED_EXPRESSION_TO_ESCAPE = Pattern.compile("[$}\\\\]");

    public YsldEncodeHandler() {
        this.reset();
    }

    YsldEncodeHandler(Iterator<T> it) {
        this.it = it;
    }

    YsldEncodeHandler(T obj) {
        this.it = obj != null ? Collections.singleton(obj).iterator() : Collections.emptyIterator();
    }

    @Override
    public boolean hasNext() {
        return this.it.hasNext();
    }

    @Override
    public Object next() {
        this.reset();
        this.encode(this.it.next());
        return this.root();
    }

    protected abstract void encode(T var1);

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    YsldEncodeHandler<T> reset() {
        this.stack.clear();
        this.stack.push(this.newMap());
        return this;
    }

    YsldEncodeHandler<T> push(String key) {
        Map<String, Object> map = this.newMap();
        this.stack.peek().put(key, map);
        this.stack.push(map);
        return this;
    }

    YsldEncodeHandler<T> pop() {
        this.stack.pop();
        return this;
    }

    YsldEncodeHandler<T> put(String key, Object val) {
        if (val != null) {
            Map<String, Object> peek = this.stack.peek();
            peek.put(key, val);
        }
        return this;
    }

    YsldEncodeHandler<T> putName(String key, Expression expr) {
        if (expr != null && expr != Expression.NIL) {
            this.put(key, this.toObjOrNull(expr, true));
        }
        return this;
    }

    YsldEncodeHandler<T> put(String key, Expression expr) {
        if (expr != null && expr != Expression.NIL) {
            this.put(key, this.toObjOrNull(expr, false));
        }
        return this;
    }

    YsldEncodeHandler<T> put(String key, Expression e1, Expression e2) {
        Tuple t = Tuple.of(this.toObjOrNull(e1, false), this.toObjOrNull(e2, false));
        if (!t.isNull()) {
            this.put(key, t);
        }
        return this;
    }

    YsldEncodeHandler<T> putColor(String key, Expression expr) {
        boolean special = false;
        if (expr instanceof Literal) {
            String str = ECQL.toCQL((Expression)expr);
            if ((str = Util.stripQuotes(str)) != null && str.startsWith("#")) {
                str = str.substring(1);
                this.put(key, this.makeColorIfPossible(str));
                special = true;
            }
        }
        if (!special) {
            this.put(key, expr);
        }
        return this;
    }

    YsldEncodeHandler<T> inline(YsldEncodeHandler<?> e) {
        if (e.hasNext()) {
            e.next();
            this.inline(e.root());
        }
        return this;
    }

    YsldEncodeHandler<T> inline(Map<String, Object> values) {
        this.stack.peek().putAll(values);
        return this;
    }

    Object toColorOrNull(Expression expr) {
        Object obj;
        if (expr instanceof Literal && (obj = ((Literal)expr).getValue()) instanceof Color) {
            return obj;
        }
        obj = this.toObjOrNull(expr, false);
        if (obj instanceof String && expr instanceof Literal) {
            String str = Util.stripQuotes(obj.toString());
            obj = this.makeColorIfPossible(str);
        }
        return obj;
    }

    Object toObjOrNull(Expression expr) {
        return this.toObjOrNull(expr, false);
    }

    Object makeColorIfPossible(String str) {
        Matcher m = COLOR_PATTERN.matcher(str);
        if (m.matches()) {
            int i = Integer.parseInt(m.group(1), 16);
            return new Color(i);
        }
        return str;
    }

    String escapeForEmbededCQL(String s) {
        return EMBEDED_EXPRESSION_TO_ESCAPE.matcher(s).replaceAll("\\\\$0");
    }

    Object toObjOrNull(Expression expr, boolean isname) {
        if (this.isNull(expr)) {
            return null;
        }
        List<Expression> subExpressions = Util.splitConcatenates(expr);
        StringBuilder builder = new StringBuilder();
        for (Expression subExpr : subExpressions) {
            if (this.isNull(subExpr)) continue;
            if (subExpr instanceof Literal) {
                builder.append(this.escapeForEmbededCQL(((Literal)subExpr).getValue().toString()));
                continue;
            }
            builder.append("${").append(this.escapeForEmbededCQL(ECQL.toCQL((Expression)subExpr))).append("}");
        }
        Object result = Util.makeNumberIfPossible(builder.toString());
        return result;
    }

    Object toObjOrNull(String text) {
        block5: {
            String str;
            String string = str = text == null ? null : Util.stripQuotes(text);
            if (str != null) {
                try {
                    return Long.parseLong(str);
                }
                catch (NumberFormatException e1) {
                    try {
                        return Double.parseDouble(str);
                    }
                    catch (NumberFormatException e2) {
                        if (!"true".equalsIgnoreCase(str) && !"false".equalsIgnoreCase(str)) break block5;
                        return Boolean.parseBoolean(str);
                    }
                }
            }
        }
        return text;
    }

    Expression nullIf(Expression expr, double value) {
        return this.nullIf(expr, value, Double.class);
    }

    Expression nullIf(Expression expr, String value) {
        return this.nullIf(expr, value, String.class);
    }

    <T> Expression nullIf(Expression expr, T value, Class<T> clazz) {
        Object t;
        if (expr instanceof Literal && (t = expr.evaluate(null, clazz)) != null && t.equals(value)) {
            return null;
        }
        return expr;
    }

    Map<String, Object> get() {
        return this.stack.peek();
    }

    Map<String, Object> root() {
        return this.stack.getLast();
    }

    Map<String, Object> newMap() {
        return new LinkedHashMap<String, Object>();
    }

    boolean isNull(Expression expr) {
        return expr == null || expr == Expression.NIL;
    }

    protected void vendorOptions(Map<String, String> options) {
        if (!options.isEmpty()) {
            for (Map.Entry<String, String> kv : options.entrySet()) {
                String option = Ysld.OPTION_PREFIX + kv.getKey();
                String text = kv.getValue();
                this.put(option, this.toObjOrNull(text));
            }
        }
    }
}

