/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld.transform.sld;

import java.io.StringWriter;
import java.io.Writer;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.geotools.ysld.YamlMap;
import org.geotools.ysld.YamlUtil;
import org.geotools.ysld.Ysld;
import org.geotools.ysld.YsldTests;
import org.geotools.ysld.transform.sld.SldTransformer;
import org.geotools.ysld.transform.sld.TracingEmitter;
import org.junit.Assert;
import org.junit.Test;

public class SldTransformerTest {
    @Test
    public void testPointSimple() throws Exception {
        YamlMap style = this.transform("point", "simple.sld");
        Assert.assertEquals((Object)"SLD Cook Book: Simple Point With Stroke", (Object)style.str("title"));
        YamlMap rule = style.seq("feature-styles").map(0).seq("rules").map(0);
        YamlMap point = rule.seq("symbolizers").map(0).map("point");
        Assert.assertEquals((long)6L, (long)point.integer("size").intValue());
        YamlMap mark = point.seq("symbols").map(0).map("mark");
        Assert.assertEquals((Object)"circle", (Object)mark.str("shape"));
        Assert.assertEquals((Object)"#FF0000", (Object)mark.str("fill-color"));
    }

    @Test
    public void testPointWithStroke() throws Exception {
        YamlMap style = this.transform("point", "stroke.sld");
        YamlMap mark = style.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("point").seq("symbols").map(0).map("mark");
        Assert.assertEquals((Object)"circle", (Object)mark.str("shape"));
        Assert.assertEquals((Object)"#FF0000", (Object)mark.str("fill-color"));
        Assert.assertEquals((Object)"#000000", (Object)mark.str("stroke-color"));
        Assert.assertEquals((long)2L, (long)mark.integer("stroke-width").intValue());
    }

    @Test
    public void testPointWithGraphic() throws Exception {
        YamlMap style = this.transform("point", "graphic.sld");
        YamlMap eg = style.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("point").seq("symbols").map(0).map("external");
        Assert.assertEquals((Object)"image/png", (Object)eg.str("format"));
        Assert.assertEquals((Object)"smileyface.png", (Object)eg.str("url"));
    }

    @Test
    public void testPointWithLegend() throws Exception {
        YamlMap style = this.transform("point", "legend.sld");
        Assert.assertEquals((Object)"Simple Point With Legend Graphic", (Object)style.str("title"));
        YamlMap rule = style.seq("feature-styles").map(0).seq("rules").map(0);
        YamlMap eg = rule.map("legend").seq("symbols").map(0).map("external");
        Assert.assertEquals((Object)"image/png", (Object)eg.str("format"));
        Assert.assertEquals((Object)"smileyface.png", (Object)eg.str("url"));
        YamlMap point = rule.seq("symbolizers").map(0).map("point");
        Assert.assertEquals((long)6L, (long)point.integer("size").intValue());
        YamlMap mark = point.seq("symbols").map(0).map("mark");
        Assert.assertEquals((Object)"circle", (Object)mark.str("shape"));
        Assert.assertEquals((Object)"#FF0000", (Object)mark.str("fill-color"));
    }

    @Test
    public void testPointWithScale() throws Exception {
        YamlMap style = this.transform("point", "zoom.sld");
        YamlMap rule = style.seq("feature-styles").map(0).seq("rules").map(0);
        Assert.assertEquals((Object)"Large", (Object)rule.str("name"));
        Assert.assertEquals((Object)"(,160000000)", (Object)rule.str("scale"));
        rule = style.seq("feature-styles").map(0).seq("rules").map(1);
        Assert.assertEquals((Object)"Medium", (Object)rule.str("name"));
        Assert.assertEquals((Object)"(160000000,320000000)", (Object)rule.str("scale"));
        rule = style.seq("feature-styles").map(0).seq("rules").map(2);
        Assert.assertEquals((Object)"Small", (Object)rule.str("name"));
        Assert.assertEquals((Object)"(320000000,)", (Object)rule.str("scale"));
    }

    @Test
    public void testPointWithAttribute() throws Exception {
        YamlMap style = this.transform("point", "attribute.sld");
        YamlMap rule = style.seq("feature-styles").map(0).seq("rules").map(0);
        Assert.assertEquals((Object)"SmallPop", (Object)rule.str("name"));
        Assert.assertEquals((Object)"pop < '50000'", (Object)rule.str("filter"));
        rule = style.seq("feature-styles").map(0).seq("rules").map(1);
        Assert.assertEquals((Object)"MediumPop", (Object)rule.str("name"));
        Assert.assertEquals((Object)"pop >= '50000' AND pop < '100000'", (Object)rule.str("filter"));
        rule = style.seq("feature-styles").map(0).seq("rules").map(2);
        Assert.assertEquals((Object)"LargePop", (Object)rule.str("name"));
        Assert.assertEquals((Object)"pop >= '100000'", (Object)rule.str("filter"));
    }

    @Test
    public void testPointWithRotation() throws Exception {
        YamlMap style = this.transform("point", "rotated-square.sld");
        YamlMap point = style.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("point");
        Assert.assertEquals((long)12L, (long)point.integer("size").intValue());
        Assert.assertEquals((long)45L, (long)point.integer("rotation").intValue());
    }

    @Test
    public void testPointWithTransparentTriangle() throws Exception {
        YamlMap style = this.transform("point", "transparent-triangle.sld");
        YamlMap mark = style.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("point").seq("symbols").map(0).map("mark");
        Assert.assertEquals((Object)"triangle", (Object)mark.str("shape"));
        Assert.assertEquals((Object)"#009900", (Object)mark.str("fill-color"));
        Assert.assertEquals((double)0.2, (double)mark.doub("fill-opacity"), (double)0.1);
        Assert.assertEquals((Object)"#000000", (Object)mark.str("stroke-color"));
        Assert.assertEquals((long)2L, (long)mark.integer("stroke-width").intValue());
    }

    @Test
    public void testPointWithLabel() throws Exception {
        YamlMap style = this.transform("point", "default-label.sld");
        YamlMap text = style.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(1).map("text");
        Assert.assertEquals((Object)"${name}", (Object)text.str("label"));
        Assert.assertEquals((Object)"#000000", (Object)text.str("fill-color"));
    }

    @Test
    public void testPointWithStyledLabel() throws Exception {
        YamlMap style = this.transform("point", "styled-label.sld");
        YamlMap text = style.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(1).map("text");
        Assert.assertEquals((Object)"${name}", (Object)text.str("label"));
        Assert.assertEquals((Object)"Arial", (Object)text.str("font-family"));
        Assert.assertEquals((long)12L, (long)text.integer("font-size").intValue());
        Assert.assertEquals((Object)"normal", (Object)text.str("font-style"));
        Assert.assertEquals((Object)"bold", (Object)text.str("font-weight"));
        Assert.assertEquals((Object)"point", (Object)text.map("placement").str("type"));
        Assert.assertEquals((Object)"(0.5,0.0)", (Object)text.map("placement").str("anchor"));
        Assert.assertEquals((Object)"(0,5)", (Object)text.map("placement").str("displacement"));
        Assert.assertEquals((Object)"#000000", (Object)text.str("fill-color"));
    }

    @Test
    public void testPointWithRotatedLabel() throws Exception {
        YamlMap style = this.transform("point", "rotated-label.sld");
        YamlMap text = style.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(1).map("text");
        YamlMap pp = text.map("placement");
        Assert.assertEquals((long)-45L, (long)pp.integer("rotation").intValue());
    }

    @Test
    public void testLineSimple() throws Exception {
        YamlMap style = this.transform("line", "simple.sld");
        YamlMap line = style.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("line");
        Assert.assertEquals((Object)"#000000", (Object)line.str("stroke-color"));
        Assert.assertEquals((long)3L, (long)line.integer("stroke-width").intValue());
    }

    @Test
    public void testLineWithAttribute() throws Exception {
        YamlMap style = this.transform("line", "attribute.sld");
        YamlMap rule = style.seq("feature-styles").map(0).seq("rules").map(0);
        Assert.assertEquals((Object)"local-road", (Object)rule.str("name"));
        Assert.assertEquals((Object)"type = 'local-road'", (Object)rule.str("filter"));
        YamlMap line = rule.seq("symbolizers").map(0).map("line");
        Assert.assertEquals((Object)"#009933", (Object)line.str("stroke-color"));
        Assert.assertEquals((long)2L, (long)line.integer("stroke-width").intValue());
        rule = style.seq("feature-styles").map(1).seq("rules").map(0);
        Assert.assertEquals((Object)"secondary", (Object)rule.str("name"));
        Assert.assertEquals((Object)"type = 'secondary'", (Object)rule.str("filter"));
        line = rule.seq("symbolizers").map(0).map("line");
        Assert.assertEquals((Object)"#0055CC", (Object)line.str("stroke-color"));
        Assert.assertEquals((long)3L, (long)line.integer("stroke-width").intValue());
        rule = style.seq("feature-styles").map(2).seq("rules").map(0);
        Assert.assertEquals((Object)"highway", (Object)rule.str("name"));
        Assert.assertEquals((Object)"type = 'highway'", (Object)rule.str("filter"));
        line = rule.seq("symbolizers").map(0).map("line");
        Assert.assertEquals((Object)"#FF0000", (Object)line.str("stroke-color"));
        Assert.assertEquals((long)6L, (long)line.integer("stroke-width").intValue());
    }

    @Test
    public void testLineWithBorder() throws Exception {
        YamlMap style = this.transform("line", "border.sld");
        YamlMap rule = style.seq("feature-styles").map(0).seq("rules").map(0);
        YamlMap line = rule.seq("symbolizers").map(0).map("line");
        Assert.assertEquals((Object)"#333333", (Object)line.str("stroke-color"));
        Assert.assertEquals((long)5L, (long)line.integer("stroke-width").intValue());
        Assert.assertEquals((Object)"round", (Object)line.str("stroke-linecap"));
        rule = style.seq("feature-styles").map(1).seq("rules").map(0);
        line = rule.seq("symbolizers").map(0).map("line");
        Assert.assertEquals((Object)"#6699FF", (Object)line.str("stroke-color"));
        Assert.assertEquals((long)3L, (long)line.integer("stroke-width").intValue());
        Assert.assertEquals((Object)"round", (Object)line.str("stroke-linecap"));
    }

    @Test
    public void testLineWithCurvedLabel() throws Exception {
        YamlMap style = this.transform("line", "curved-label.sld");
        YamlMap text = style.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(1).map("text");
        Assert.assertEquals((Object)"${name}", (Object)text.str("label"));
        Assert.assertEquals((Object)"#000000", (Object)text.str("fill-color"));
        Assert.assertEquals((Object)true, (Object)text.bool(Ysld.OPTION_PREFIX + "followLine"));
    }

    @Test
    public void testLineWithDashdot() throws Exception {
        YamlMap style = this.transform("line", "dash-dot.sld");
        YamlMap rule = style.seq("feature-styles").map(0).seq("rules").map(0);
        YamlMap line = rule.seq("symbolizers").map(0).map("line");
        Assert.assertEquals((Object)"#0000FF", (Object)line.str("stroke-color"));
        Assert.assertEquals((long)1L, (long)line.integer("stroke-width").intValue());
        Assert.assertEquals((Object)"10 10", (Object)line.str("stroke-dasharray"));
        line = rule.seq("symbolizers").map(1).map("line");
        Assert.assertEquals((Object)"5 15", (Object)line.str("stroke-dasharray"));
        Assert.assertEquals((double)7.5, (double)line.doub("stroke-dashoffset"), (double)0.1);
        YamlMap g = line.map("stroke-graphic-stroke");
        Assert.assertEquals((long)5L, (long)g.integer("size").intValue());
        Assert.assertEquals((Object)"circle", (Object)g.seq("symbols").map(0).map("mark").str("shape"));
        Assert.assertEquals((Object)"#000033", (Object)g.seq("symbols").map(0).map("mark").str("stroke-color"));
        Assert.assertEquals((long)1L, (long)g.seq("symbols").map(0).map("mark").integer("stroke-width").intValue());
    }

    @Test
    public void testLineWithDashedline() throws Exception {
        YamlMap style = this.transform("line", "dashed-line.sld");
        YamlMap line = style.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("line");
        Assert.assertEquals((Object)"#0000FF", (Object)line.str("stroke-color"));
        Assert.assertEquals((long)3L, (long)line.integer("stroke-width").intValue());
        Assert.assertEquals((Object)"5 2", (Object)line.str("stroke-dasharray"));
    }

    @Test
    public void testLineWithDashspace() throws Exception {
        YamlMap style = this.transform("line", "dash-space.sld");
        YamlMap line = style.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("line");
        Assert.assertEquals((Object)"4 6", (Object)line.str("stroke-dasharray"));
        YamlMap g = line.map("stroke-graphic-stroke");
        Assert.assertEquals((long)4L, (long)g.integer("size").intValue());
        Assert.assertEquals((Object)"circle", (Object)g.seq("symbols").map(0).map("mark").str("shape"));
        Assert.assertEquals((Object)"#666666", (Object)g.seq("symbols").map(0).map("mark").str("fill-color"));
        Assert.assertEquals((Object)"#333333", (Object)g.seq("symbols").map(0).map("mark").str("stroke-color"));
        Assert.assertEquals((long)1L, (long)g.seq("symbols").map(0).map("mark").integer("stroke-width").intValue());
    }

    @Test
    public void testLineWithDefaultLabel() throws Exception {
        YamlMap style = this.transform("line", "default-label.sld");
        YamlMap line = style.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("line");
        Assert.assertEquals((Object)"#FF0000", (Object)line.str("stroke-color"));
        YamlMap text = style.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(1).map("text");
        Assert.assertEquals((Object)"${name}", (Object)text.str("label"));
        Assert.assertEquals((Object)"#000000", (Object)text.str("fill-color"));
    }

    @Test
    public void testLineWithRailroad() throws Exception {
        YamlMap style = this.transform("line", "railroad.sld");
        YamlMap line = style.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(1).map("line");
        YamlMap mark = line.map("stroke-graphic-stroke").seq("symbols").map(0).map("mark");
        Assert.assertEquals((Object)"shape://vertline", (Object)mark.str("shape"));
        Assert.assertEquals((Object)"#333333", (Object)mark.str("stroke-color"));
        Assert.assertEquals((long)1L, (long)mark.integer("stroke-width").intValue());
    }

    @Test
    public void testLineWithZoom() throws Exception {
        YamlMap style = this.transform("line", "zoom.sld");
        YamlMap rule = style.seq("feature-styles").map(0).seq("rules").map(0);
        Assert.assertEquals((Object)"Large", (Object)rule.str("name"));
        Assert.assertEquals((Object)"(,180000000)", (Object)rule.str("scale"));
        YamlMap line = rule.seq("symbolizers").map(0).map("line");
        Assert.assertEquals((Object)"#009933", (Object)line.str("stroke-color"));
        Assert.assertEquals((long)6L, (long)line.integer("stroke-width").intValue());
        rule = style.seq("feature-styles").map(0).seq("rules").map(1);
        Assert.assertEquals((Object)"Medium", (Object)rule.str("name"));
        Assert.assertEquals((Object)"(180000000,360000000)", (Object)rule.str("scale"));
        line = rule.seq("symbolizers").map(0).map("line");
        Assert.assertEquals((Object)"#009933", (Object)line.str("stroke-color"));
        Assert.assertEquals((long)4L, (long)line.integer("stroke-width").intValue());
        rule = style.seq("feature-styles").map(0).seq("rules").map(2);
        Assert.assertEquals((Object)"Small", (Object)rule.str("name"));
        Assert.assertEquals((Object)"(360000000,)", (Object)rule.str("scale"));
        line = rule.seq("symbolizers").map(0).map("line");
        Assert.assertEquals((Object)"#009933", (Object)line.str("stroke-color"));
        Assert.assertEquals((long)2L, (long)line.integer("stroke-width").intValue());
    }

    @Test
    public void testLineWithOptimizedLabel() throws Exception {
        YamlMap style = this.transform("line", "optimized-label.sld");
        YamlMap text = style.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(1).map("text");
        Assert.assertEquals((Object)"${name}", (Object)text.str("label"));
        Assert.assertEquals((Object)"#000000", (Object)text.str("fill-color"));
        Assert.assertEquals((Object)true, (Object)text.bool(Ysld.OPTION_PREFIX + "followLine"));
        Assert.assertEquals((long)90L, (long)text.integer(Ysld.OPTION_PREFIX + "maxAngleDelta").intValue());
        Assert.assertEquals((long)400L, (long)text.integer(Ysld.OPTION_PREFIX + "maxDisplacement").intValue());
        Assert.assertEquals((long)150L, (long)text.integer(Ysld.OPTION_PREFIX + "repeat").intValue());
    }

    @Test
    public void testLineWithOptimizedAndStyledLabel() throws Exception {
        YamlMap style = this.transform("line", "optimized-styled-label.sld");
        YamlMap text = style.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(1).map("text");
        Assert.assertEquals((Object)"${name}", (Object)text.str("label"));
        Assert.assertEquals((Object)"#000000", (Object)text.str("fill-color"));
        Assert.assertEquals((Object)"Arial", (Object)text.str("font-family"));
        Assert.assertEquals((long)10L, (long)text.integer("font-size").intValue());
        Assert.assertEquals((Object)"normal", (Object)text.str("font-style"));
        Assert.assertEquals((Object)"bold", (Object)text.str("font-weight"));
        Assert.assertEquals((Object)true, (Object)text.bool(Ysld.OPTION_PREFIX + "followLine"));
        Assert.assertEquals((long)90L, (long)text.integer(Ysld.OPTION_PREFIX + "maxAngleDelta").intValue());
        Assert.assertEquals((long)400L, (long)text.integer(Ysld.OPTION_PREFIX + "maxDisplacement").intValue());
        Assert.assertEquals((long)150L, (long)text.integer(Ysld.OPTION_PREFIX + "repeat").intValue());
    }

    @Test
    public void testPolygonSimple() throws Exception {
        YamlMap obj = this.transform("poly", "simple.sld");
        YamlMap poly = obj.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("polygon");
        Assert.assertEquals((Object)"#000080", (Object)poly.str("fill-color"));
    }

    @Test
    public void testPolygonWithAttribute() throws Exception {
        YamlMap obj = this.transform("poly", "attribute.sld");
        YamlMap rule = obj.seq("feature-styles").map(0).seq("rules").map(0);
        Assert.assertEquals((Object)"SmallPop", (Object)rule.str("name"));
        Assert.assertEquals((Object)"pop < '200000'", (Object)rule.str("filter"));
        YamlMap poly = rule.seq("symbolizers").map(0).map("polygon");
        Assert.assertEquals((Object)"#66FF66", (Object)poly.str("fill-color"));
        rule = obj.seq("feature-styles").map(0).seq("rules").map(1);
        Assert.assertEquals((Object)"MediumPop", (Object)rule.str("name"));
        Assert.assertEquals((Object)"pop >= '200000' AND pop < '500000'", (Object)rule.str("filter"));
        poly = rule.seq("symbolizers").map(0).map("polygon");
        Assert.assertEquals((Object)"#33CC33", (Object)poly.str("fill-color"));
        rule = obj.seq("feature-styles").map(0).seq("rules").map(2);
        Assert.assertEquals((Object)"LargePop", (Object)rule.str("name"));
        Assert.assertEquals((Object)"pop > '500000'", (Object)rule.str("filter"));
        poly = rule.seq("symbolizers").map(0).map("polygon");
        Assert.assertEquals((Object)"#009900", (Object)poly.str("fill-color"));
    }

    @Test
    public void testPolygonWithDefaultLabel() throws Exception {
        YamlMap obj = this.transform("poly", "default-label.sld");
        YamlMap poly = obj.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("polygon");
        YamlMap text = obj.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(1).map("text");
        Assert.assertEquals((Object)"#40FF40", (Object)poly.str("fill-color"));
        Assert.assertEquals((Object)"#FFFFFF", (Object)poly.str("stroke-color"));
        Assert.assertEquals((long)2L, (long)poly.integer("stroke-width").intValue());
        Assert.assertEquals((Object)"${name}", (Object)text.str("label"));
    }

    @Test
    public void testPolygonWithGraphicFill() throws Exception {
        YamlMap obj = this.transform("poly", "graphic-fill.sld");
        YamlMap poly = obj.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("polygon");
        YamlMap g = poly.map("fill-graphic").seq("symbols").map(0).map("external");
        Assert.assertEquals((Object)"colorblocks.png", (Object)g.str("url"));
        Assert.assertEquals((Object)"image/png", (Object)g.str("format"));
        Assert.assertEquals((long)93L, (long)poly.map("fill-graphic").integer("size").intValue());
    }

    @Test
    public void testPolygonWithHaloLabel() throws Exception {
        YamlMap obj = this.transform("poly", "halo-label.sld");
        YamlMap text = obj.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(1).map("text");
        Assert.assertEquals((Object)"${name}", (Object)text.str("label"));
        Assert.assertEquals((long)3L, (long)text.map("halo").integer("radius").intValue());
        Assert.assertEquals((Object)"#FFFFFF", (Object)text.map("halo").str("fill-color"));
    }

    @Test
    public void testPolygonWithHatchFill() throws Exception {
        YamlMap obj = this.transform("poly", "hatch-fill.sld");
        YamlMap poly = obj.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("polygon");
        YamlMap mark = poly.map("fill-graphic").seq("symbols").map(0).map("mark");
        Assert.assertEquals((Object)"shape://times", (Object)mark.str("shape"));
        Assert.assertEquals((Object)"#990099", (Object)mark.str("stroke-color"));
        Assert.assertEquals((long)1L, (long)mark.integer("stroke-width").intValue());
        Assert.assertEquals((long)16L, (long)poly.map("fill-graphic").integer("size").intValue());
    }

    @Test
    public void testPolygonWithStroke() throws Exception {
        YamlMap obj = this.transform("poly", "stroke.sld");
        YamlMap poly = obj.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("polygon");
        Assert.assertEquals((Object)"#000080", (Object)poly.str("fill-color"));
        Assert.assertEquals((Object)"#FFFFFF", (Object)poly.str("stroke-color"));
        Assert.assertEquals((long)2L, (long)poly.integer("stroke-width").intValue());
    }

    @Test
    public void testPolygonWithStyledLabel() throws Exception {
        YamlMap obj = this.transform("poly", "styled-label.sld");
        YamlMap text = obj.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(1).map("text");
        Assert.assertEquals((Object)"${name}", (Object)text.str("label"));
        Assert.assertEquals((Object)"Arial", (Object)text.str("font-family"));
        Assert.assertEquals((long)11L, (long)text.integer("font-size").intValue());
        Assert.assertEquals((Object)"normal", (Object)text.str("font-style"));
        Assert.assertEquals((Object)"bold", (Object)text.str("font-weight"));
        Assert.assertEquals((Object)"point", (Object)text.map("placement").str("type"));
        Assert.assertEquals((Object)"(0.5,0.5)", (Object)text.map("placement").str("anchor"));
        Assert.assertEquals((Object)"#000000", (Object)text.str("fill-color"));
        Assert.assertEquals((long)60L, (long)text.integer(Ysld.OPTION_PREFIX + "autoWrap").intValue());
        Assert.assertEquals((long)150L, (long)text.integer(Ysld.OPTION_PREFIX + "maxDisplacement").intValue());
    }

    @Test
    public void testPolygonWithTransparent() throws Exception {
        YamlMap obj = this.transform("poly", "transparent.sld");
        YamlMap poly = obj.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("polygon");
        Assert.assertEquals((Object)"#000080", (Object)poly.str("fill-color"));
        Assert.assertEquals((double)0.5, (double)poly.doub("fill-opacity"), (double)0.1);
        Assert.assertEquals((Object)"#FFFFFF", (Object)poly.str("stroke-color"));
        Assert.assertEquals((long)2L, (long)poly.integer("stroke-width").intValue());
    }

    @Test
    public void testPolygonWithZoom() throws Exception {
        YamlMap obj = this.transform("poly", "zoom.sld");
        YamlMap rule = obj.seq("feature-styles").map(0).seq("rules").map(0);
        Assert.assertEquals((Object)"Large", (Object)rule.str("name"));
        Assert.assertEquals((Object)"(,100000000)", (Object)rule.str("scale"));
        YamlMap poly = rule.seq("symbolizers").map(0).map("polygon");
        Assert.assertEquals((Object)"#0000CC", (Object)poly.str("fill-color"));
        Assert.assertEquals((Object)"#000000", (Object)poly.str("stroke-color"));
        Assert.assertEquals((long)7L, (long)poly.integer("stroke-width").intValue());
        YamlMap text = rule.seq("symbolizers").map(1).map("text");
        Assert.assertEquals((Object)"${name}", (Object)text.str("label"));
        Assert.assertEquals((Object)"Arial", (Object)text.str("font-family"));
        Assert.assertEquals((long)14L, (long)text.integer("font-size").intValue());
        Assert.assertEquals((Object)"normal", (Object)text.str("font-style"));
        Assert.assertEquals((Object)"bold", (Object)text.str("font-weight"));
        Assert.assertEquals((Object)"point", (Object)text.map("placement").str("type"));
        Assert.assertEquals((Object)"(0.5,0.5)", (Object)text.map("placement").str("anchor"));
        Assert.assertEquals((Object)"#FFFFFF", (Object)text.str("fill-color"));
        rule = obj.seq("feature-styles").map(0).seq("rules").map(1);
        Assert.assertEquals((Object)"Medium", (Object)rule.str("name"));
        Assert.assertEquals((Object)"(100000000,200000000)", (Object)rule.str("scale"));
        poly = rule.seq("symbolizers").map(0).map("polygon");
        Assert.assertEquals((Object)"#0000CC", (Object)poly.str("fill-color"));
        Assert.assertEquals((Object)"#000000", (Object)poly.str("stroke-color"));
        Assert.assertEquals((long)4L, (long)poly.integer("stroke-width").intValue());
        rule = obj.seq("feature-styles").map(0).seq("rules").map(2);
        Assert.assertEquals((Object)"Small", (Object)rule.str("name"));
        Assert.assertEquals((Object)"(200000000,)", (Object)rule.str("scale"));
        poly = rule.seq("symbolizers").map(0).map("polygon");
        poly = rule.seq("symbolizers").map(0).map("polygon");
        Assert.assertEquals((Object)"#0000CC", (Object)poly.str("fill-color"));
        Assert.assertEquals((Object)"#000000", (Object)poly.str("stroke-color"));
        Assert.assertEquals((long)1L, (long)poly.integer("stroke-width").intValue());
    }

    @Test
    public void testRasterWithAlphaChannel() throws Exception {
        YamlMap obj = this.transform("raster", "alpha-channel.sld");
        YamlMap raster = obj.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("raster");
        Assert.assertEquals((Object)"(#008000,,70,)", (Object)raster.map("color-map").seq("entries").str(0));
        Assert.assertEquals((Object)"(#008000,0,256,)", (Object)raster.map("color-map").seq("entries").str(1));
    }

    @Test
    public void testRasterWithBrightnessAndContrast() throws Exception {
        YamlMap obj = this.transform("raster", "brightness-and-contrast.sld");
        YamlMap raster = obj.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("raster");
        Assert.assertEquals((Object)"normalize", (Object)raster.map("contrast-enhancement").str("mode"));
        Assert.assertEquals((double)0.5, (double)raster.map("contrast-enhancement").doub("gamma"), (double)0.1);
        Assert.assertEquals((Object)"(#008000,,70,)", (Object)raster.map("color-map").seq("entries").str(0));
        Assert.assertEquals((Object)"(#663333,,256,)", (Object)raster.map("color-map").seq("entries").str(1));
    }

    @Test
    public void testRasterWithDiscreteColors() throws Exception {
        YamlMap obj = this.transform("raster", "discrete-colors.sld");
        YamlMap raster = obj.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("raster");
        Assert.assertEquals((Object)"intervals", (Object)raster.map("color-map").str("type"));
        Assert.assertEquals((Object)"(#008000,,150,)", (Object)raster.map("color-map").seq("entries").str(0));
        Assert.assertEquals((Object)"(#663333,,256,)", (Object)raster.map("color-map").seq("entries").str(1));
    }

    @Test
    public void testRasterWithManyColorGradient() throws Exception {
        YamlMap obj = this.transform("raster", "many-color-gradient.sld");
        YamlMap raster = obj.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("raster");
        Assert.assertEquals((Object)"(#000000,,95,)", (Object)raster.map("color-map").seq("entries").str(0));
        Assert.assertEquals((Object)"(#0000FF,,110,)", (Object)raster.map("color-map").seq("entries").str(1));
        Assert.assertEquals((Object)"(#00FF00,,135,)", (Object)raster.map("color-map").seq("entries").str(2));
        Assert.assertEquals((Object)"(#FF0000,,160,)", (Object)raster.map("color-map").seq("entries").str(3));
        Assert.assertEquals((Object)"(#FF00FF,,185,)", (Object)raster.map("color-map").seq("entries").str(4));
        Assert.assertEquals((Object)"(#FFFF00,,210,)", (Object)raster.map("color-map").seq("entries").str(5));
        Assert.assertEquals((Object)"(#00FFFF,,235,)", (Object)raster.map("color-map").seq("entries").str(6));
        Assert.assertEquals((Object)"(#FFFFFF,,256,)", (Object)raster.map("color-map").seq("entries").str(7));
    }

    @Test
    public void testRasterWithThreeColorGradient() throws Exception {
        YamlMap obj = this.transform("raster", "three-color-gradient.sld");
        YamlMap raster = obj.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("raster");
        Assert.assertEquals((Object)"(#0000FF,,150,)", (Object)raster.map("color-map").seq("entries").str(0));
        Assert.assertEquals((Object)"(#FFFF00,,200,)", (Object)raster.map("color-map").seq("entries").str(1));
        Assert.assertEquals((Object)"(#FF0000,,250,)", (Object)raster.map("color-map").seq("entries").str(2));
    }

    @Test
    public void testRasterWithTransparentGradient() throws Exception {
        YamlMap obj = this.transform("raster", "transparent-gradient.sld");
        YamlMap raster = obj.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("raster");
        Assert.assertEquals((double)0.3, (double)raster.doub("opacity"), (double)0.1);
        Assert.assertEquals((Object)"(#008000,,70,)", (Object)raster.map("color-map").seq("entries").str(0));
        Assert.assertEquals((Object)"(#663333,,256,)", (Object)raster.map("color-map").seq("entries").str(1));
    }

    @Test
    public void testRasterWithTwoColorGradient() throws Exception {
        YamlMap obj = this.transform("raster", "two-color-gradient.sld");
        YamlMap raster = obj.seq("feature-styles").map(0).seq("rules").map(0).seq("symbolizers").map(0).map("raster");
        Assert.assertEquals((Object)"(#008000,,70,)", (Object)raster.map("color-map").seq("entries").str(0));
        Assert.assertEquals((Object)"(#663333,,256,)", (Object)raster.map("color-map").seq("entries").str(1));
    }

    SldTransformer transformer(String dirname, String filename) throws Exception {
        StringWriter yaml = new StringWriter();
        XMLInputFactory factory = XMLInputFactory.newFactory();
        XMLStreamReader xml = factory.createXMLStreamReader(YsldTests.sld(dirname, filename));
        return new SldTransformer(xml, (Writer)yaml);
    }

    YamlMap yaml(SldTransformer transformer) throws Exception {
        String yaml = transformer.context().output().toString();
        return new YamlMap(YamlUtil.getSafeYaml().load(yaml));
    }

    YamlMap transform(String dirname, String filename) throws Exception {
        SldTransformer tx = this.transformer(dirname, filename);
        tx.context().trace();
        try {
            tx.transform();
            return this.yaml(tx);
        }
        catch (Exception e) {
            ((TracingEmitter)tx.context().emitter()).dump(System.out);
            throw e;
        }
    }
}

