/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld.transform.sld;

import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.geotools.ysld.transform.sld.AnchorHandler;
import org.geotools.ysld.transform.sld.DisplacementHandler;
import org.geotools.ysld.transform.sld.ExpressionHandler;
import org.geotools.ysld.transform.sld.FillHandler;
import org.geotools.ysld.transform.sld.ParameterHandler;
import org.geotools.ysld.transform.sld.SldTransformContext;
import org.geotools.ysld.transform.sld.SldTransformHandler;
import org.geotools.ysld.transform.sld.SymbolizerHandler;

public class TextSymbolizerHandler
extends SymbolizerHandler {
    @Override
    public void element(XMLStreamReader xml, SldTransformContext context) throws XMLStreamException, IOException {
        String name = xml.getLocalName();
        if ("TextSymbolizer".equals(name)) {
            context.mapping().scalar("text").mapping();
        } else if ("Label".equals(name)) {
            context.scalar("label").push(new ExpressionHandler());
        } else if ("Font".equals(name)) {
            context.push(new FontHandler());
        } else if ("LabelPlacement".equals(name)) {
            context.scalar("placement").push(new PlacementHandler());
        } else if ("Halo".equals(name)) {
            context.scalar("halo").push(new HaloHandler());
        } else if ("Fill".equals(name)) {
            context.push(new FillHandler());
        } else {
            super.element(xml, context);
        }
    }

    @Override
    public void endElement(XMLStreamReader xml, SldTransformContext context) throws XMLStreamException, IOException {
        String name = xml.getLocalName();
        if ("TextSymbolizer".equals(name)) {
            this.dumpOptions(context).endMapping().endMapping().pop();
        } else {
            super.endElement(xml, context);
        }
    }

    static class HaloHandler
    extends SldTransformHandler {
        HaloHandler() {
        }

        @Override
        public void element(XMLStreamReader xml, SldTransformContext context) throws XMLStreamException, IOException {
            String name = xml.getLocalName();
            if ("Halo".equals(name)) {
                context.mapping();
            } else if ("Fill".equals(name)) {
                context.push(new FillHandler());
            } else if ("Radius".equals(name)) {
                context.scalar("radius").push(new ExpressionHandler());
            }
        }

        @Override
        public void endElement(XMLStreamReader xml, SldTransformContext context) throws XMLStreamException, IOException {
            String name = xml.getLocalName();
            if ("Halo".equals(name)) {
                context.endMapping().pop();
            }
        }
    }

    static class PlacementHandler
    extends SldTransformHandler {
        PlacementHandler() {
        }

        @Override
        public void element(XMLStreamReader xml, SldTransformContext context) throws XMLStreamException, IOException {
            String name = xml.getLocalName();
            if ("LabelPlacement".equals(name)) {
                context.mapping();
            } else if ("PointPlacement".equals(name)) {
                context.scalar("type").scalar("point");
            } else if ("LinePlacement".equals(name)) {
                context.scalar("type").scalar("line");
            } else if ("AnchorPoint".equals(name)) {
                context.scalar("anchor").push(new AnchorHandler());
            } else if ("Displacement".equals(name)) {
                context.scalar("displacement").push(new DisplacementHandler());
            } else if ("Rotation".equals(name)) {
                context.scalar("rotation").push(new ExpressionHandler());
            } else if ("PerpendicularOffset".equals(name)) {
                context.scalar("offset").push(new ExpressionHandler());
            } else if ("IsRepeated".equals(name)) {
                context.scalar("repeat").scalar(xml.getElementText());
            } else if ("IsAligned".equals(name)) {
                context.scalar("align").scalar(xml.getElementText());
            } else if ("GeneralizeLine".equals(name)) {
                context.scalar("generalize").scalar(xml.getElementText());
            } else if ("InitialGap".equals(name)) {
                context.scalar("initial-gap").push(new ExpressionHandler());
            } else if ("Gap".equals(name)) {
                context.scalar("gap").push(new ExpressionHandler());
            }
        }

        @Override
        public void endElement(XMLStreamReader xml, SldTransformContext context) throws XMLStreamException, IOException {
            String name = xml.getLocalName();
            if ("LabelPlacement".equals(name)) {
                context.endMapping().pop();
            }
        }
    }

    static class FontHandler
    extends SldTransformHandler {
        FontHandler() {
        }

        @Override
        public void element(XMLStreamReader xml, SldTransformContext context) throws XMLStreamException, IOException {
            String name = xml.getLocalName();
            if ("CssParameter".equals(name) || "SvgParameter".equals(name)) {
                context.push(new ParameterHandler());
            }
        }

        @Override
        public void endElement(XMLStreamReader xml, SldTransformContext context) throws XMLStreamException, IOException {
            String name = xml.getLocalName();
            if ("Font".equals(name)) {
                context.pop();
            }
        }
    }
}

