/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld.transform.sld;

import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.geotools.ysld.transform.sld.FilterHandler;
import org.geotools.ysld.transform.sld.GraphicHandler;
import org.geotools.ysld.transform.sld.SldTransformContext;
import org.geotools.ysld.transform.sld.SldTransformHandler;
import org.geotools.ysld.transform.sld.SymbolizersHandler;

public class RulesHandler
extends SldTransformHandler {
    String minScale;
    String maxScale;

    @Override
    public void element(XMLStreamReader xml, SldTransformContext context) throws XMLStreamException, IOException {
        String name = xml.getLocalName();
        if ("Rule".equals(name)) {
            context.mapping();
        } else if ("Name".equals(name)) {
            context.scalar("name");
            context.scalar(xml.getElementText());
        } else if ("Title".equals(name)) {
            context.scalar("title");
            context.scalar(xml.getElementText());
        } else if ("Abstract".equals(name)) {
            context.scalar("abstract");
            context.scalar(xml.getElementText());
        } else if ("LegendGraphic".equals(name)) {
            context.scalar("legend").push(new GraphicHandler());
        } else if (name.equals("MinScaleDenominator")) {
            this.minScale = xml.getElementText();
        } else if (name.equals("MaxScaleDenominator")) {
            this.maxScale = xml.getElementText();
        } else if (name.equals("Filter")) {
            context.scalar("filter").push(new FilterHandler());
        } else if (name.endsWith("Symbolizer")) {
            if (this.minScale != null || this.maxScale != null) {
                context.scalar("scale").tuple(this.minScale, this.maxScale);
            }
            context.scalar("symbolizers").sequence().push(new SymbolizersHandler());
        }
    }

    @Override
    public void endElement(XMLStreamReader xml, SldTransformContext context) throws XMLStreamException, IOException {
        String name = xml.getLocalName();
        if ("Rule".equals(name)) {
            this.maxScale = null;
            this.minScale = null;
            context.endSequence().endMapping();
        } else if ("FeatureTypeStyle".equals(name)) {
            context.pop();
        }
    }
}

