/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld.parse;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.geotools.ysld.YamlMap;
import org.geotools.ysld.YamlObject;
import org.geotools.ysld.parse.YamlParseHandler;

public class YamlParseContext {
    Deque<Entry> stack;
    Entry curr;
    Map<String, Object> docHints = new HashMap<String, Object>();

    public YamlParseContext() {
        this.stack = new ArrayDeque<Entry>();
    }

    public YamlParseContext push(String key, YamlParseHandler handler) {
        return this.push(this.curr.obj, key, handler);
    }

    public YamlParseContext push(YamlObject scope, String key, YamlParseHandler handler) {
        YamlMap map = scope.map();
        if (map.has(key)) {
            return this.doPush(scope.map().obj(key), handler);
        }
        return this;
    }

    public YamlParseContext push(YamlParseHandler handler) {
        return this.doPush(this.curr.obj, handler);
    }

    public YamlParseContext push(YamlObject obj, YamlParseHandler handler) {
        return this.doPush(obj, handler);
    }

    YamlParseContext doPush(YamlObject obj, YamlParseHandler handler) {
        this.stack.push(new Entry(obj, handler));
        return this;
    }

    public YamlParseContext pop() {
        this.stack.pop();
        return this;
    }

    public boolean next() {
        this.curr = this.stack.pop();
        this.curr.handler.handle(this.curr.obj, this);
        return !this.stack.isEmpty();
    }

    @Nullable
    public Object getDocHint(String key) {
        return this.docHints.get(key);
    }

    public void setDocHint(String key, Object value) {
        this.docHints.put(key, value);
    }

    public void mergeDocHints(Map<String, Object> hints) {
        this.docHints.putAll(hints);
    }

    static class Entry {
        YamlObject obj;
        YamlParseHandler handler;

        Entry(YamlObject obj, YamlParseHandler handler) {
            this.obj = obj;
            this.handler = handler;
        }
    }
}

