/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld.parse;

import org.geotools.styling.AnchorPoint;
import org.geotools.styling.Graphic;
import org.geotools.styling.LinePlacement;
import org.geotools.styling.PointPlacement;
import org.geotools.styling.Rule;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.TextSymbolizer2;
import org.geotools.ysld.YamlMap;
import org.geotools.ysld.YamlObject;
import org.geotools.ysld.parse.Factory;
import org.geotools.ysld.parse.FillParser;
import org.geotools.ysld.parse.GraphicParser;
import org.geotools.ysld.parse.SymbolizerParser;
import org.geotools.ysld.parse.Util;
import org.geotools.ysld.parse.YamlParseContext;
import org.geotools.ysld.parse.YamlParseHandler;
import org.geotools.ysld.parse.YsldParseHandler;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.style.Displacement;
import org.opengis.style.Fill;
import org.opengis.style.Font;
import org.opengis.style.Halo;
import org.opengis.style.LabelPlacement;

public class TextParser
extends SymbolizerParser<TextSymbolizer> {
    public TextParser(Rule rule, Factory factory) {
        super(rule, factory.style.createTextSymbolizer(), factory);
    }

    @Override
    public void handle(YamlObject<?> obj, YamlParseContext context) {
        super.handle(obj, context);
        YamlMap map = obj.map();
        if (map.has("label")) {
            ((TextSymbolizer)this.sym).setLabel(Util.expression(map.str("label"), this.factory));
        }
        if (map.has("priority")) {
            ((TextSymbolizer)this.sym).setPriority(Util.expression(map.str("priority"), this.factory));
        }
        context.push(new FontHandler());
        context.push("halo", (YamlParseHandler)new HaloParser());
        context.push(new PlacementParser());
        context.push(new FillParser(this.factory){

            @Override
            protected void fill(org.geotools.styling.Fill fill) {
                ((TextSymbolizer)TextParser.this.sym).setFill((Fill)fill);
            }
        });
        context.push("graphic", (YamlParseHandler)new GraphicParser(this.factory){

            @Override
            protected void graphic(Graphic g) {
                if (TextParser.this.sym instanceof TextSymbolizer2) {
                    ((TextSymbolizer2)TextParser.this.sym).setGraphic(g);
                }
            }
        });
    }

    class PlacementParser
    extends YsldParseHandler {
        String type;
        PointPlacement point;
        LinePlacement line;

        protected PlacementParser() {
            super(TextParser.this.factory);
            this.point = this.factory.style.createPointPlacement(null, null, null);
            this.line = this.factory.style.createLinePlacement(null);
        }

        @Override
        public void handle(YamlObject<?> obj, YamlParseContext context) {
            YamlMap map = obj.map();
            if (map.has("placement")) {
                ((TextSymbolizer)TextParser.this.sym).setLabelPlacement((LabelPlacement)("line".equals(map.str("placement")) ? this.line : this.point));
            } else {
                ((TextSymbolizer)TextParser.this.sym).setLabelPlacement((LabelPlacement)this.point);
            }
            if (map.has("offset")) {
                this.line.setPerpendicularOffset(Util.expression(map.str("offset"), this.factory));
            }
            if (map.has("anchor")) {
                this.point.setAnchorPoint((org.opengis.style.AnchorPoint)Util.anchor(map.get("anchor"), this.factory));
            }
            if (map.has("displacement")) {
                this.point.setDisplacement((Displacement)Util.displacement(map.get("displacement"), this.factory));
            }
            if (map.has("rotation")) {
                this.point.setRotation(Util.expression(map.str("rotation"), this.factory));
            }
            if (this.point.getAnchorPoint() == null) {
                AnchorPoint defaultAnchor = this.factory.style.getDefaultPointPlacement().getAnchorPoint();
                this.point.setAnchorPoint((org.opengis.style.AnchorPoint)defaultAnchor);
            }
        }
    }

    class HaloParser
    extends YsldParseHandler {
        org.geotools.styling.Halo halo;

        HaloParser() {
            super(TextParser.this.factory);
            this.halo = this.factory.style.createHalo(null, null);
        }

        @Override
        public void handle(YamlObject<?> obj, YamlParseContext context) {
            ((TextSymbolizer)TextParser.this.sym).setHalo((Halo)this.halo);
            YamlMap map = obj.map();
            context.push(new FillParser(this.factory){

                @Override
                protected void fill(org.geotools.styling.Fill fill) {
                    HaloParser.this.halo.setFill((Fill)fill);
                }
            });
            if (map.has("radius")) {
                this.halo.setRadius(Util.expression(map.str("radius"), this.factory));
            }
        }
    }

    class FontHandler
    extends YsldParseHandler {
        org.geotools.styling.Font font;

        protected FontHandler() {
            super(TextParser.this.factory);
            FilterFactory ff = this.factory.filter;
            this.font = this.factory.style.createFont((Expression)ff.literal((Object)"serif"), (Expression)ff.literal((Object)"normal"), (Expression)ff.literal((Object)"normal"), (Expression)ff.literal(10));
        }

        @Override
        public void handle(YamlObject<?> obj, YamlParseContext context) {
            ((TextSymbolizer)TextParser.this.sym).setFont((Font)this.font);
            YamlMap map = obj.map();
            if (map.has("font-family")) {
                this.font.getFamily().clear();
                this.font.getFamily().add(Util.expression(map.str("font-family"), this.factory));
            }
            if (map.has("font-size")) {
                this.font.setSize(Util.expression(map.str("font-size"), this.factory));
            }
            if (map.has("font-style")) {
                this.font.setStyle(Util.expression(map.str("font-style"), this.factory));
            }
            if (map.has("font-weight")) {
                this.font.setWeight(Util.expression(map.str("font-weight"), this.factory));
            }
        }
    }
}

