/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld.parse;

import org.geotools.styling.Graphic;
import org.geotools.styling.Stroke;
import org.geotools.ysld.YamlMap;
import org.geotools.ysld.YamlObject;
import org.geotools.ysld.parse.Factory;
import org.geotools.ysld.parse.GraphicParser;
import org.geotools.ysld.parse.Util;
import org.geotools.ysld.parse.YamlParseContext;
import org.geotools.ysld.parse.YamlParseHandler;
import org.geotools.ysld.parse.YsldParseHandler;

public abstract class StrokeParser
extends YsldParseHandler {
    Stroke stroke;

    protected StrokeParser(Factory factory) {
        super(factory);
    }

    @Override
    public void handle(YamlObject<?> obj, YamlParseContext context) {
        YamlMap map = obj.map();
        if (map.has("stroke-color")) {
            this.stroke().setColor(Util.color(map.get("stroke-color"), this.factory));
        }
        if (map.has("stroke-width")) {
            this.stroke().setWidth(Util.expression(map.str("stroke-width"), this.factory));
        }
        if (map.has("stroke-opacity")) {
            this.stroke().setOpacity(Util.expression(map.str("stroke-opacity"), this.factory));
        }
        if (map.has("stroke-linejoin")) {
            this.stroke().setLineJoin(Util.expression(map.str("stroke-linejoin"), this.factory));
        }
        if (map.has("stroke-linecap")) {
            this.stroke().setLineCap(Util.expression(map.str("stroke-linecap"), this.factory));
        }
        if (map.has("stroke-dasharray")) {
            this.stroke().setDashArray(Util.floatArray(map.str("stroke-dasharray")));
        }
        if (map.has("stroke-dashoffset")) {
            this.stroke().setDashOffset(Util.expression(map.str("stroke-dashoffset"), this.factory));
        }
        context.push("stroke-graphic-fill", (YamlParseHandler)new GraphicParser(this.factory){

            @Override
            protected void graphic(Graphic g) {
                StrokeParser.this.stroke().setGraphicFill((org.opengis.style.Graphic)g);
            }
        });
        context.push("stroke-graphic", (YamlParseHandler)new GraphicParser(this.factory){

            @Override
            protected void graphic(Graphic g) {
                StrokeParser.this.stroke().setGraphicStroke((org.opengis.style.Graphic)g);
            }
        });
    }

    Stroke stroke() {
        if (this.stroke == null) {
            this.stroke = this.factory.style.createStroke(null, null);
            this.stroke(this.stroke);
        }
        return this.stroke;
    }

    protected abstract void stroke(Stroke var1);
}

