/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld.parse;

import org.geotools.styling.Fill;
import org.geotools.styling.Graphic;
import org.geotools.ysld.YamlMap;
import org.geotools.ysld.YamlObject;
import org.geotools.ysld.parse.Factory;
import org.geotools.ysld.parse.GraphicParser;
import org.geotools.ysld.parse.Util;
import org.geotools.ysld.parse.YamlParseContext;
import org.geotools.ysld.parse.YamlParseHandler;
import org.geotools.ysld.parse.YsldParseHandler;

public abstract class FillParser
extends YsldParseHandler {
    Fill fill;

    protected FillParser(Factory factory) {
        super(factory);
    }

    @Override
    public void handle(YamlObject<?> obj, YamlParseContext context) {
        YamlMap map = obj.map();
        if (map.has("fill-color")) {
            this.fill().setColor(Util.color(map.get("fill-color"), this.factory));
        }
        if (map.has("fill-opacity")) {
            this.fill().setOpacity(Util.expression(map.str("fill-opacity"), this.factory));
        }
        context.push("fill-graphic", (YamlParseHandler)new GraphicParser(this.factory){

            @Override
            protected void graphic(Graphic g) {
                FillParser.this.fill().setGraphicFill((org.opengis.style.Graphic)g);
            }
        });
    }

    Fill fill() {
        if (this.fill == null) {
            this.fill = this.factory.style.createFill(null);
            this.fill(this.fill);
        }
        return this.fill;
    }

    protected abstract void fill(Fill var1);
}

