/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld.parse;

import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Style;
import org.geotools.ysld.YamlMap;
import org.geotools.ysld.YamlObject;
import org.geotools.ysld.YamlSeq;
import org.geotools.ysld.parse.Factory;
import org.geotools.ysld.parse.RuleParser;
import org.geotools.ysld.parse.TransformHandler;
import org.geotools.ysld.parse.Util;
import org.geotools.ysld.parse.YamlParseContext;
import org.geotools.ysld.parse.YsldParseHandler;

public class FeatureStyleParser
extends YsldParseHandler {
    Style style;

    FeatureStyleParser(Style style, Factory factory) {
        super(factory);
        this.style = style;
    }

    @Override
    public void handle(YamlObject<?> obj, YamlParseContext context) {
        YamlSeq seq = obj.seq();
        for (YamlObject<Object> o : seq) {
            YamlMap fs = o.map();
            FeatureTypeStyle featureStyle = this.factory.style.createFeatureTypeStyle();
            this.style.featureTypeStyles().add(featureStyle);
            featureStyle.setName(fs.str("name"));
            if (fs.has("title")) {
                featureStyle.getDescription().setTitle(fs.str("title"));
            }
            if (fs.has("abstract")) {
                featureStyle.getDescription().setAbstract(fs.str("abstract"));
            }
            featureStyle.getOptions().putAll(Util.vendorOptions(fs));
            context.push(fs, "transform", new TransformHandler(featureStyle, this.factory));
            context.push(fs, "rules", new RuleParser(featureStyle, this.factory));
        }
    }
}

