/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld.encode;

import org.geotools.styling.Stroke;
import org.geotools.ysld.encode.GraphicEncoder;
import org.geotools.ysld.encode.YsldEncodeHandler;

public class StrokeEncoder
extends YsldEncodeHandler<Stroke> {
    StrokeEncoder(Stroke stroke) {
        super(stroke);
    }

    @Override
    protected void encode(Stroke stroke) {
        this.putColor("stroke-color", stroke.getColor());
        this.put("stroke-width", stroke.getWidth());
        this.put("stroke-opacity", this.nullIf(stroke.getOpacity(), 1.0));
        this.put("stroke-linejoin", this.nullIf(stroke.getLineJoin(), "miter"));
        this.putName("stroke-linecap", this.nullIf(stroke.getLineCap(), "butt"));
        this.put("stroke-dasharray", this.toStringOrNull(stroke.getDashArray()));
        this.put("stroke-dashoffset", this.nullIf(stroke.getDashOffset(), 0.0));
        if (stroke.getGraphicFill() != null) {
            this.push("stroke-graphic-fill").inline(new GraphicEncoder(stroke.getGraphicFill()));
        }
        if (stroke.getGraphicStroke() != null) {
            this.push("stroke-graphic").inline(new GraphicEncoder(stroke.getGraphicStroke()));
        }
    }

    String toStringOrNull(float[] arr) {
        if (arr == null || arr.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (float v : arr) {
            sb.append(v).append(" ");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }
}

