/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld.encode;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.geotools.styling.NamedLayer;
import org.geotools.styling.RemoteOWS;
import org.geotools.styling.SLD;
import org.geotools.styling.Style;
import org.geotools.styling.StyledLayer;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.UserLayer;
import org.geotools.ysld.encode.FeatureStyleEncoder;
import org.geotools.ysld.encode.YsldEncodeHandler;

public class RootEncoder
extends YsldEncodeHandler<StyledLayerDescriptor> {
    RootEncoder(StyledLayerDescriptor sld) {
        super(Collections.singleton(sld).iterator());
    }

    @Override
    protected void encode(StyledLayerDescriptor sld) {
        StyledLayer[] layers = sld.getStyledLayers();
        this.put("sld-name", sld.getName());
        this.put("sld-title", sld.getTitle());
        this.put("sld-abstract", sld.getAbstract());
        Style style = SLD.defaultStyle((StyledLayerDescriptor)sld);
        StyledLayer layer = this.findParentLayer(sld, style);
        this.encode(layer);
        this.encode(style);
    }

    @Override
    protected void encode(UserLayer layer) {
        if (layer == null) {
            return;
        }
        this.put("user-name", layer.getName());
        if (layer.getRemoteOWS() != null) {
            RemoteOWS remote = layer.getRemoteOWS();
            this.put("user-service", remote.getService());
            this.put("user-remote", remote.getOnlineResource());
        }
    }

    @Override
    protected void encode(NamedLayer layer) {
        if (layer == null) {
            return;
        }
        this.put("layer-name", layer.getName());
    }

    private StyledLayer findParentLayer(StyledLayerDescriptor sld, final Style style) {
        if (style == null) {
            return null;
        }
        return sld.layers().stream().filter(new Predicate<StyledLayer>(){

            @Override
            public boolean test(StyledLayer styledLayer) {
                List styles = styledLayer instanceof NamedLayer ? ((NamedLayer)styledLayer).styles() : (styledLayer instanceof UserLayer ? ((UserLayer)styledLayer).userStyles() : Collections.emptyList());
                return styles.contains(style);
            }
        }).findFirst().orElse(null);
    }

    @Override
    protected void encode(StyledLayer layer) {
        if (layer instanceof UserLayer) {
            this.encode((UserLayer)layer);
        } else if (layer instanceof NamedLayer) {
            this.encode((NamedLayer)layer);
        }
    }

    @Override
    protected void encode(Style style) {
        this.put("name", style.getName());
        this.put("title", (Object)Optional.ofNullable(style.getDescription().getTitle()).map(Object::toString).orElse(null));
        this.put("abstract", (Object)Optional.ofNullable(style.getDescription().getAbstract()).map(Object::toString).orElse(null));
        this.put("feature-styles", new FeatureStyleEncoder(style));
    }
}

