/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld.parse;

import java.util.Arrays;
import org.geotools.ysld.TestUtils;
import org.geotools.ysld.parse.ListZoomContext;
import org.geotools.ysld.parse.ScaleRange;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class ListZoomContextTest {
    static final double EPSILON = 1.0E-7;

    @Test
    public void testLevels() {
        ListZoomContext ctxt = new ListZoomContext(Arrays.asList(5000000.0));
        MatcherAssert.assertThat((Object)ctxt.getScaleDenominator(0), (Matcher)Matchers.closeTo((double)5000000.0, (double)1.0E-7));
    }

    @Test
    public void testNonZeroInitial() {
        ListZoomContext ctxt = new ListZoomContext(Arrays.asList(5000000.0), 2);
        MatcherAssert.assertThat((Object)ctxt.getScaleDenominator(2), (Matcher)Matchers.closeTo((double)5000000.0, (double)1.0E-7));
    }

    @Test
    public void testBeforeList() {
        ListZoomContext ctxt = new ListZoomContext(Arrays.asList(5000000.0));
        MatcherAssert.assertThat((Object)ctxt.getScaleDenominator(-1), (Matcher)Matchers.is((Object)Double.POSITIVE_INFINITY));
    }

    @Test
    public void testAfterList() {
        ListZoomContext ctxt = new ListZoomContext(Arrays.asList(5000000.0));
        MatcherAssert.assertThat((Object)ctxt.getScaleDenominator(1), (Matcher)Matchers.is((Object)0.0));
    }

    @Test
    public void testMultiple() {
        ListZoomContext ctxt = new ListZoomContext(Arrays.asList(5000000.0, 2000000.0, 1000000.0));
        MatcherAssert.assertThat((Object)ctxt.getScaleDenominator(-1), (Matcher)Matchers.is((Object)Double.POSITIVE_INFINITY));
        MatcherAssert.assertThat((Object)ctxt.getScaleDenominator(0), (Matcher)Matchers.closeTo((double)5000000.0, (double)1.0E-7));
        MatcherAssert.assertThat((Object)ctxt.getScaleDenominator(1), (Matcher)Matchers.closeTo((double)2000000.0, (double)1.0E-7));
        MatcherAssert.assertThat((Object)ctxt.getScaleDenominator(2), (Matcher)Matchers.closeTo((double)1000000.0, (double)1.0E-7));
        MatcherAssert.assertThat((Object)ctxt.getScaleDenominator(3), (Matcher)Matchers.is((Object)0.0));
    }

    @Test
    public void testSingletonRange() {
        ListZoomContext ctxt = new ListZoomContext(Arrays.asList(5000000.0, 2000000.0, 1000000.0));
        ScaleRange result = ctxt.getRange(Integer.valueOf(1), Integer.valueOf(1));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.not(TestUtils.rangeContains(1.0E7)));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.not(TestUtils.rangeContains(1.0E7)));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.not(TestUtils.rangeContains(5000000.0)));
        MatcherAssert.assertThat((Object)result, TestUtils.rangeContains(2000000.0));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.not(TestUtils.rangeContains(1000000.0)));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.not(TestUtils.rangeContains(1.0E-7)));
    }

    @Test
    public void testSingletonRangeFirst() {
        ListZoomContext ctxt = new ListZoomContext(Arrays.asList(5000000.0, 2000000.0, 1000000.0));
        ScaleRange result = ctxt.getRange(Integer.valueOf(0), Integer.valueOf(0));
        MatcherAssert.assertThat((Object)result, TestUtils.rangeContains(5000000.0));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.not(TestUtils.rangeContains(2000000.0)));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.not(TestUtils.rangeContains(1000000.0)));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.not(TestUtils.rangeContains(1.0E-7)));
    }

    @Test
    public void testSingletonRangeLast() {
        ListZoomContext ctxt = new ListZoomContext(Arrays.asList(5000000.0, 2000000.0, 1000000.0));
        ScaleRange result = ctxt.getRange(Integer.valueOf(2), Integer.valueOf(2));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.not(TestUtils.rangeContains(1.0E7)));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.not(TestUtils.rangeContains(5000000.0)));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.not(TestUtils.rangeContains(2000000.0)));
        MatcherAssert.assertThat((Object)result, TestUtils.rangeContains(1000000.0));
    }

    @Test
    public void testRange() {
        ListZoomContext ctxt = new ListZoomContext(Arrays.asList(5000000.0, 2000000.0, 1000000.0, 500000.0, 200000.0, 100000.0));
        ScaleRange result = ctxt.getRange(Integer.valueOf(1), Integer.valueOf(3));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.not(TestUtils.rangeContains(1.0E7)));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.not(TestUtils.rangeContains(5000000.0)));
        MatcherAssert.assertThat((Object)result, TestUtils.rangeContains(2000000.0));
        MatcherAssert.assertThat((Object)result, TestUtils.rangeContains(1000000.0));
        MatcherAssert.assertThat((Object)result, TestUtils.rangeContains(500000.0));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.not(TestUtils.rangeContains(200000.0)));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.not(TestUtils.rangeContains(100000.0)));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.not(TestUtils.rangeContains(1.0E-7)));
    }

    @Test
    public void testRangeFirst() {
        ListZoomContext ctxt = new ListZoomContext(Arrays.asList(5000000.0, 2000000.0, 1000000.0, 500000.0, 200000.0, 100000.0));
        ScaleRange result = ctxt.getRange(Integer.valueOf(0), Integer.valueOf(3));
        MatcherAssert.assertThat((Object)result, TestUtils.rangeContains(5000000.0));
        MatcherAssert.assertThat((Object)result, TestUtils.rangeContains(2000000.0));
        MatcherAssert.assertThat((Object)result, TestUtils.rangeContains(1000000.0));
        MatcherAssert.assertThat((Object)result, TestUtils.rangeContains(500000.0));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.not(TestUtils.rangeContains(200000.0)));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.not(TestUtils.rangeContains(100000.0)));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.not(TestUtils.rangeContains(1.0E-7)));
    }

    @Test
    public void testRangeLast() {
        ListZoomContext ctxt = new ListZoomContext(Arrays.asList(5000000.0, 2000000.0, 1000000.0, 500000.0, 200000.0, 100000.0));
        ScaleRange result = ctxt.getRange(Integer.valueOf(3), Integer.valueOf(5));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.not(TestUtils.rangeContains(1.0E7)));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.not(TestUtils.rangeContains(5000000.0)));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.not(TestUtils.rangeContains(2000000.0)));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.not(TestUtils.rangeContains(1000000.0)));
        MatcherAssert.assertThat((Object)result, TestUtils.rangeContains(500000.0));
        MatcherAssert.assertThat((Object)result, TestUtils.rangeContains(200000.0));
        MatcherAssert.assertThat((Object)result, TestUtils.rangeContains(100000.0));
    }

    @Test
    public void testRangeOpenStart() {
        ListZoomContext ctxt = new ListZoomContext(Arrays.asList(5000000.0, 2000000.0, 1000000.0, 500000.0, 200000.0, 100000.0));
        ScaleRange result = ctxt.getRange(null, Integer.valueOf(3));
        MatcherAssert.assertThat((Object)result, TestUtils.rangeContains(1.0E7));
        MatcherAssert.assertThat((Object)result, TestUtils.rangeContains(5000000.0));
        MatcherAssert.assertThat((Object)result, TestUtils.rangeContains(2000000.0));
        MatcherAssert.assertThat((Object)result, TestUtils.rangeContains(1000000.0));
        MatcherAssert.assertThat((Object)result, TestUtils.rangeContains(500000.0));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.not(TestUtils.rangeContains(200000.0)));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.not(TestUtils.rangeContains(100000.0)));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.not(TestUtils.rangeContains(1.0E-7)));
    }

    @Test
    public void testRangeOpenEnd() {
        ListZoomContext ctxt = new ListZoomContext(Arrays.asList(5000000.0, 2000000.0, 1000000.0, 500000.0, 200000.0, 100000.0));
        ScaleRange result = ctxt.getRange(Integer.valueOf(3), null);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.not(TestUtils.rangeContains(1.0E7)));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.not(TestUtils.rangeContains(5000000.0)));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.not(TestUtils.rangeContains(2000000.0)));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.not(TestUtils.rangeContains(1000000.0)));
        MatcherAssert.assertThat((Object)result, TestUtils.rangeContains(500000.0));
        MatcherAssert.assertThat((Object)result, TestUtils.rangeContains(200000.0));
        MatcherAssert.assertThat((Object)result, TestUtils.rangeContains(100000.0));
        MatcherAssert.assertThat((Object)result, TestUtils.rangeContains(1.0E-7));
    }

    @Test
    public void testRangePastStart() {
        ListZoomContext ctxt = new ListZoomContext(Arrays.asList(5000000.0, 2000000.0, 1000000.0, 500000.0, 200000.0, 100000.0));
        ScaleRange result = ctxt.getRange(Integer.valueOf(-1), Integer.valueOf(3));
        MatcherAssert.assertThat((Object)result, TestUtils.rangeContains(1.0E7));
        MatcherAssert.assertThat((Object)result, TestUtils.rangeContains(5000000.0));
        MatcherAssert.assertThat((Object)result, TestUtils.rangeContains(2000000.0));
        MatcherAssert.assertThat((Object)result, TestUtils.rangeContains(1000000.0));
        MatcherAssert.assertThat((Object)result, TestUtils.rangeContains(500000.0));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.not(TestUtils.rangeContains(200000.0)));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.not(TestUtils.rangeContains(100000.0)));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.not(TestUtils.rangeContains(1.0E-7)));
    }

    @Test
    public void testRangePastEnd() {
        ListZoomContext ctxt = new ListZoomContext(Arrays.asList(5000000.0, 2000000.0, 1000000.0, 500000.0, 200000.0, 100000.0));
        ScaleRange result = ctxt.getRange(Integer.valueOf(3), Integer.valueOf(6));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.not(TestUtils.rangeContains(1.0E7)));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.not(TestUtils.rangeContains(5000000.0)));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.not(TestUtils.rangeContains(2000000.0)));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.not(TestUtils.rangeContains(1000000.0)));
        MatcherAssert.assertThat((Object)result, TestUtils.rangeContains(500000.0));
        MatcherAssert.assertThat((Object)result, TestUtils.rangeContains(200000.0));
        MatcherAssert.assertThat((Object)result, TestUtils.rangeContains(100000.0));
        MatcherAssert.assertThat((Object)result, TestUtils.rangeContains(1.0E-7));
    }

    @Test
    public void testRangeEntirelyPastEnd() {
        ListZoomContext ctxt = new ListZoomContext(Arrays.asList(5000000.0, 2000000.0, 1000000.0, 500000.0, 200000.0, 100000.0));
        ScaleRange result = ctxt.getRange(Integer.valueOf(7), Integer.valueOf(8));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.not(TestUtils.rangeContains(1.0E7)));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.not(TestUtils.rangeContains(5000000.0)));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.not(TestUtils.rangeContains(2000000.0)));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.not(TestUtils.rangeContains(1000000.0)));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.not(TestUtils.rangeContains(500000.0)));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.not(TestUtils.rangeContains(200000.0)));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.not(TestUtils.rangeContains(100000.0)));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.not(TestUtils.rangeContains(1.0E-7)));
    }

    @Test
    public void testRangeEntirelyPastStart() {
        ListZoomContext ctxt = new ListZoomContext(Arrays.asList(5000000.0, 2000000.0, 1000000.0, 500000.0, 200000.0, 100000.0));
        ScaleRange result = ctxt.getRange(Integer.valueOf(-3), Integer.valueOf(-2));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.not(TestUtils.rangeContains(1.0E7)));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.not(TestUtils.rangeContains(5000000.0)));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.not(TestUtils.rangeContains(2000000.0)));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.not(TestUtils.rangeContains(1000000.0)));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.not(TestUtils.rangeContains(500000.0)));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.not(TestUtils.rangeContains(200000.0)));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.not(TestUtils.rangeContains(100000.0)));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.not(TestUtils.rangeContains(1.0E-7)));
    }
}

