/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld.transform.sld;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.yaml.snakeyaml.emitter.Emitable;
import org.yaml.snakeyaml.events.DocumentEndEvent;
import org.yaml.snakeyaml.events.DocumentStartEvent;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.MappingEndEvent;
import org.yaml.snakeyaml.events.MappingStartEvent;
import org.yaml.snakeyaml.events.ScalarEvent;
import org.yaml.snakeyaml.events.SequenceEndEvent;
import org.yaml.snakeyaml.events.SequenceStartEvent;
import org.yaml.snakeyaml.events.StreamEndEvent;
import org.yaml.snakeyaml.events.StreamStartEvent;

public class TracingEmitter
implements Emitable {
    Emitable delegate;
    List<Pair> events = new ArrayList<Pair>();
    int stack = 0;

    public TracingEmitter(Emitable delegate) {
        this.delegate = delegate;
    }

    public void emit(Event event) throws IOException {
        if (event instanceof StreamStartEvent) {
            this.events.add(new Pair(event, this.stack++));
        } else if (event instanceof StreamEndEvent) {
            this.events.add(new Pair(event, --this.stack));
        } else if (event instanceof DocumentStartEvent) {
            this.events.add(new Pair(event, this.stack++));
        } else if (event instanceof DocumentEndEvent) {
            this.events.add(new Pair(event, --this.stack));
        } else if (event instanceof ScalarEvent) {
            this.events.add(new Pair(event, this.stack));
        } else if (event instanceof MappingStartEvent) {
            this.events.add(new Pair(event, this.stack++));
        } else if (event instanceof MappingEndEvent) {
            this.events.add(new Pair(event, --this.stack));
        } else if (event instanceof SequenceStartEvent) {
            this.events.add(new Pair(event, this.stack++));
        } else if (event instanceof SequenceEndEvent) {
            this.events.add(new Pair(event, --this.stack));
        }
        this.delegate.emit(event);
    }

    public void dump(PrintStream out) {
        for (Pair p : this.events) {
            for (int i = 0; i < p.stack; ++i) {
                out.print("\t");
            }
            out.println(p.event);
        }
    }

    static class Pair {
        Event event;
        int stack;

        Pair(Event event, int stack) {
            this.event = event;
            this.stack = stack;
        }
    }
}

