/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld.transform.sld;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.Deque;
import org.geotools.util.Version;
import org.geotools.ysld.Tuple;
import org.geotools.ysld.transform.sld.SldTransformHandler;
import org.geotools.ysld.transform.sld.TracingEmitter;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.emitter.Emitable;
import org.yaml.snakeyaml.emitter.Emitter;
import org.yaml.snakeyaml.events.DocumentEndEvent;
import org.yaml.snakeyaml.events.DocumentStartEvent;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.ImplicitTuple;
import org.yaml.snakeyaml.events.MappingEndEvent;
import org.yaml.snakeyaml.events.MappingStartEvent;
import org.yaml.snakeyaml.events.ScalarEvent;
import org.yaml.snakeyaml.events.SequenceEndEvent;
import org.yaml.snakeyaml.events.SequenceStartEvent;
import org.yaml.snakeyaml.events.StreamEndEvent;
import org.yaml.snakeyaml.events.StreamStartEvent;

class SldTransformContext {
    public static final Version V_100 = new Version("1.0.0");
    public static final Version V_110 = new Version("1.1.0");
    static final Version DEFAULT_VERSION = new Version("1.0.0");
    Version version = DEFAULT_VERSION;
    Writer output;
    Emitable yaml;
    boolean moveToNext;
    Deque<SldTransformHandler> handlers;
    SldTransformHandler last;

    public SldTransformContext(Writer output) {
        this.output = output;
        DumperOptions dumpOpts = new DumperOptions();
        dumpOpts.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        this.yaml = new Emitter(output, dumpOpts);
        this.handlers = new ArrayDeque<SldTransformHandler>();
    }

    public void trace() {
        this.yaml = new TracingEmitter(this.yaml);
    }

    public Emitable emitter() {
        return this.yaml;
    }

    public Writer output() {
        return this.output;
    }

    public SldTransformContext version(String ver) {
        this.version = new Version(ver);
        return this;
    }

    public Version version() {
        return this.version;
    }

    public SldTransformContext reset() {
        this.moveToNext = true;
        return this;
    }

    public SldTransformContext push(SldTransformHandler handler) {
        this.handlers.push(handler);
        this.moveToNext = false;
        return this;
    }

    public SldTransformContext pop() {
        this.moveToNext = false;
        this.last = this.handlers.pop();
        return this;
    }

    public SldTransformHandler last() {
        return this.last;
    }

    public SldTransformContext stream() throws IOException {
        this.yaml.emit((Event)new StreamStartEvent(null, null));
        return this;
    }

    public SldTransformContext document() throws IOException {
        this.yaml.emit((Event)new DocumentStartEvent(null, null, false, null, null));
        return this;
    }

    public SldTransformContext mapping() throws IOException {
        this.yaml.emit((Event)new MappingStartEvent(null, null, true, null, null, DumperOptions.FlowStyle.BLOCK));
        return this;
    }

    public SldTransformContext scalar(String value) throws IOException {
        this.yaml.emit((Event)new ScalarEvent(null, null, new ImplicitTuple(true, false), value, null, null, DumperOptions.ScalarStyle.PLAIN));
        return this;
    }

    public SldTransformContext sequence() throws IOException {
        this.yaml.emit((Event)new SequenceStartEvent(null, null, true, null, null, DumperOptions.FlowStyle.BLOCK));
        return this;
    }

    public SldTransformContext endSequence() throws IOException {
        this.yaml.emit((Event)new SequenceEndEvent(null, null));
        return this;
    }

    public SldTransformContext endMapping() throws IOException {
        this.yaml.emit((Event)new MappingEndEvent(null, null));
        return this;
    }

    public SldTransformContext endDocument() throws IOException {
        this.yaml.emit((Event)new DocumentEndEvent(null, null, true));
        return this;
    }

    public SldTransformContext endStream() throws IOException {
        this.yaml.emit((Event)new StreamEndEvent(null, null));
        this.output.flush();
        return this;
    }

    public SldTransformContext tuple(String first, String second) throws IOException {
        return this.scalar(Tuple.of(first, second).toString());
    }
}

