/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld.transform.sld;

import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.geotools.ysld.transform.sld.SldTransformContext;
import org.geotools.ysld.transform.sld.SldTransformHandler;

public class ExpressionHandler
extends SldTransformHandler {
    StringBuilder scalar;

    ExpressionHandler() {
        this(new StringBuilder());
    }

    ExpressionHandler(StringBuilder scalar) {
        this.scalar = scalar;
    }

    @Override
    public void element(XMLStreamReader xml, SldTransformContext context) throws XMLStreamException, IOException {
        String name = xml.getLocalName();
        if ("Literal".equals(name)) {
            context.push(new LiteralHandler(this.scalar));
        } else if ("PropertyName".equals(name)) {
            context.push(new PropertyNameHandler(this.scalar));
        } else if ("Function".equals(name)) {
            context.push(new FunctionHandler(this.scalar));
        }
    }

    @Override
    public void characters(XMLStreamReader xml, SldTransformContext context) throws XMLStreamException, IOException {
        this.scalar.append(xml.getText());
    }

    @Override
    public void endElement(XMLStreamReader xml, SldTransformContext context) throws XMLStreamException, IOException {
        String name = xml.getLocalName();
        if ("Literal".equals(name) || "PropertyName".equals(name) || "Function".equals(name)) {
            this.onValue(this.scalar.toString().trim(), context).pop();
        } else {
            this.onValue(this.scalar.toString(), context).pop();
        }
    }

    protected SldTransformContext onValue(String value, SldTransformContext context) throws IOException {
        return context.scalar(value);
    }

    static class FunctionHandler
    extends ExpressionHandler {
        FunctionHandler(StringBuilder scalar) {
            super(scalar);
        }

        @Override
        public void element(XMLStreamReader xml, SldTransformContext context) throws XMLStreamException, IOException {
            String name = xml.getLocalName();
            if ("Function".equals(name)) {
                this.scalar.append(xml.getAttributeValue(xml.getNamespaceURI(), "name") + "(");
            } else {
                super.element(xml, context);
            }
        }

        @Override
        public void endElement(XMLStreamReader xml, SldTransformContext context) throws XMLStreamException, IOException {
            String name = xml.getLocalName();
            if ("Function".equals(name)) {
                if ('.' == this.scalar.charAt(this.scalar.length() - 1)) {
                    this.scalar.setLength(this.scalar.length() - 1);
                }
                this.scalar.append(")");
                context.pop();
            }
        }
    }

    static class PropertyNameHandler
    extends ExpressionHandler {
        PropertyNameHandler(StringBuilder scalar) {
            super(scalar);
        }

        @Override
        public void element(XMLStreamReader xml, SldTransformContext context) throws XMLStreamException, IOException {
            if (!"PropertyName".equals(xml.getLocalName())) {
                super.element(xml, context);
            }
        }

        @Override
        public void characters(XMLStreamReader xml, SldTransformContext context) throws XMLStreamException, IOException {
            this.scalar.append("${").append(xml.getText()).append("}");
        }

        @Override
        public void endElement(XMLStreamReader xml, SldTransformContext context) throws XMLStreamException, IOException {
            if ("PropertyName".equals(xml.getLocalName())) {
                context.pop();
            }
        }
    }

    static class LiteralHandler
    extends ExpressionHandler {
        LiteralHandler(StringBuilder scalar) {
            super(scalar);
        }

        @Override
        public void element(XMLStreamReader xml, SldTransformContext context) throws XMLStreamException, IOException {
            if (!"Literal".equals(xml.getLocalName())) {
                super.element(xml, context);
            }
        }

        @Override
        public void characters(XMLStreamReader xml, SldTransformContext context) throws XMLStreamException, IOException {
            this.scalar.append(xml.getText());
        }

        @Override
        public void endElement(XMLStreamReader xml, SldTransformContext context) throws XMLStreamException, IOException {
            if ("Literal".equals(xml.getLocalName())) {
                context.pop();
            }
        }
    }
}

