/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld.parse;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.geotools.styling.ResourceLocator;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.ysld.UomMapper;
import org.geotools.ysld.parse.RootParser;
import org.geotools.ysld.parse.YamlParser;
import org.geotools.ysld.parse.ZoomContextFinder;

public class YsldParser
extends YamlParser {
    List<ZoomContextFinder> zCtxtFinders = Collections.emptyList();
    UomMapper uomMapper = new UomMapper();
    ResourceLocator locator = uri -> {
        try {
            return new URL(uri);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(String.format("'%s' is not a valid URI", uri), e);
        }
    };

    public YsldParser(InputStream ysld) throws IOException {
        super(ysld);
    }

    public YsldParser(Reader reader) throws IOException {
        super(reader);
    }

    public void setZoomContextFinders(List<ZoomContextFinder> zCtxtFinders) {
        this.zCtxtFinders = zCtxtFinders;
    }

    public void setResourceLocator(ResourceLocator locator) {
        this.locator = locator;
    }

    public void setUomMapper(UomMapper uomMapper) {
        this.uomMapper = uomMapper;
    }

    public StyledLayerDescriptor parse() throws IOException {
        HashMap<String, Object> hints = new HashMap<String, Object>();
        hints.put("resourceLocator", this.locator);
        hints.put("uomMapper", this.uomMapper);
        return super.parse(new RootParser(this.zCtxtFinders), hints).sld();
    }
}

