/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld.parse;

import org.geotools.ysld.parse.ContinuousZoomContext;
import org.geotools.ysld.parse.ZoomContext;

public class RatioZoomContext
extends ContinuousZoomContext
implements ZoomContext {
    final int initialLevel;
    final double initialScale;
    final double ratio;

    public RatioZoomContext(double initialScale, double ratio) {
        this(0, initialScale, ratio);
    }

    public RatioZoomContext(int initialLevel, double initialScale, double ratio) {
        if (initialScale <= 0.0) {
            throw new IllegalArgumentException("initialScale must be greater than 0");
        }
        if (ratio <= 1.0) {
            throw new IllegalArgumentException("ratio must be greater than 1");
        }
        this.initialLevel = initialLevel;
        this.initialScale = initialScale;
        this.ratio = ratio;
    }

    @Override
    protected double getScaleDenominator(double level) {
        return this.initialScale / Math.pow(this.ratio, level - (double)this.initialLevel);
    }

    @Override
    protected double getMedialScale(int level) {
        return this.getScaleDenominator((double)level + 0.5);
    }

    @Override
    public boolean isInRange(int level) {
        return true;
    }
}

