/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld.encode;

import java.util.Optional;
import java.util.logging.Logger;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Style;
import org.geotools.util.logging.Logging;
import org.geotools.ysld.encode.RuleEncoder;
import org.geotools.ysld.encode.TransformEncoder;
import org.geotools.ysld.encode.YsldEncodeHandler;

public class FeatureStyleEncoder
extends YsldEncodeHandler<FeatureTypeStyle> {
    static Logger LOG = Logging.getLogger(FeatureStyleEncoder.class);

    public FeatureStyleEncoder(Style style) {
        super(style.featureTypeStyles().iterator());
    }

    @Override
    protected void encode(FeatureTypeStyle featureStyle) {
        this.put("name", featureStyle.getName());
        this.put("title", (Object)Optional.ofNullable(featureStyle.getDescription().getTitle()).map(Object::toString).orElse(null));
        this.put("abstract", (Object)Optional.ofNullable(featureStyle.getDescription().getAbstract()).map(Object::toString).orElse(null));
        if (featureStyle.getTransformation() != null) {
            this.push("transform").inline(new TransformEncoder(featureStyle.getTransformation()));
            this.pop();
        }
        this.put("rules", new RuleEncoder(featureStyle));
        this.vendorOptions(featureStyle.getOptions());
    }
}

