/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.Parameter;
import org.geotools.feature.NameImpl;
import org.geotools.filter.FunctionFactory;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.opengis.feature.type.Name;
import org.opengis.filter.expression.Expression;

public class ProcessUtil {
    static Logger LOG = Logging.getLogger(ProcessUtil.class);

    public static Name processName(String name) {
        String[] split = name.split(":");
        if (split.length == 1) {
            return new NameImpl(split[0]);
        }
        return new NameImpl(split[0], split[1]);
    }

    public static FunctionFactory loadProcessFunctionFactory() {
        Class<?> functionFactoryClass = null;
        try {
            functionFactoryClass = Class.forName("org.geotools.process.function.ProcessFunctionFactory");
        }
        catch (ClassNotFoundException e) {
            LOG.log(Level.WARNING, "Error creating process function factory", e);
            return null;
        }
        try {
            return (FunctionFactory)functionFactoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Error creating process function factory", e);
            return null;
        }
    }

    public static Map<String, Parameter<?>> loadProcessInfo(Name name) {
        Class<?> processorsClass = null;
        try {
            processorsClass = Class.forName("org.geotools.process.Processors");
            Method getParameterInfo = processorsClass.getMethod("getParameterInfo", Name.class);
            return (Map)getParameterInfo.invoke(null, name);
        }
        catch (Exception e) {
            throw new RuntimeException("Error looking up process info", e);
        }
    }

    public static boolean isProcess(Expression expr) {
        Class<?> processClass = null;
        try {
            processClass = Class.forName("org.geotools.process.function.ProcessFunction");
            return processClass.isAssignableFrom(expr.getClass());
        }
        catch (Exception e) {
            throw new RuntimeException("Error looking up process info", e);
        }
    }

    private static boolean hasWMSParam(Map<String, Parameter<?>> processInfo, String name, Class<?> type) {
        Parameter<?> param = processInfo.get(name);
        if (param == null) {
            return false;
        }
        if (!param.getName().equals(name)) {
            return false;
        }
        if (!param.isRequired().booleanValue()) {
            return false;
        }
        return type.isAssignableFrom(param.getType());
    }

    public static boolean hasWMSParams(Map<String, Parameter<?>> processInfo) {
        return ProcessUtil.hasWMSParam(processInfo, "outputBBOX", ReferencedEnvelope.class) && ProcessUtil.hasWMSParam(processInfo, "outputWidth", Integer.class) && ProcessUtil.hasWMSParam(processInfo, "outputHeight", Integer.class);
    }
}

